/	.title	mainp1
	.globl		savreg,resreg
/ mod'd for erase 12/8/73 a.j.swift
/
/ object module for part 1 of main basic interpreter  6 june 72
/
	.globl	begin		/entry point to everything
	.globl	imul00, atoi00,	eval00,	fix00,	itoa00
/
/ globals--error calls
/
	.globl	linerr,	ilcerr,	ovferr,	sbserr,	suberr
	.globl	gpferr,	unmerr,	lnnerr,	csierr,	asserr
/
/ globals--references to other modules
/
	.globl	let00,	read00,	rem00,	run00,	res00
	.globl	ret00,	dim00,	pr00,	gosb00,	goto00
	.globl	if00,	for00,	next00,	inp00,	stop00
	.globl	def00,	rnd01,	run01,	endbas,	do00
	.globl	getb00,	putb00
/
/ globals--internal, defined here 
/
	.globl	prnt00,	crlf00,prln00,	prn00,	tst00
	.globl	skip00,	find00,	squ00,	pck00,	srch00
	.globl	tstu00,	get00,	junk00,	push00,	srl00
	.globl	clru00,	scr00,	aryl00,	dimc00,	getv00
	.globl	mls00,	subs00,	txt00,	two00,	movs00	
	.globl	psh00,	put00,	clos00,	old01	
	
/	
	.globl	init00,	init02,	init03,	init10,	init13
/	
	.globl	endstk,	rndm,	dati,	r5temp
	.globl	lineno,	positn,	runf,	usr
	.globl	lnkaip,	lnkget,	lnkput
	.globl	lnkera,	open00
/	
/ register assignments	
/
/
/	.csect			/start of main body
/
endinp:	clr	r0		/close and exit
	sys	exit
/
/ pack - pck00  get a line from input dataset
/ use old device if initialised, otherwise terminal
/
pck00:	tst	lnkaip		/see if auxiliary inp inited
	bne	pck01		/input from aip if so
	jsr	r5,savreg
	clr	r0
	sys	read;work;80.
	bec	1f
	linerr
1:	tst	r0
	beq	endinp
	jsr	r5,resreg
	br	pck02
pck01:	jsr	r5,savreg
	mov	lnkaip,r0
	sys	read;work;80.
	bec	1f
	linerr
1:	tst	r0
	bne	pck11
	jsr	r5,resreg
	jsr	pc,clos00
	tst	(sp)+		/pop return address
	tst	runf		/in run mode?
	beq	pck13		/skip if not
	jmp	run01		/yes, so run
pck13:	jmp	init00		/return to command mode
pck11:	mov	$work,r1
2:	dec	r0
	bpl	3f
	linerr
3:	cmpb	(r1)+,$12
	bne	2b
	neg	r0
	mov	r0,syseek+2
	mov	lnkaip,r0
	sys	0;syseek
	jsr	r5,resreg
pck02:	mov	$work,r1	/get address of work area
pck03:	movb	(r1)+,r2	/get character
	cmp	$140,r2		/check not too big
	ble	pck09		/error
	cmp	$40,r2		/check not too small
	ble	pck03		/next character
	cmp	$15,r2		/cr ?
	beq	pck04		/yes
	cmp	$12,r2		/allow lf terminator
	beq	pck05		/it is lf
	ilcerr			/illegal character
pck09:	bicb	$40,-1(r1)	/convert to upper case
	br	pck03
pck04:	movb	$12,-(r1)	/replace by lf
pck05:	mov	$work,r1	/reset pointer
	clr	positn		/fix bug by letting basic know of c.r.
	rts	pc
/
/ buffer header for input
/
	.data
work:	.	=.+80.		/reserve 80 bytes
endw	=	.-1		/last byte of work area
lnkaip:		0
		0		/open for reading
filaip:	. = . + 24.		/set by csi
lnkaop:		0		/set when inited
		666		/prot code for create
filaop:		. = . + 24.	/set by csi
lnkget:		0		/pointer set when inited
		0		/open for reading
filget:		. = . +24.	/set by assign
lnkput:		0		/pointer set when inited
		666		/prot code for create
filput:		. = . + 24.
lnkera:	 0
filera:		. = . + 24.
syseek:	sys	seek;0;1
/
/
	.text
/ era00-entry point for erase
era00:	jsr  r0,csint0		/get lnkblk & filblk
	lnkera
	filera
	 0
/
/
	jsr	r5,savreg
	sys	unlink;filera
	jsr	r5,resreg
	jmp	init02	/return

/
/
/
/ printc - prnt00  outputs character in r2
/ on save device if inited, otherwise on terminal
/
prnt00:	inc	positn		/keep track of how many
	cmp	positn,$72.	/check for too long line
	ble	prnt05		/print if lots of room
	mov	r2,-(sp)	/save r2
	mov	r0,-(sp)	/save r0
	jsr	pc,crlf00	/be neat
	mov	(sp)+,r0	/restore r0
	mov	(sp)+,r2	/restore r2
prnt05:	tst	lnkaop		/see if aop inited
	bne	prnt01		/use auxiliary dataset
	movb	r2,charot
	jsr	r5,savreg
	mov	$1,r0
	sys	write;charot;1
	jsr	r5,resreg
	cmp	r2,$12	/extra c.r. bugjsr	pc,fix00
	bne	prnt02
	clr	positn	/bugfix still
	br	prnt02		/go to end
prnt01:
	movb	r2,charsv	/put char in buffer
	jsr	r5,savreg
	mov	lnkaop,r0
	sys	write;charsv;1
	jsr	r5,resreg
prnt02:	inc	rndm		/increment randomize
	rts	pc
/
/ buffer header for terminal output
	.data
/
charot:	.byte	0,13	/character,vertical tab
/
/ buffer for auxiliary output
/
charsv:	.byte	0,13		/character placed here
	.text
/
/
/ jsr     r0,open00  ,initializes and opens at lnk
/ and fil spec following
/
open00:	jsr	r5,savreg
	mov	(r0)+,-(sp)
	mov	(r0)+,r1
	mov	r1,syopen+2
	mov	-(r1),syopen+4
	beq	1f
	mov	$sys+creat,syopen
	br	2f
1:	mov	$sys+open,syopen
2:	sys	0;syopen
	bec	3f
	gpferr
3:	mov	r0,*(sp)+
	jsr	r5,resreg
	cmp	(r0)+,(r0)+
	rts	r0
	.data
syopen:	sys	open;0;2
	.text
/
/
/ jsr  r0,clsone  ,closes and releases dataset if inited
/ one argument, lnkblk
/
clsone:	tst	*(r0)		/is lnkblk inited
	beq	clson1		/skip if not
	jsr	r5,savreg
	mov	*(r0)+,r0
	sys	6		/close
	jsr	r5,resreg
clson1:	clr	*(r0)+
	rts	r0
/
/
/ closer - clos00  closes any open data sets
/
clos00:	jsr	r0,clsone	/close
	lnkaip			/  auxiliary input
	jsr	r0,clsone	/close
	lnkaop			/  auxiliary output
	jsr	r0,clsone	/close
	lnkget			/  get
	jsr	r0,clsone	/close
	lnkput			/  put
	rts	pc
/
/
/ csint0 - command string interpreter routine
/ jsr r0,   with linkblock, filblock, default extension
/
csint0:	clr	*(r0)+		/get link block
	mov	(r0)+,r4	/get file block
	mov	$23.,r3
2:	cmpb	*r1,$12
	beq	1f
	cmpb	*r1,$101
	blt	3f
	bisb	$40,*r1
3:	movb	(r1)+,(r4)+
	sob	r3,2b
1:	clrb	(r4)+
	tst	(r0)+
	rts	r0
/
/
/
/  ass00: - entry point for assign command
/
ass00:	asserr			/no longer implimented !!
/
/
/ tstch - tst00, test alphabetic vs numeric in r2
/	registers used - r2
tst00:	cmp	r2,$'0		/check numeric
	blt	tst03		/non-numeric
	cmp	r2,$'9		/check alpha
	bgt	tst01		/non-numeric
	sez			/set zero code if numeric
	rts	pc
tst01:	cmp	r2,$'A		/alphabetic?
	blt	tst03		/no
	cmp	r2,$'Z		/alphabetic?
	bgt	tst03		/no
	clv|clc|cln|clz		/set non-zero code if alphabetic
	rts	pc
tst03:	clv|cln|clz|clc
	sev			/set
	rts	pc		/overflow if neither
/
/
/ routine to type <cr,lf>
/	register used - r2.
/
crlf00:	mov	$-1,positn	/clear the position to allow a full line
	mov	$rdy01,r0	/get address of <cr,lf>
/
/ printl - prn00 - print a line of ascii
/	r0 has starting address, line is terminated by a zero byte
/	registers used - r0,r2.
prn00:	movb	(r0)+,r2	/get a character
	beq	prn01		/exit if done
	jsr	pc,prnt00	/print it
	br	prn00		/loop
prn01:	rts	pc
/
/ skip - skip00, skip over blanks in working storage, r1 points
/  to line position, character found goes to r2
/	registers used - r1,r2.
/
skip00:	movb	(r1)+,r2	/get a character
	cmpb	$' ,r2		/is it blank?
	beq	skip00		/yes, get another
	rts	pc
/
/ junkit - junk00, skip over remainder of line
/	until <lf> or ":" is found.
/  r1 points to terminator on exit.
/	registers used - r1.
/
junk00:	cmpb	*r1,$':		/is character a ":"?
	beq	junk01		/jump if yes
	cmpb	(r1)+,$12	/is it a <lf>?
	bne	junk00		/no, look again
	dec	r1		/yes, back up pointer one place
junk01:	rts	pc
/
/ clrusr - clru00, check for existence of user space, and delete
/  it if present.  registers used - r5.
/
clru00:	clr	dati		/clear out data pointer
	tst	endtxt		/is the user space set up?
	beq	clru01		/jump if not
	mov	endtxt,r5	/delete it
	mov	r5,r5temp	/save for restart
	clr	endtxt		/  if it is.
clru01:	rts	pc
/
/ pshnam, psh00 - push a dummy variable on the user list
/
psh00:	jsr	pc,push00	/put the name on thelist
	clr	r0		/clear a cell
	jsr	pc,push00	/push a zero dimension
	mov	r5,r0
	jsr	pc,push00	/push three more
	jsr	pc,push00	/nothings on
	jsr	pc,push00	/the user list
	rts	pc		/ and return
/
/ putawy, put00 - push a value on the user list
/
put00:	mov	r2,r0		/put
	jsr	pc,push00	/ the
	mov	r3,r0		/  value
	jsr	pc,push00	/   away
	mov	r4,r0		/    properly
	jsr	pc,push00
	rts	pc		/and return
/
/ push - push00, push one word in r0 on user storage list
/	if endtxt=0 on entry, save r5 in endtxt first
/	if r5 is odd, move to next even boundary
/	r5 is updated when item is placed on the list
/	registers used - r0,r5.
/
push00:	cmp r5,endusr		/check for room
	bhi	push02		/overflow
	tst	endtxt		/is user area intact
	bne	push01		/yes, skip over init.
	mov	r5,endtxt	/otherwise remember where text ends
	inc	r5		/make the
	asr	r5		/ address
	clc			/  in r5
	asl	r5		/  an even number
push01:	mov	r0,(r5)+	/put one word on the list
	mov	r5,r5temp	/save for restart
	rts	pc
push02:	ovferr
/
/ srlst - srl00, search user storage for the first item having the
/	class as specified in r4.  the address of the found item is
/	returned in r3.  upon entry, r3 must point to the start address
/	of the list.  registers used - r0,r1,r2,r3,r4.
/	and r0 is a mask of bits to ignore in the header.
/
srl01:	mov	*r3,r0		/get item on top of list
	bic	*sp,r0		/clear out the junk
	cmp	r0,r4		/are the classes the same?
	beq	srl05		/exit if yes
	bic	$017777,r0	/now mask off all other stuff
	cmp	$040000,r0	/find the current class
	bne	srl02		/jump if not class two
	add	$20,r3		/jump over 8 items for class two
	br	srl08
srl00:	tst	r3
	beq	srl06
	cmp	r5,endusr	/check for space
	bhi	push02		/overflow
	mov	r1,-(sp)	/save text pointer
	mov	r0,-(sp)	/save mask
srl08:	cmp	r3,endusr	/has the search overflowed?
	bhi	push02		/yes, go away and die nicely
	cmp	r3,r5		/out of space?
	blo	srl01		/no
	clr	r3		/yes, quit - set not found
srl05:	mov	(sp)+,r0	/restore mask
	mov	(sp)+,r1	/restore text pointer
	tst	r3		/set status bits on result of search
srl06:	rts	pc
srl02:	bgt	srl03		/jump if class 0 or 1
	add	$2,r3		/class 3 here - skip over item
srl07:	add	$4,r3		/skip over 2 words
	br	srl08		/and re-loop
srl03:	tst	r0		/check for class 0
	beq	srl04
	tst	(r3)+		/class one, skip item
	br	srl08		/and return
srl04:	movb	2(r3),r0	/item is class zero, work is needed
	movb	3(r3),r1	/get both operands
	jsr	pc,aryl00	/compute array length
	add	r0,r3		/skip over proper number of items
	br	srl07
/
/ arylg - aryl00, compute array length - first dim in r0, second in
/	r1, result returned in r0.  registers used - r0,r1,r2,r3.
/
aryl00:	bic	$177400,r0	/clear both
	bic	$177400,r1	/sign extensions if any
	inc	r0		/add one
	inc	r1		/ to each and
	mov	r4,-(sp)
	mov	r3,-(sp)
	jsr	pc,imul00	/multiply them
	mov	(sp)+,r3
	mov	(sp)+,r4
	tst	r1		/did the multiply get too big???
	bne	aryl01		/jump if yes
	cmp	r0,$22000	/is array longer than is possible?
	bhis	aryl01
	jsr	pc,mls00	/multiply result by six
	clv|clc|cln|clz
	rts	pc		/return
aryl01:	sev
	rts	pc		/set error if impossible array
/
/ scrnch - scr00, delete the number of bytes from the user storage
/	specified by r4.  r3 points to starting point for the
/	deletion.  registers used - r1,r2,r3,r4,r5.
/
scr00:	mov	r3,r1		/get two
	mov	r1,r2		/copies of the pointer
	add	r4,r1		/reset the real pointer
	br	squ01		/go squish it
/
/ squish - squ00, delete one line of text pointed to by r1
/  r1 is not destroyed, r2 and r3 are used for scratch
/ r5 is updated when done.  registers used - r1,r2,r3,r5.
/
squ00:	jsr	pc,clru00	/clear the user space if any
	mov	r1,r3		/get two copies
	mov	r1,r2		/ of the pointer
	jsr	pc,srch00	/find end of line
squ01:	cmp	r1,r5		/check completion of squeeze
	bhis	squ02		/jump if done
	movb	(r1)+,(r3)+	/move a character
	br	squ01		/move the whole chunk
squ02:	mov	r3,r5		/update user pointer
	mov	r5,r5temp	/save for restart
	mov	r2,r1		/restore r1
	rts	pc
/
/ srchlf - srch00, search for <lf>, pointer in r1, when done r1
/  points one byte after the <lf>.  registers used - r1.
/
srch00:	cmpb	(r1)+,$12	/is this char a line feed?
	bne	srch00		/no
	rts	pc
/
/ findln - find00, find the line number in the text which corresponds
/  to the number specified in r0.  if found, set zero code and return,
/  r1 points to beginning of line.  if not found, set non-zero, return
/  with r1 pointing to the logical insertion point for a new
/  line with the specified number.  
/  registers used - r0,r1,r2,r3,r4,r5.
/
find00:	mov	usr,r1		/start looking at beginning of text
find01:	jsr	pc,srch00	/go to start of line
	cmp	r1,r5
	bhis	find05		/jump if end of text
	mov	r0,-(sp)	/save line number
	mov	r1,-(sp)	/save line pointer
	jsr	pc,atoi00	/get line number from text
	mov	(sp)+,r1	/restore line pointer
	mov	r0,r2
	mov	(sp)+,r0
	cmp	r0,r2		/do line numbers match?
	beq	find03		/yes
	bgt	find01		/keep looking
find02:	clv|cln|clz|clc		/set not equal
find03:	rts	pc
find05:	clv|cln|clz|clc
	sev			/set overflow on overflow
	rts	pc
/
/ getvar - getv00, get a variable and pack it in truncated ascii into
/	r4.  on return r4 has variable, r2 has next character.
/	registers used - r1,r2,r4.
/
getv00:	jsr	pc,skip00	/get a character
	jsr	pc,tst00	/alphabetic?
	beq	getv99		/no
	bvs	getv99		/no
	bic	$177700,r2	/truncate it
	mov	r2,r4		/and
	swab	r4		/pack it in
	asr	r4		/the
	asr	r4		/header word
	jsr	pc,skip00	/get next character
	jsr	pc,tst00	/numeric?
	bne	getv01		/no
	bis	r2,r4		/yes, zot it into the header
	jsr	pc,skip00	/get another character
getv01:	clv|cln|clz|clc
	rts	pc		/return ok
getv99:	sev			/set overflow for bad variable
	rts	pc
/
/ dimchk - dimc00, make sure dimension in r0 is in bounds 0 to 255
/	registers used - r0.
/
dimc00:	tst	r0		/dim .lt. 0?
	blt	find02		/yes
	cmp	r0,$377		/greater than 255?
	bgt	find02		/yes
	sez			/set equal code if in bounds
	rts	pc
/
/ getnum - get00, get parameters for command
/  r1 points to start of user area, r3 returns first parameter, r4
/  returns second.  registers used - r0,r1,r2,r3,r4.
/
get00:	jsr	pc,skip00	/get one character
	jsr	pc,tst00	/is it numeric
	bne	get01		/no, look for comma
	dec	r1		/yes, reposition character pointer
	jsr	pc,atoi00	/convert first argument
	mov	r0,-(sp)	/save it
	jsr	pc,skip00	/get the separator
get04:	cmp	$',,r2		/is it a real separator?
	bne	get02		/no
	jsr	pc,atoi00	/convert second argument
	tst	r0
	beq	get02		/second parameter is zero
	mov	r0,r4
get03:	mov	(sp)+,r3	/set up first argument
	rts	pc
get01:	clr	-(sp)		/no arguments
	br	get04
get02:	clr	r4		/set them to zero
	br	get03
/
/ save command, does effective list on save dataset
/ save dataset=pp: or as set by csint0
/
save00:	jsr	pc,skip00	/get next character
	dec	r1		/reset text pointer
	jsr	r0,csint0	/get file specifications
	lnkaop			/link block address
	filaop			/file block address
	0			/default extension
	jsr	r0,open00	/open at
	lnkaop			/auxiliary output
	filaop
	jmp	list00		/go and list
	jmp	list00

/
/ old command, restarts interpreter on old file
/ back to normal input via closer, on eom fromjsr	pc,pck00
/ or on execution of immediate command
/
old00:	clr	runf		/turn off run flag
	jsr	pc,skip00	/get next character
	dec	r1		/reset text pointer
old01:	jsr	r0,csint0	/get file specs
	lnkaip
	filaip
	0			/default extension
	mov	usr,r5		/delete all
	inc	r5		/leave original lf
	mov	r5,r5temp	/save for restart
	clr	endtxt		/clear endtext
	clr	lineno		/clear line number
	jsr	r0,open00	/open for old
	lnkaip
	filaip
	jmp	init04		/back to interpreter
/
/
/ tstok - tstu00, check for possible user storage overflow
/  r0 has number of bytes to enter.  registers used - r0,r3,r4,r5.
/
tstu00:	mov	r5,r4		/get end of user storage
	add	r0,r4		/compute extension
	mov	endusr,r3	/get end of buffer
	sub	$70,r3		/subtract expansion fudge
	cmp	r3,r4		/if sp-fudge .ge. r5+r0 all is ok
	rts	pc
/
/ subscr - subs00, compute a subscript expression - upon entry, r1
/	points to the ascii character string starting with the
/	left paren, r3 points to the address of two standard format
/	subscripts.  upon exit, r0 points to the desired location
/	r3 is unchanged, and r1 points to a non-blank character
/	following the closed paren.
/	registers used - r0,r1,r2,r3,r4.
/
subs00:	mov	r3,-(sp)
	jsr	pc,eval00	/evaluate the first subscript
	bvs	subs01		/skip if paren found
	cmpb	*r1,$',		/otherwise make sure
	bne	subs98		/comma is there
	jsr	pc,subs03
	jsr	pc,skip00	/yes
	mov	r0,-(sp)	/save verified subscript
	jsr	pc,eval00	/get the second subscript
	bvc	subs98		/jump if no closed paren
	jsr	pc,fix00	/and fix it
	bmi	subs99
	mov	(sp)+,r2	/get the
subs02:	mov	*(sp),r4	/second
	bic	$177400,r4	/subscript limit
	cmp	r0,r4		/out of range?
	bgt	subs99		/yes
	mov	r1,-(sp)	/no, save text pointer
	mov	r2,r1		/first subscript
	mov	r0,-(sp)	/save second subscript
	mov	r4,r0		/get y.max
	inc	r0
	jsr	pc,imul00	/get x*(y.max+1)
	add	(sp)+,r0	/compute actual position of variable
	jsr	pc,mls00	/  here and multiply by six
	mov	(sp)+,r1	/restore character pointer
	add	*sp,r0		/compute
	tst	(r0)+		/ absolute address of number
	mov	(sp)+,r3	/restore r3
	rts	pc
subs01:	jsr	pc,subs03
	mov	r0,r2		/save first subscript
	clr	r0		/set second subscript to zero
	br	subs02		/go back to main line
subs98:	sbserr			/badly formed subscript
subs99:	suberr			/subscript out of range
subs03:	jsr	pc,fix00	/fix it
	bmi	subs99
	mov	*2(sp),r4	/get both subscript limits
	swab	r4		/i want the first one only
	bic	$177400,r4	/ only
	cmp	r0,r4		/ out of range?
	bgt	subs99		/yes
	rts	pc
/
/
/ prntln - prln00 - print line number
/	registers used - r0,r1,r2,r3,r4.
/
prln00:	sub	$10,sp		/destination
	mov	sp,r0		/  is on the stack
	mov	lineno,r1	/source
	jsr	pc,itoa00	/convert to ascii
	mov	sp,r0		/print the resulting
	tst	(r0)+		/  droping the first two digits
	clrb	7(sp)		/    set the end of the number
	jsr	pc,prn00	/print number
	add	$10,sp		/restore the stack
	rts	pc
/
/ mulsix - mls00, multiply r0 by six.  registers used - r0.
/
mls00:	clc			/wipe out a carry
	asl	r0		/multiply by two
	mov	r0,-(sp)	/save it
	asl	r0		/now make it 4x
	add	(sp)+,r0	/4x+2x=6x
	rts	pc
/
/ txtadr - txt00, get even start of user storage to r3
/	registers used - r3.
/
txt00:	mov	endtxt,r3	/get end of text
	inc	r3
	asr	r3		/round
	clc			/ it
	asl	r3		/  up to next even address
	rts	pc
/
/ twochr - two00, pack next two characters in r4.
/	registers used - r1,r2,r4.
/
two00:	jsr	pc,skip00	/get first character
	mov	r2,r4		/put it in
	swab	r4		/ high byte of r4
	jsr	pc,skip00	/get second character
	bis	r2,r4		/ and pack it too.
	rts	pc
/
/ movstk - movs00, move registers r4,r3, and r2 on the stack
/
movs00:	mov	r3,-(sp)	/put
	mov	r2,-(sp)	/ the
	mov	4(sp),-(sp)	/  stuff
	mov	r4,6(sp)	/   on the stack
	rts	pc		/return
/
/
/ list - list00, list the source text
/	registers used - r1,r2,r3,r4,r5
/
list00:	jsr	pc,clru00
	jsr	pc,get00	/get the parameters
	mov	r3,r0
	bne	list03
list05:	mov	usr,r3
	tst	r4		/is second parameter zero also?
	bne	list07		/no
list04:	mov	r5,r4
list01:	movb	(r3)+,r2	/get character
	cmpb	r2,$140		/is it a packed verb?
	blt	list08		/jump if not
	sub	$140,r2		/generate verb number
	mov	$init11,r0	/get prototype list
	mov	r2,r1
list09:	dec	r1		/decrement verb count
	blt	list11		/if found go print the verb
list10:	cmpb	(r0)+,$'_	/find prototype end to get to
	bne	list10		/ the next
	br	list09		/  verb in the list
list11:	movb	(r0)+,r2	/get a character
	cmpb	r2,$'_		/quit if end of prototype
	beq	list01
	jsr	pc,prnt00	/otherwise type the character
	br	list11
list08:	cmpb	r2,$12		/line terminator?
	beq	list02
	jsr	pc,prnt00
	br	list01		/re-loop
list02:	jsr	pc,crlf00	/output <cr,lf>
	cmp	r3,r4
	blo	list01
	jsr	pc,clos00	/in case a save
	jmp	init00		/go back to interpreter
list03:	mov	r4,-(sp)	/save r4
	jsr	pc,find00	/find start line
	mov	(sp)+,r4	/restore r4
	cmp	r1,r5		/no such line?
	bhis	list05		/no such line found
	mov	r1,r3		/start address to r3
list07:	cmp	r4,r0		/check last argument against first
	ble	list06		/jump if .le. first argument
	mov	r4,r0
	mov	r3,-(sp)	/
	jsr	pc,find00	/get position of second line
	bne	list12
	mov	(sp)+,r3
	cmp	r1,r5		/at end of text?
	bhis	list04		/yes
list06:	jsr	pc,srch00	/no, find end of current line
list13:	mov	r1,r4
	br	list01
list12:	mov	(sp)+,r3
	cmp	r1,r5
	bhi	list04
	br	list13
/
/
/ delete, del00, delete text as specified by the command parameters
/	registers used - r0,r1,r2,r3,r4,r5.
/
del00:	jsr	pc,clru00	/clear the user area just in case
	jsr	pc,get00	/get the parameters
	mov	usr,r1		/set to start of user area
	tst	r4		/is second parameter present?
	bne	del05		/yes
	mov	r3,r4		/no
del05:	mov	r4,-(sp)	/r4=second parameter
	mov	r3,-(sp)	/r3=first parameter
del01:	jsr	pc,srch00	/find the next line
del03:	cmp	r1,r5		/all done?
	bhis	del02		/yes
	mov	r1,-(sp)	/save pointer
	jsr	pc,atoi00
	mov	(sp)+,r1	/restore it
	cmp	r0,*sp		/compare line numbers
	blt	del01
	cmp	r0,2(sp)	/compare with end of list
	bgt	del02
	jsr	pc,squ00	/delete one line
	br	del03
del02:	cmp	(sp)+,(sp)+	/pop two words from stack
	jmp	init00
/
/ pdp-11 basic - command/statement interpreter
/	registers used - r0,r1,r2,r3,r4,r5
/
init02:	jsr	pc,skip00	/get the next character
	cmpb	$':,r2		/is this a continuation?
	beq	init10		/jump if yes
	cmpb	$12,r2		/is it a line feed
	beq	init03		/jump if yes
	ilcerr			/illegal character terminating stmt.
init03:	tst	runf		/is run mode set
	beq	init04		/jump if not
	tst	endtxt		/is user area set up?
	beq	init19		/no, do different test
	cmp	r1,endtxt	/is the text pointer too far along?
	br	init20
init19:	cmp	r1,r5
init20:	bhis	stop03		/jump if yes
init13:	jsr	pc,atoi00	/find real line number
	mov	r0,lineno
	br	init10
begin:	mov	$endbas,usr	/      area
	.globl	emt00
	sys	signal;7;emt00
	mov	usr,r1		/set up text pointer
	mov	r1,r5		/set up user list pointer
	movb	$12,(r5)+	/with lf in first text byte
	mov	r5,r5temp	/save for restart
	mov	sp,endstk	/save for zapping
	mov	$msg001,r0	/initial message
	jsr	pc,prn00	/print it
	clr	endtxt		/for re-entry
	clr	lineno		/clear the line number
	sys	signal;2;restrt	/catch rub out and restart
	br	init00
restrt:	sys	signal;2;restrt /catch next one too
	jsr	pc,clos00	/release any open datasets
	mov	r5temp,r5	/restore r5 list pointer
	jmp	stop00		/do stop
init00:	clr	runf		/clear run flag to start
	mov	$rdy00,r0	/tell user that
	jsr	pc,prn00	/all is ready
	clr	positn		/reset to begin of line
init04:	jsr	pc,pck00	/get a command
	jsr	pc,skip00	/get the first character
	cmp	r2,$12		/ignore if only a terminator
	beq	init04
	mov	$work,r1	/get text pointer
	jsr	pc,atoi00	/get internal line number
	cmpb	*r1,$12		/call it a delete if no
	bne	init05
	jsr	pc,clru00	/clear user space
	jsr	pc,find00	/find the line number
	bne	init04		/no such line
	jsr	pc,squ00	/found,delete it
	br	init04
init05:	mov	r1,r3		/save the text pointer
	mov	$init11,r0	/get address of prototypes
	clr	r2		/clear jump pointer flag
init06:	cmpb	(r3)+,$' 	/is character a space?
	beq	init06		/ignore spaces
	cmpb	-(r3),(r0)+	/does character match prototype
	bne	init08		/no
	inc	r3		/yes, get next character
	cmpb	*r0,$'_		/is next character the terminator?
	beq	init14		/if so, exit successfully
	br	init06		/go back
init08:	cmpb	(r0)+,$'_	/skip to start of next
	bne	init08		/  prototype
	cmpb	*r0,$'_		/two in a row?
	beq	init09		/yes, end of list
	mov	r1,r3		/reset text pointer
	inc	r2		/increment jump pointer
	br	init06		/re-loop
init10:	jsr	pc,skip00	/get verb
	sub	$140,r2		/get address displacement
	bmi	init09
	asl	r2
	jmp	*init12(r2)	/go do it
stop03:	jmp	stop00
init09:	mov	$141,r2		/fake a "let"
	mov	r1,r3		/look
1:	cmpb	(r3)+,$12	/for
	bne	1b		/eol
2:	movb	-(r3),1(r3)	/make	room
	cmp	r3,r1		/for code
	bne	2b		/until	done
	movb	r2,(r1)+	/put in code
	br	init23		/now normal "let"
init14:	add	$140,r2		/generate special byte
	movb	r2,(r1)+	/store it in the text
	mov	r1,r4		/remember place in line
init15:	movb	*r3,(r1)+	/jsr	pc,pck00
	cmpb	(r3)+,$12	/ line up tight
	bne	init15
	cmp	r2,$164		/end of line fence
	bge	init27		/quit if past
	cmp	r2,$153		/is this line an "if"?
	bne	init18		/no, exit.
	mov	r4,r1		/start scan for "then"
init16:	jsr	pc,skip00
	cmpb	r2,$'T		/it starts with a "t"
	bne	init17
	jsr	pc,skip00
	cmpb	r2,$'H		/followed by an "h"
	bne	init17
	jsr	pc,skip00
	cmpb	r2,$'E		/then an "e"
	bne	init17
	jsr	pc,skip00
	cmpb	r2,$'N		/finally an "n"
	bne	init17		/go back and scrunch it too
init21:	jsr	pc,skip00	/make leading blanks safe
	dec	r1		/before modifying statement
	mov	r1,r4		/this keeps me from an infinite loop
	jsr	pc,tst00	/if the "then" is followed by a
	beq	init18		/  number it is legal
	br	init05
init17:	cmpb	r2,$12		/end of line?
	beq	init27		/no
	cmpb	r2,$':		/alternate end of line?
	bne	init16		/no
init18:	mov	r4,r1		/reset the pointer
init23:	cmpb	*r1,$'"		/is character start of quote string?
	beq	init24		/yes
	cmpb	(r1)+,$':	/no, is it a statement separator?
	beq	init21		/yes
	cmpb	-(r1),$12	/then is it a terminator?
	beq	init22		/yes
init25:	inc	r1		/no
	br	init23
init24:	inc	r1
	cmpb	*r1,$'"		/is this the second "?
	beq	init25		/yes
	cmpb	*r1,$12		/no, end of line?
	bne	init24		/no
	unmerr			/unmatched quotes in line
init22:	inc	r1
init27:	mov	r1,r3		/save end of line pointer
	mov	$work,r1	/yes, continue main loop
	jsr	pc,skip00	/get first character
	jsr	pc,tst00	/is it numeric?
	beq	assm00		/yes, go assemble line
	dec	r1		/otherwise do it immediately
	br	init10
/
/ assemble line of code into working storage - transfer to user area
/	registers used - r0,r1,r2,r3,r4.
/
assm00:	jsr	pc,clru00	/clear user space if any
	mov	$work,r1	/get storage address
	sub	r1,r3		/get line length
	mov	r3,-(sp)	/save it
	jsr	pc,atoi00	/ascii to integer in r0
	tst	r0		/is line number zero?
	beq	assm02		/yes, disallowed
	cmp	r0,$17777	/line number .gt. 8191?
	bgt	assm02	/yes, disallowed
	jsr	pc,find00	/look for line number in text
	bne	assm01		/don't delete line
	jsr	pc,squ00	/delete text line to terminator
assm01:	mov	(sp)+,r3	/restore line length
ins00:	jsr	pc,clru00	/clear user space if any
	mov	r3,r0
	jsr	pc,tstu00	/enough room in user storage?
	bhis	ins01		/yes
	ovferr			/overflow error
ins04:	add	r0,r5		/update text pointer
	mov	r5,r5temp	/save for restart
	br	ins05
ins01:	cmp	r1,r5		/is pointer at end of text?
	bhis	ins04		/jump if yes
	mov	r5,r2
	add	r0,r5		/move storage pointer
	mov	r5,r5temp	/save for restart
	mov	r5,r4
ins02:	movb	-(r2),-(r4)	/shift the text around
	cmp	r1,r2		/done?
	blos	ins02		/no, do it again
ins05:	mov	$work,r2
ins03:	movb	*r2,(r1)+	/insert new text
	cmpb	(r2)+,$12	/check for line terminator
	bne	ins03
	jmp	init04		/back for next line
assm02:	lnnerr			/bad line number
init11:		<LIST_>		/140
		<LET_>		/141
		<READ_>		/142
		<RESTORE_>	/143
		<RETURN_>	/144
		<DATA_>		/145
		<DIM_>		/146
		<DELETE_>	/147
		<PRINT_>	/150
		<GOSUB_>	/151
		<GOTO_>		/152
		<IF_>		/153
		<FOR_>		/154
		<NEXT_>		/155
		<INPUT_>	/156
		<DEF_>		/157
		<RANDOMIZE_>	/160
		<DO_>		/161
		<GET_>		/162
		<PUT_>		/163
		<REM_>		/164	/FENCE
		<RUN_>		/	/FOR
		<STOP_>		/	/END
		<END_>		/	/OF
		<SAVE_>		/	/LINE
		<OLD_>		/	/COMMANDS
		<ASSIGN_>
	 <ERASE_>
		<_>		/END OF LIST
	.even
/
init12:	list00		/140 - list
	let00		/141 - let
	read00		/142 - read
	res00		/143 - restore
	ret00		/144 - return
	rem00		/145 - data as remark
	dim00		/146 - dimension
	del00		/147 - delete
	pr00		/150 - print
	gosb00		/151 - gosub
	goto00		/152 - goto
	if00		/153 - if
	for00		/154 - for
	next00		/155 - next
	inp00		/156 - input
	def00		/157 - define
	rnd01		/160 - randomize
	do00		/161 - do
	getb00		/162 - get
	putb00		/163 - put
	rem00		/164 - remark	/fence
	run00		/165 - run	/for
	stop00		/166 - stop	/end
	stop00		/167 - end	/of
	save00		/170 - save	/line
	old00		/171 - old	/commands
	ass00		/172 - assign
	era00		/173 - erase
/
/ system variables defined or stored here
	.data
/ usr and endusr set up at beginning of program
/
usr:		0	/first word of user area
endusr:		end	/last  word of user area
lineno:		0	/temporary line number cell
runf:		0	/run flag
endtxt:		0	/end of user text
dati:		0	/data statement position pointer
positn:		0	/character pointer on output
rndm:		1	/randomize word
endstk:	 0		/bottom of stack
r5temp:		0	/temporary r5 storage for restart
/
rdy00:		<ready>
rdy01:	.byte	12,0
msg001:		<basic-11 v002b>
	.byte	12,0
	.even
	.bss
endbas:	. = . + 14000.
end:
