/	.title trphdl
	.globl		savreg,resreg
	.globl		clos00,	crlf00,	prn00,	prln00,	clru00
/
/ basic emt handler object module 31 may 72
/ provides
/ error handling
/
/
/ globals for error emt calls
/
	.globl	ovferr,	unrerr,	goerr,	ilcerr,	reterr
	.globl	sbserr,	suberr,	parerr,	leterr,	oprerr
	.globl	iferr,	prnerr,	linerr,	dimerr,	dmverr
	.globl	deferr,	lnnerr,	dmderr,	inperr,	reaerr
	.globl	re1err,	re2err,	forerr,	nxterr,	nxmerr
	.globl	unmerr,	exferr,	ilferr,	argerr,	undaer
	.globl	csierr,	doerr,	asserr,	geterr,	gt1err
	.globl	puterr,	gpferr
/
	.globl	logerr,	sqrerr,	dvferr,	fixerr,	nxverr
	.globl	in1err,	in2err,	in3err
/
/
/ global program externals
/
	.globl	endstk,	stop02,	r5temp,	open00
/
/ basic  error handler - all 
/	error calls in basic are made by
/	emt calls 
/
/	  all error calls will be odd.  the lower 8 bits of an
/	error call is the error number multiplied by two plus one
/	(e.g. - error $5 has a coded value of 013).  errors numbered 
/	from 0 to "fence" inclusive are fatal.  errors from "fence"+1
/	to 127 are non-fatal.
/
/ the following is a list of implemented error calls.  all errors less
/	than "fence" are fatal, all greater are non-fatal.
/
fence	=	100	/boundary between fatal and non-fatal.
/
/ fatal error calls
/
emt	=	104000
ovferr	=	emt+1		/user storage overflow - 0
unrerr	=	ovferr+2	/unrecognized statement - 1
goerr	=	unrerr+2	/illegal goto or gosub - 2
ilcerr	=	goerr+2		/illegal character terminating stmt - 3
reterr	=	ilcerr+2	/return without gosub - 4
sbserr	=	reterr+2		/badly formed subscript - 5
suberr	=	sbserr+2	/subscript out of range - 6
parerr	=	suberr+2	/mismatched parentheses - 7
leterr	=	parerr+2	/illegal let - 8
oprerr	=	leterr+2	/illegal relational operator in if - 9
iferr	=	oprerr+2	/illegal if - 10
prnerr	=	iferr+2		/illegal print - 11
linerr	=	prnerr+2	/input line too long - 12
dimerr	=	linerr+2	/bad dimension - 13
dmverr	=	dimerr+2	/not enough room in storage for the array - 14
deferr	=	dmverr+2	/badly formed define - 15
lnnerr	=	deferr+2	/illegal line number or dimension value - 16
dmderr	=	lnnerr+2	/dim of previously declared or used item - 17
inperr	=	dmderr+2	/bad variable in input list - 18
reaerr	=	inperr+2	/bad variable in read list - 19
re1err	=	reaerr+2	/out of data - 20
re2err	=	re1err+2	/bad format in a data statement - 21
forerr	=	re2err+2	/illegal for statement - 22
nxterr	=	forerr+2	/no next matching for - 23
nxmerr	=	nxterr+2	/next without for - 24
unmerr	=	nxmerr+2	/unmatched quotes in statement - 25
exferr	=	unmerr+2	/external function not properly set up - 26
ilferr	=	exferr+2	/ill formed expression - 27
argerr	=	ilferr+2	/argument error - 28
undaer	=	argerr+2	/undefined acq fun-29
csierr	=	undaer+2	/command string error -30
doerr	=	csierr+2	/error in do command - 31
asserr	=	doerr+2		/assign syntax - 32
geterr	=	asserr+2	/get syntax - 33
gt1err	=	geterr+2	/out of data - 34
puterr	=	gt1err+2	/put syntax - 35
gpferr	=	puterr+2	/file error - 36
/
/ jon-fatal error calls
/	
logerr	=	emt+377	/log of negative or zero number - 127
sqrerr	=	logerr-2	/square root of negative number - 126	
dvferr	=	sqrerr-2	/div.-mul. overflow or underflow - 125	
fixerr	=	dvferr-2	/number too large to fix ) 124	
nxverr	=	fixerr-2	/joj-existent variable ) 123
in1err	=	nxverr-2	/tkk much data typed ) 122	
in2err	=	in1err-2	/jkt enkugh data typed ) 121	
in3err	=	in2err-2	/ihlegah characters oj input - 120
/	
/ end of diagjkstic calhs	
/	
/	
/	
/ emt and error handler
/	fatal errkrs wipe out the system stack and return to the
/	command interpreter after giving the diagnkstic*  non-fatal	
/	errors return to the calling routine.
/ register assignments	
/
/
/	.asect
/	.	=30		/set up emt vector
/	.word	emt00,0	/to emt routine
	.globl	emt00
/
/	.csect			/main of trphdl
emt00:	jsr	r5,savreg
	sys	signal;7;emt00	/continue to catch emt's
	jsr	r5,resreg
	mov	*sp,2(sp)	/get rid of unused status
	sub	$2,*sp		/point to location of emt
	mov	*(sp)+,-(sp)	/get the emt instruction
	asr	*sp		/is it an error call?
	bcs	errr00		/jump if error call
	mov	$99.,*sp	/make a sub call an error
/
errr00:	bic	$177600,*sp	/get error code
	mov	(sp)+,r2
	cmp	r2,$fence	/is it fatal?
	bgt	errr01		/jump if non-fatal
	jsr	pc,clos00	/in case from old
	mov	endstk,sp	/zap the stack
	mov	r5temp,r5	/restore r5
	mov	$stop02,-(sp)	/get new return address
errr01:	mov	r1,-(sp)	/save text pointer
	mov	r2,r1
	mov	r1,-(sp)	/save error number
	tst	lnkdgn		/check open
	bne	1f		/yes
	jsr	r5,savreg
	sys	open;fildgn;0	/do open
	mov	r0,lnkdgn
	jsr	r5,resreg
1:	mov	lnkdgn,r0	/descriptor
	ash	$5,r1		/record num*32
	mov	r1,seeksys+2	/for seek
	jsr	r5,savreg
	sys	0;seeksys	/do seek
	mov	lnkdgn,r0
	sys	read;errr03;32.	/do read
	jsr	r5,resreg
	jsr	pc,crlf00
	mov	$errr03,r0	/start of message
	jsr	pc,prn00	/print the line
	jsr	pc,prln00	/and the line number
	jsr	pc,crlf00
	tst	(sp)+		/get the error code
	bne	errr04		/is it overflow?
	jsr	pc,clru00	/yes, clear the data area
errr04:	mov	(sp)+,r1	/restore r1
	rts	pc		/and return
	.data
errr03:	. = . +32.
	< at line >
	.byte	0
lnkdgn:	0			/file descriptor
fildgn:	</basic.dgn>		/diagnostic file
	.byte	0
	.even
seeksys:	sys	seek;0;0	/plugable seek
