/        .title logops
	.globl	begin		/transfer address
	jmp	begin		/startup here

/        .csect
	.globl		savreg,resreg
savreg:	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	mov	r1,-(sp)
	mov	r0,-(sp)
	mov	r5,pc

resreg:	tst	(sp)+
	mov	(sp)+,r0
	mov	(sp)+,r1
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r4
	rts	r5

        .globl fix00,fixerr,argerr
        .globl fixd00,fixds0,fltd00
        .globl fnm3,fad3        / and
        .globl fnm4,fad4        / orf
        .globl fnm5,fad5        / neq
        .globl fnm6,fad6        / lft
        .globl fnm7,fad7        / rgt

	.data
t0:      0                 / used as marker
t1:      0                 / data low
t2:      0                 / data high
	.text

/ acquisition variable  --- rgt

  fnm7 = 56060                  / rgt

fad7:   mov     $-2,t0          / right is negative
        br      movlr

/ acquisition variable  --- lft

  fnm6 = 36654                  / lft

fad6:   clr     t0              / left
movlr:  cmp     r1,$2           / check no of parameters
        bne     npars           / fail
        mov     (sp),r2         / get shift count
        mov     2(sp),r3
        mov     4(sp),r4
	jsr	pc,fix00
        add     $6,sp           / bump stack
        tst     t0              / negate for right
        beq     left
        neg     r0
left:   cmp     r0,$-40         / test range of shift -32 to +31
        blt     set32r
        cmp     r0,$40
        bge     set32r
movfix: mov     sp,r1           / location of value to fix
        mov     r0,-(sp)        / save r0
        jsr     pc,fixds0       / fix double
        mov     (sp)+,r0        / restore r0
        mov     r2,r5           / r4,r5=m.s.,l.s. for shift
        mov     r3,r4
	tst	r0		/test for right
	bge	shift		/no
	ashc	$-1,r4		/shift 1 place
	bic	$100000,r4	/clear top bit- give logical op
	inc	r0		/one place done
shift:	ashc	r0,r4
        mov     r4,r3
        mov     r5,r2
        mov     sp,r0           / location for float
        jsr     pc,fltd00       / float result
        mov     6(sp),pc        / exit
set32r: mov     $-40,r0         / use 32 right
        br      movfix

npars:  argerr                  / incorrect no of parameters

/ acquisition variable  --- orf

  fnm4 = 47176                  / orf

fad4:   mov     $2,t0           /set positive
        br      and01

/ acquisition variable  --- neq

  fnm5 = 43645                  / neq

fad5:   mov     $-2,t0          / set negative
        br      and01

/ acquisition variable  --- and

  fnm3 = 3414                   / and

fad3:   clr     t0              / clear t0
and01:  cmp     r1,$2           / test no of parameters
        bne     npars           / fail
        mov     sp,r1           / position of data
        jsr     pc,fixds0       / get data
        mov     r2,t1           / save
        mov     r3,t2
        add     $6,sp           / bump stack
        mov     sp,r1           / position of data
        jsr     pc,fixds0       /

        tst     t0              / find operator
        beq     andf
        bgt     orff
neqf:   xor     r2,t1           / pity that reg,dest
        xor     r3,t2
set23:  mov     t1,r2
        mov     t2,r3

exitlf: mov     sp,r0           / where to put result
        jsr     pc,fltd00
        mov     6(sp),pc        / exit

andf:   com     r2              / we must use bit clear since no and
        bic     r2,t1
        com     r3
        bic     r3,t2
        br      set23

orff:   bis     t1,r2
        bis     t2,r3
        br      exitlf

