
/* This is a source file for an nroff driver table for a LN03 laser printer.
 * Parts of this were borrowed from the tabiw.c file posted to the net.
 */

#include	<termio.h>	/* Req'd only for bset, breset */

#define INCH 240

struct {
	int bset;
	int breset;
	int Hor;
	int Vert;
	int Newline;
	int Char;
	int Em;
	int Halfline;
	int Adj;
	char *twinit;
	char *twrest;
	char *twnl;
	char *hlr;
	char *hlf;
	char *flr;
	char *bdon;
	char *bdoff;
	char *iton;
	char *itoff;
	char *ploton;
	char *plotoff;
	char *up;
	char *down;
	char *right;
	char *left;
	char *codetab[256-32];
	char *zzz;
	} t = {
/*bset    */		0,
/*breset  */		ONLCR | OCRNL | ONLRET,
/*Hor     */		4,	/* Copied from tabiw.c */
/*Vert    */		5,
/*Newline */		40,
/*Char    */		24,
/*Em      */		24,
/*Halfline*/		20,
/*Adj     */		24,
/*twinit  */		"",  /* Let init and reset be handled by the printer filter */
/*twrest  */		"",
/*twnl    */		"\033[22m\033[23m\033[24m\033[29m\r\n",
/*hlr     */		"\033L",
/*hlf     */		"\033K",
/*flr     */		"\033[1k",
/*bdon    */		"\033[1m",
/*bdoff   */		"\033[22m",
/*iton    */		"\033[3m",
/*itoff   */		"\033[23m",
/*ploton  */		"",
/*plotoff */		"",
/*up      */		"\033[1k",
/*down    */		"\033[1e",
/*right   */		"\033[1a",
/*left    */		"\033[1j",
/* space */         	"\001 ",
/* ! */             	"\001!",
/* " */             	"\001\"",
/* # */             	"\001#",
/* $ */             	"\001$",
/* % */             	"\001%",
/* & */             	"\001&",
/* ' close */       	"\001'",
/* ( */             	"\001(",
/* ) */             	"\001)",
/* * */             	"\001*",
/* + */             	"\001+",
/* , */             	"\001,",
/* - hyphen */      	"\001-",
/* . */             	"\001.",
/* / */             	"\001/",
/* 0 */             	"\2010",
/* 1 */             	"\2011",
/* 2 */             	"\2012",
/* 3 */             	"\2013",
/* 4 */             	"\2014",
/* 5 */             	"\2015",
/* 6 */             	"\2016",
/* 7 */             	"\2017",
/* 8 */             	"\2018",
/* 9 */             	"\2019",
/* : */             	"\001:",
/* ; */             	"\001;",
/* < */             	"\001<",
/* = */             	"\001=",
/* > */             	"\001>",
/* ? */             	"\001?",
/* @ */             	"\001@",
/* A */             	"\201A",
/* B */             	"\201B",
/* C */             	"\201C",
/* D */             	"\201D",
/* E */             	"\201E",
/* F */             	"\201F",
/* G */             	"\201G",
/* H */             	"\201H",
/* I */             	"\201I",
/* J */             	"\201J",
/* K */             	"\201K",
/* L */             	"\201L",
/* M */             	"\201M",
/* N */             	"\201N",
/* O */             	"\201O",
/* P */             	"\201P",
/* Q */             	"\201Q",
/* R */             	"\201R",
/* S */             	"\201S",
/* T */             	"\201T",
/* U */             	"\201U",
/* V */             	"\201V",
/* W */             	"\201W",
/* X */             	"\201X",
/* Y */             	"\201Y",
/* Z */             	"\201Z",
/* [ */             	"\001[",
/* \ */             	"\001\\",
/* ] */             	"\001]",
/* ^ */             	"\001^",
/* _ dash */        	"\001_",
/* ` open */        	"\001`",
/* a */             	"\201a",
/* b */             	"\201b",
/* c */             	"\201c",
/* d */             	"\201d",
/* e */             	"\201e",
/* f */             	"\201f",
/* g */             	"\201g",
/* h */             	"\201h",
/* i */             	"\201i",
/* j */             	"\201j",
/* k */             	"\201k",
/* l */             	"\201l",
/* m */             	"\201m",
/* n */             	"\201n",
/* o */             	"\201o",
/* p */             	"\201p",
/* q */             	"\201q",
/* r */             	"\201r",
/* s */             	"\201s",
/* t */             	"\201t",
/* u */             	"\201u",
/* v */             	"\201v",
/* w */             	"\201w",
/* x */             	"\201x",
/* y */             	"\201y",
/* z */             	"\201z",
/* { */             	"\001{",
/* | */             	"\001|",
/* } */             	"\001}",
/* ~ */             	"\001~",
/* narrow sp */     	"\000\0",
/* hyphen */        	"\001-",
/* bullet */        	"\000\0",
/* square */        	"\000\0",
/* 3/4 em */        	"\001-",
/* rule */          	"\001_",
/* 1/4 */           	"\0031/4",
/* 1/2 */           	"\0031/2",
/* 3/4 */           	"\0033/4",
/* minus */         	"\001-",
/* fi */            	"\202fi",
/* fl */            	"\202fl",
/* ff */            	"\202ff",
/* ffi */           	"\203ffi",
/* ffl */           	"\203ffl",
/* degree */        	"\000\0",
/* dagger */        	"\000\0",
/* section */       	"\000\0",
/* foot mark */     	"\000\0",
/* acute accent */  	"\000\0",
/* grave accent */  	"\000\0",
/* underrule */     	"\001_",
/* slash (longer) */	"\001/",
/* half narrow space */	"\000\0",
/* unpaddable space */	"\001 ",
/* alpha */         	"\000\0",
/* beta */          	"\000\0",
/* gamma */         	"\000\0",
/* epsilon */       	"\000\0",
/* zeta */          	"\000\0",
/* eta */           	"\000\0",
/* theta */         	"\000\0",
/* iota */          	"\000\0",
/* kappa */         	"\000\0",
/* lambda */        	"\000\0",
/* mu */            	"\000\0",
/* nu */            	"\000\0",
/* xi */            	"\000\0",
/* omicron */       	"\000\0",
/* pi */            	"\000\0",
/* rho */           	"\000\0",
/* sigma */         	"\000\0",
/* tau */           	"\000\0",
/* upsilon */       	"\000\0",
/* phi */           	"\000\0",
/* chi */           	"\000\0",
/* psi */           	"\000\0",
/* omega */         	"\000\0",
/* Gamma */         	"\000\0",
/* Delta */         	"\000\0",
/* Theta */         	"\000\0",
/* Lambda */        	"\000\0",
/* Xi */            	"\000\0",
/* Pi */            	"\000\0",
/* Sigma */         	"\000\0",
/* Tau */           	"\000\0",
/* Upsilon */       	"\000\0",
/* Phi */           	"\000\0",
/* Psi */           	"\000\0",
/* Omega */         	"\000\0",
/* square root */   	"\000\0",
/* terminal sigma */	"\000\0",
/* root en */       	"\000\0",
/* >= */            	"\000\0",
/* <= */            	"\000\0",
/* identically equal */	"\000\0",
/* equation minus */	"\000\0",
/* approx = */      	"\000\0",
/* approximates */  	"\000\0",
/* not equal */     	"\000\0",
/* right arrow */   	"\000\0",
/* left arrow */    	"\000\0",
/* up arrow */      	"\000\0",
/* down arrow */    	"\000\0",
/* eqn equals */    	"\000\0",
/* multiply */      	"\000\0",
/* divide */        	"\000\0",
/* plus-minus */    	"\000\0",
/* cup (union) */   	"\000\0",
/* cap (intersection) */	"\000\0",
/* subset of */     	"\000\0",
/* superset of */   	"\000\0",
/* improper subset */	"\000\0",
/*  improper superset */	"\000\0",
/* infinity */      	"\000\0",
/* pt deriv */      	"\000\0",
/* gradient */      	"\000\0",
/* not */           	"\000\0",
/* integral */      	"\000\0",
/* proportional to */	"\000\0",
/* empty set */     	"\000\0",
/* member of */     	"\000\0",
/* equation plus */ 	"\001+",
/* registration mk */	"\000\0",
/* copyright mk */  	"\000\0",
/* box rule */      	"\001|",
/* cent sign */     	"\000\0",
/* dbl dagger */    	"\000\0",
/* right hand */    	"\000\0",
/* left hand */     	"\000\0",
/* math *  */       	"\001*",
/* bell system sign */	"\000\0",
/* or (was star) */ 	"\001|",
/* circle */        	"\000\0",
/* left top of big curly */	"\001|",
/* left bottom of big curly */	"\001|",
/* right top of big curly */	"\001|",
/* right bottom of big curly */	"\001|",
/* left center of big curly */	"\001|",
/* right center of big curly */	"\001|",
/* bold vertical rule */	"\001|",
/* left bottom of big bracket */	"\001|",
/* right bottom of big bracket */	"\001|",
/* left top of big bracket */	"\001|",
/* right top of big bracket */	"\001|",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
/* ??? */           	"\000\0",
};
