# INIT-- DUNGEON INITIALIZATION SUBROUTINE
#
# DECLARATIONS
#
	LOGICAL FUNCTION INIT(X)
	IMPLICIT INTEGER (A-Z)
	LOGICAL PROTCT
	integer line2(16)
	INTEGER CDIR(15)
	CHARACTER LINE(78)
	CHARACTER*2 DIR,SDIR(15)
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	common /magic/magic
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# PARSER STATE
#
	COMMON /ORPHS/ OFLAG,OACT,OSLOT,OPREP,ONAME
	COMMON /LAST/ LASTIT
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/	MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
			LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# SCREEN OF LIGHT
#
	COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
#
# MESSAGE INDEX
#
	COMMON /RMSG/ MLNT,RTEXT(1050)
#
# MISCELLANEOUS VARIABLES
#
	COMMON /STAR/ MBASE,STRBIT
	COMMON /VERS/ VMAJ,VMIN,VEDIT
	COMMON /TIME/ PLTIME,SHOUR,SMIN,SSEC
	COMMON /CHAN/ INPCH,OUTCH,DBCH
	COMMON /DEBUG/ DBGFLG,PRSFLG,GDTFLG
#
# ROOMS
#
	COMMON /ROOMS/	RLNT,RDESC2,RDESC1(215),REXIT(215),
			RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/	RSEEN,RLIGHT,RLAND,RWATER,RAIR,
			RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1
	COMMON /RINDEX/ MGRAT,MAZ15
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# EXITS
#
	COMMON /EXITS/ XLNT,travel(870)
#
	COMMON /CURXT/ XTYPE,XROOM1,XSTRNG,XACTIO,XOBJ
	EQUIVALENCE (XFLAG,XOBJ)
#
	COMMON /XPARS/	XRMASK,XDMASK,XFMASK,XFSHFT,XASHFT,
			XELNT(4),XNORM,XNO,XCOND,XDOOR,XLFLAG
#
# OBJECTS
#
	COMMON /OBJCTS/	OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
			OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
			OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OROOM2/ R2LNT,O2(15),R2(15)
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,CTICK(25),CACTIO(25),CFLAG(25)
#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
	COMMON /VILL/ VLNT,VILLNS(4),VPROB(4),VOPPS(4),VBEST(4),VMELEE(4)
#
# ADVENTURERS
#
	COMMON /ADVS/	ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
			AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# FLAGS
#
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,sprf
	COMMON /FINDEX/	TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
			DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
			MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
			GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
			GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
			MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
			FOLLWF,SPELLF,sprf(6)
	COMMON /FINDEX/ BTIEF,BINFF
	COMMON /FINDEX/ RVMNT,RVCLR,RVCYC,RVSND,RVGUA
	COMMON /FINDEX/ ORRUG,ORCAND,ORMTCH,ORLAMP
	COMMON /FINDEX/ MDIR,MLOC,POLEUF
	COMMON /FINDEX/ QUESNO,NQATT,CORRCT
	COMMON /FINDEX/ LCELL,PNUMB,ACELL,DCELL
	LOGICAL FLAGS(50)
	INTEGER ZSWTCH(27)
	EQUIVALENCE (FLAGS(1),TROLLF)
	EQUIVALENCE (ZSWTCH(1),BTIEF)
#
# FUNCTIONS AND DATA
#
	data magic/o'555'/
	DATA SDIR/	'N ','NE','E ','SE',
			'S ','SW','W ','NW',
			'U ','D ',
			'LA','LN','EN','EX','CR'/
	DATA CDIR/	o'2000',o'4000',o'6000',o'10000',
			o'12000',o'14000',o'16000',o'20000',
			o'22000',o'24000',
			o'26000',o'30000',o'32000',o'34000',o'36000'/

#INIT, PAGE 2
#
# FIRST CHECK FOR PROTECTION VIOLATION
#
	IF(PROTCT(X)) GO TO 10000		#PROTECTION VIOLATION?
	WRITE(*,10100)				#YES, THROW HIM OFF.
10100	FORMAT(' There appears before you a threatening figure clad all over',
	/' in heavy black armor.  His legs seem like the massive trunk',
	/' of the oak tree.  His broad shoulders and helmeted head loom',
	/' high over your own puny frame, and you realize that his powerful',
	/' arms could easily crush the very life from your body.  There',
	/' hangs from his belt a veritable arsenal of deadly weapons:',
	/' sword, mace, ball and chain, dagger, lance, and trident.',
	/' He speaks with a commanding voice:',
	//20X,'\"You shall not pass.\"',
	//' As he grabs you by the neck all grows dim about you.')
	CALL EXIT
#
# NOW START INITIALIZATION PROPER
#
10000	INIT=.FALSE.				#ASSUME INIT FAILS.
	MMAX=1050				#SET UP ARRAY LIMITS.
	OMAX=250
	RMAX=215
	VMAX=4
	AMAX=4
	CMAX=25
	FMAX=50
	SMAX=27
	XMAX=870
	R2MAX=15
	DIRMAX=15
#
	MLNT=0					#INIT ARRAY COUNTERS.
	OLNT=0
	RLNT=0
	VLNT=0
	ALNT=0
	CLNT=0
	XLNT=1
	R2LNT=0
#
	LTSHFT=10				#SET UP STATE VARIABLES.
	MXSCOR=LTSHFT
	EGSCOR=0
	EGMXSC=0
	MXLOAD=100
	RWSCOR=0
	DEATHS=0
	MOVES=0
	PLTIME=0
	MUNGRM=0
	HS=0
	PRSA=0					#CLEAR PARSE VECTOR.
	PRSI=0
	PRSO=0
	PRSCON=1
	OFLAG=0					#CLEAR ORPHANS.
	OACT=0
	OSLOT=0
	OPREP=0
	ONAME=0
	THFFLG=.FALSE.				#THIEF NOT INTRODUCED BUT
	THFACT=.TRUE.				#IS ACTIVE.
	SWDACT=.FALSE.				#SWORD IS INACTIVE.
	SWDSTA=0				#SWORD IS OFF.
#
	RECNO=1					#INIT DB FILE POINTER.
	MBASE=0					#INIT MELEE BASE.
	INPCH=5					#TTY INPUT
	OUTCH=5					#TTY OUTPUT.
	DBCH=20					#DATA BASE.

# INIT, PAGE 3
#
# INIT ALL ARRAYS.
#
	DO I=1,CMAX {				#CLEAR CLOCK EVENTS
	  CFLAG(I)=.FALSE.
	  CTICK(I)=0
	  CACTIO(I)=0
	  }
#
	DO I=1,FMAX {				#CLEAR FLAGS.
	  FLAGS(I)=.FALSE.
	  }
	BUOYF=.TRUE.				#SOME START AS TRUE.
	EGYPTF=.TRUE.
	CAGETF=.TRUE.
	MR1F=.TRUE.
	MR2F=.TRUE.
	FOLLWF=.TRUE.

	DO I=1,SMAX {				#CLEAR SWITCHES.
	  ZSWTCH(I)=0
	  }
	ORMTCH=4				#NUMBER OF MATCHES.
	LCELL=1
	PNUMB=1
	MDIR=270
	MLOC=MRB
#
	DO I=1,R2MAX {			#CLEAR ROOM 2 ARRAY.
	  R2(I)=0
	  O2(I)=0
	  }
#
	DO I=1,XMAX {			#CLEAR TRAVEL ARRAY.
	  TRAVEL(I)=0
	  }
#
	DO I=1,VMAX {				#CLEAR VILLAINS ARRAYS.
	  VOPPS(I)=0
	  VPROB(I)=0
	  VILLNS(I)=0
	  VBEST(I)=0
	  VMELEE(I)=0
	  }
#
	DO I=1,OMAX {				#CLEAR OBJECT ARRAYS.
	  ODESC1(I)=0
	  ODESC2(I)=0
	  ODESCO(I)=0
	  OREAD(I)=0
	  OACTIO(I)=0
	  OFLAG1(I)=0
	  OFLAG2(I)=0
	  OFVAL(I)=0
	  OTVAL(I)=0
	  OSIZE(I)=0
	  OCAPAC(I)=0
	  OCAN(I)=0
	  OADV(I)=0
	  OROOM(I)=0
	  }
#
	RDESC2=0				#CLEAR DESC BASE PTR.
	DO I=1,RMAX {				#CLEAR ROOM ARRAYS.
	  RDESC1(I)=0
	  RACTIO(I)=0
	  RFLAG(I)=0
	  RVAL(I)=0
	  REXIT(I)=0
	  }
#
	DO I=1,MMAX {				#CLEAR MESSAGE DIRECTORY.
	  RTEXT(I)=0
	  }
#
	DO I=1,AMAX {				#CLEAR ADVENTURER'S ARRAYS.
	  AROOM(I)=0
	  ASCORE(I)=0
	  AVEHIC(I)=0
	  AOBJ(I)=0
	  AACTIO(I)=0
	  ASTREN(I)=0
	  AFLAG(I)=0
	  }
#
	DBGFLG=0
	PRSFLG=0
	GDTFLG=-1
#
	FROMDR=0				#INIT SCOL GOODIES.
	SCOLRM=0
	SCOLAC=0

	CALL SPINIT				#INIT R50 CONSTS

# INIT, PAGE 3A
#
# NOW SEE IF WE CAN RESTORE FROM EXISTING INDEX FILE.
#
	OPEN(UNIT=1,FILE='DINDX.DAT',ACCESS='SEQIN',
#		MODE='BINARY',
		ERR=75)
	READ(1) I,J,K					#GET VERSION.
	IF((I.NE.VMAJ).OR.(J.NE.VMIN)) GO TO 170	#MATCH TO OURS?

	OPEN(UNIT=DBCH,FILE='DTEXT.cpt',
#		MODE='BINARY',
		ACCESS='RANDIN',
		ERR=170)

#D	WRITE(*,150)
#D150	FORMAT(' RESTORING FROM \"DINDX.DAT\"')
	READ(1) MXSCOR,STRBIT,EGMXSC
	READ(1) RLNT,RDESC2,RDESC1,REXIT,RACTIO,RVAL,RFLAG
	READ(1) XLNT,TRAVEL
	READ(1) OLNT,ODESC1,ODESC2,ODESCO,OACTIO,OFLAG1,OFLAG2,
		OFVAL,OTVAL,OSIZE,OCAPAC,OROOM,OADV,OCAN,
		OREAD
	READ(1) R2LNT,O2,R2
	READ(1) CLNT,CTICK,CACTIO,CFLAG
	READ(1) VLNT,VILLNS,VPROB,VOPPS,VBEST,VMELEE
	READ(1) ALNT,AROOM,ASCORE,AVEHIC,AOBJ,AACTIO,ASTREN,AFLAG
	READ(1) MBASE,MLNT,RTEXT
#
	CLOSE(UNIT=1)
	GO TO 1025				#INIT DONE.
#
# INDEX FILE IS OBSOLETE, OR
# DB FILE IS NOT AVAILABLE.
# KILL INDEX FILE AND START AGAIN.
#
170	CLOSE(UNIT=1)				#KILL INDEX FILE.

# INIT, PAGE 4
#
# NOW START DATA BASE FILE PROCESSING.
#
75	OPEN (UNIT=1,FILE='DTEXT.TXT',ACCESS='SEQIN',ERR=1900)
#
	OPEN (UNIT=DBCH,FILE='DTEXT.CPT',
#		MODE='BINARY',
		ACCESS='RANDOM',
		ERR=1950)
#
#D	WRITE(*,185)
#D185	FORMAT(' CREATING NEW \"DTEXT.CPT\"')
#
# RETURN HERE TO READ NEXT SECTION HEADER.
#
80	READ (1,90) I,LINE			#READ SECTION HEADER.
90	FORMAT(I,78A1)
#
	IF(I.EQ.0) GO TO 80			#IGNORE 0.
	IF(I.LT.0) GO TO 1000			#-1 IS END FILE.
#D	WRITE(*,125)I
#D125	FORMAT(' INITIALIZING SECTION #',I4)
	IF(I.LE.8) GO TO 100			#TEXT SECTION?
	GO TO (400,500,600,700,800,900,950),(I-8)
	CALL BUG(12,I)				#INVALID SECTION NO.
#
# TEXT SECTION.  WRITE TEXT OUT TO DB FILE, NOTE INITIAL RECORD
# NUMBER IN APPROPRIATE ARRAY.
#
100	PREVJ=0					#FORCE START OF RECORD.
110	READ(1,90) J,LINE			#READ LINE.
	IF(J.EQ.0) GO TO 110			#IGNORE 0.
	IF(J.LT.0) GO TO 80			#-1 IS END SECTION.
	IF(J.EQ.PREVJ) GO TO 300		#IF CONT, WRITE OUT.
	GO TO (210,220,230,240,250,260,270,280),I
	CALL BUG(12,I)
#
# SECTION 1-- RANDOM REMARKS.
#
210	IF(J.GT.MMAX) CALL BUG(13,J)		#TOO MANY REMARKS?
	IF(RTEXT(J).NE.0) CALL BUG(14,J)	#DUPLICATE REMARK?
	RTEXT(J)=-RECNO				#RECORD START OF RECORD.
	MBASE=MAX0(MBASE,J)
	GO TO 300				#GO OUTPUT LINE.
#
# SECTION 2-- MELEE MESSAGES
#
220	K=J+MBASE				#OFFSET BY END OF RANDOMS.
	IF(K.GT.MMAX) CALL BUG(13,K)
	IF(RTEXT(K).NE.0) CALL BUG(14,K)
	RTEXT(K)=-RECNO
	MLNT=MAX0(MLNT,K)			#UPDATE LENGTH COUNTER.
	GO TO 300
#
# SECTION 3-- LONG ROOM DESCRIPTIONS
#
230	IF(J.GT.RMAX) CALL BUG(15,J)		#TOO  MANY ROOMS?
	IF(RDESC1(J).NE.0) CALL BUG(16,J)	#DUPLICATE ROOM?
	RDESC1(J)=-RECNO
	GO TO 300
#
# SECTION 4-- SHORT ROOM DESCRIPTIONS
#
240	IF(J.GT.RMAX) CALL BUG(17,J)
	IF(RDESC2.EQ.0) RDESC2=-RECNO+1		#RECORD BASE
	GO TO 300
#
# SECTION 5-- LONG OBJECT DESCRIPTIONS
#
250	IF(J.GT.OMAX) CALL BUG(19,J)		#TOO MANY OBJECTS?
	IF(ODESC1(J).NE.0) CALL BUG(20,J)	#DUPLICATE OBJECTS?
	ODESC1(J)=-RECNO
	GO TO 300
#
# SECTION 6-- SHORT OBJECT DESCRIPTIONS
#
260	IF(J.GT.OMAX) CALL BUG(21,J)
	IF(ODESC2(J).NE.0) CALL BUG(22,J)
	ODESC2(J)=-RECNO
	GO TO 300
#
# SECTION 7-- UNTOUCHED OBJECT DESCRIPTIONS
#
270	IF(J.GT.OMAX) CALL BUG(23,J)
	IF(ODESCO(J).NE.0) CALL BUG(24,J)
	ODESCO(J)=-RECNO
	GO TO 300
#
# SECTION 8-- READING MATERIAL
#
280	IF(J.GT.OMAX) CALL BUG(25,J)
	IF(OREAD(J).NE.0) CALL BUG(26,J)
	OREAD(J)=-RECNO
	GO TO 300
#
# HERE TO WRITE OUT CURRENT LINE OF TEXT.
#
300	call encrpt(recno,line,line2)
	WRITE(DBCH,REC=RECNO) J,line2		#WRITE OUT RECORD NO, LINE
	RECNO=RECNO+1				#ON TO NEXT RECORD
	PREVJ=J
	GO TO 110

# INIT, PAGE 5
#
# SECTION 9-- ROOM DATA
#
400	READ(1,90) J,LINE			#GET ROOM NO.
	IF(J.LT.0) GO TO 80			#-1 IS END OF SECTION.
	IF(J.EQ.0) GO TO 400			#0 IS IGNORED.
	IF(J.GT.RMAX) CALL BUG(28,J)		#TOO MANY ROOMS?
	RLNT=MAX0(RLNT,J)			#COUNT ROOMS.
#
	READ(1,425) RACTIO(J),RVAL(J),RFLAG(J)	#READ ROOM NUMERICS.
425	FORMAT(2I,O)
	IF(AND(RFLAG(J),REND).EQ.0) {
		MXSCOR=MXSCOR+RVAL(J)		#UPDATE BEST SCORE.
		}
	IF(AND(RFLAG(J),REND).NE.0) {
		EGMXSC=EGMXSC+RVAL(J)		#IF ENDGAME, UPDATE BEST.
		}
	PREVX=0					#NO PREV ENTRY.
#
# HERE TO LOOP ON EXIT DESCRIPTIONS
#
405	READ(1,415) DIR,XTYPE,XROOM1		#READ NEXT EXIT.
415	FORMAT(A2,2I)
	IF(DIR.EQ.'  ') GO TO 400		#BLANK LINE ENDS EXITS.
	DO K=1,DIRMAX {				#LOOK UP DIR IN TABLE.
	  IF(DIR.EQ.SDIR(K)) GO TO 420		#IF FOUND, OK.
	  }
	CALL BUG(29,DIR)			#INVALID DIRECTION.
#
# HAVE TRANSLATED DIRECTION, VALIDATE OTHER FIELDS.
#
420	IF((XTYPE.LE.0).OR.(XTYPE.GT.(XFMASK+1))) CALL BUG(30,XTYPE)
	IF(XROOM1.GT.RMAX) CALL BUG(31,XROOM1)
	IF(REXIT(J).EQ.0) REXIT(J)=XLNT		#RECORD FIRST.
	IF((XLNT+XELNT(XTYPE)).GT.XMAX) CALL BUG(32,XLNT)
	TRAVEL(XLNT)=CDIR(K)+((XTYPE-1)*XFSHFT)+XROOM1+XLFLAG
	IF(PREVX.NE.0) TRAVEL(PREVX)=TRAVEL(PREVX)-XLFLAG
	GO TO (480,470,460,450),XTYPE		#DO UNIQUE PROCESSING.
	CALL BUG(30,XTYPE)
#
# DOOR ENTRY-- READ OBJECT,APPLICABLE,STRING
#
450	READ(1,455) XOBJ,XACTIO,LINE
455	FORMAT(2I,78A1)
	IF((XOBJ.LE.0).OR.(XOBJ.GT.OMAX)) CALL BUG(34,XOBJ)
	GO TO 468
#
# CONDITIONAL EXIT ENTRY-- READ FLAG,APPLICABLE,STRING
#
460	READ(1,465) XOBJ,XACTIO,LINE
465	FORMAT(2I,78A1)
	IF((XOBJ.LE.0).OR.(XOBJ.GT.FMAX)) CALL BUG(35,XOBJ)
468	TRAVEL(XLNT+2)=(XACTIO*XASHFT)+XOBJ
	GO TO 478
#
# NO EXIT ENTRY-- READ STRING
#
470	READ(1,475) LINE
475	FORMAT(78A1)
478	IF(LINE(1).EQ.'  ') GO TO 480		#BLANK LINE?
	call encrpt(recno,line,line2)
	WRITE(DBCH,REC=RECNO) RECNO,line2		#NO, WRITE OUT.
	TRAVEL(XLNT+1)=-RECNO
	RECNO=RECNO+1
#
# COMMON PROCESSING, ADVANCE OVER ENTRY.
#
480	PREVX=XLNT				#RECORD PREV ENTRY.
	XLNT=XLNT+XELNT(XTYPE)
	GO TO 405

# INIT, PAGE 6
# SECTION 11-- GLOBAL OBJECTS
# SECTION 10-- NORMAL OBJECTS
#
600	STRBIT=OLNT				#RECORD START OF STARS.
500	READ(1,90) J,LINE			#GET OBJ NUMBER.
	IF(J.LT.0) GO TO 80			#-1 IS END SECTION.
	IF(J.EQ.0) GO TO 500			#0 IS IGNORED.
	IF(J.GT.OMAX) CALL BUG(27,J)
	OLNT=MAX0(OLNT,J)
#
	READ(1,560) OROOM(J),OCAN(J),OACTIO(J),OFLAG1(J),
		OFLAG2(J),OFVAL(J),OTVAL(J),OSIZE(J),OCAPAC(J)
560	FORMAT(3I,2O,4I)
#
	MXSCOR=MXSCOR+OFVAL(J)+OTVAL(J)		#UPDATE BEST SCORE.
	GO TO 500
#
# SECTION 12-- VILLAINS
#
700	READ(1,710) J,K,L,LINE			#READ VILLAIN NO.
710	FORMAT(3I,78A1)
	IF(J.LT.0) GO TO 80
	IF(J.EQ.0) GO TO 700
	VLNT=VLNT+1
	IF(VLNT.GT.VMAX) CALL BUG(36,VLNT)	#TOO MANY VILLAINS?
	VILLNS(VLNT)=J				#NO, ADD TO LIST.
	VBEST(VLNT)=K				#NOTE BEST WEAPON.
	VMELEE(VLNT)=L				#NOTE MELEE.
	GO TO 700
#
# SECTION 13-- CLOCK EVENTS
#
800	READ(1,90) J,LINE			#READ EVENT NO.
	IF(J.LT.0) GO TO 80
	IF(J.EQ.0) GO TO 800
	IF(J.GT.CMAX) CALL BUG(37,J)
	CLNT=MAX0(CLNT,J)
#
	READ(1,890) CACTIO(J),CTICK(J),CFLAG(J)
890	FORMAT(2I,L2)
	GO TO 800
#
# SECTION 14-- ADVENTURERS
#
900	READ(1,90) J,LINE			#READ ADV NO.
	IF(J.LT.0) GO TO 80
	IF(J.EQ.0) GO TO 900
	IF(J.GT.AMAX) CALL BUG(38,J)
	ALNT=MAX0(ALNT,J)
#
	READ(1,990) AROOM(J),AOBJ(J),AACTIO(J),ASTREN(J)
990	FORMAT(4I)
	GO TO 900
#
# SECTION 15-- MULTI-ROOM OBJECTS
#
950	READ(1,955) J,K,LINE
955	FORMAT(2I,78A1)
	IF(J.LT.0) GO TO 80			#-1 IS END SECTION.
	IF(J.EQ.0) GO TO 950
	R2LNT=R2LNT+1				#GET NEXT TABLE SLOT.
	IF(R2LNT.GT.R2MAX) CALL BUG(33,R2LNT)	#TOO MANY?
	O2(R2LNT)=J
	R2(R2LNT)=K
	GO TO 950				#ONWARD.

# INIT, PAGE 7
#
# INITIALIZATION IS COMPLETE.
# WRITE OUT NEW INDEX FILE FOR NEXT TIME AROUND.
#
1000	J=-1					#FORCE END OF LAST REC.
	WRITE(DBCH,REC=RECNO) J,LINE		#WRITE GUARD REC.
	RECNO=RECNO+1
	CLOSE (UNIT=1)				#CLOSE TXT FILE.
#
	OPEN (UNIT=1,FILE='DINDX.DAT',ACCESS='SEQOUT',
#		MODE='BINARY',
		ERR=1025)
#D	WRITE(*,1005)
#D1005	FORMAT(' CREATING NEW \"DINDX.DAT\"')
#
	WRITE(1) VMAJ,VMIN,VEDIT
	WRITE(1) MXSCOR,STRBIT,EGMXSC
	WRITE(1) RLNT,RDESC2,RDESC1,REXIT,RACTIO,RVAL,RFLAG
	WRITE(1) XLNT,TRAVEL
	WRITE(1) OLNT,ODESC1,ODESC2,ODESCO,OACTIO,OFLAG1,OFLAG2,
		OFVAL,OTVAL,OSIZE,OCAPAC,OROOM,OADV,OCAN,
		OREAD
	WRITE(1) R2LNT,O2,R2
	WRITE(1) CLNT,CTICK,CACTIO,CFLAG
	WRITE(1) VLNT,VILLNS,VPROB,VOPPS,VBEST,VMELEE
	WRITE(1) ALNT,AROOM,ASCORE,AVEHIC,AOBJ,AACTIO,ASTREN,AFLAG
	WRITE(1) MBASE,MLNT,RTEXT
#
	CLOSE (UNIT=1)
1025	CONTINUE

# INIT, PAGE 8
#
# THE INTERNAL DATA BASE IS NOW ESTABLISHED.
# SET UP TO PLAY THE GAME.
#
	CALL ITIME(SHOUR,SMIN,SSEC)		#GET TIME AND DATE.
	CALL IDATE(I,J,K)
	CALL SETRAN(XOR((I*J*K),(SHOUR*SMIN*SSEC)))
#
	WINNER=PLAYER
	THFPOS=OROOM(THIEF)
	BLOC=OROOM(BALLO)
	HERE=AROOM(WINNER)
	LASTIT=AOBJ(PLAYER)
	INIT=.TRUE.
#
#D	WRITE(*,1050)RLNT,RMAX,XLNT,XMAX,OLNT,OMAX,MLNT,MMAX,
#D		VLNT,VMAX,ALNT,AMAX,CLNT,CMAX,R2LNT,R2MAX
#D1050	FORMAT(' USED:'/1X,I5,' OF',I5,' ROOMS'/,
#D	1X,I5,' OF',I5,' EXITS'/,
#D	1X,I5,' OF',I5,' OBJECTS'/,
#D	1X,I5,' OF',I5,' MESSAGES'/,
#D	1X,I5,' OF',I5,' VILLAINS'/,
#D	1X,I5,' OF',I5,' ADVENTURERS'/,
#D	1X,I5,' OF',I5,' CLOCK EVENTS'/,
#D	1X,I5,' OF',I5,' ROOM2 SLOTS')
#D	WRITE(*,1150)MXSCOR,EGMXSC,RECNO,RDESC2,MBASE,STRBIT
#D1150	FORMAT(' MAX SCORE=',I5/' EG SCORE=',I5/,
#D	' MAX RECNO=',I5/' RDESC2 BASE=',I5/,
#D	' MELEE START=',I5/' STAR MASK=',I7)
#D	PAUSE 1
#
	RETURN

# INIT, PAGE 9
#
# ERRORS-- INIT FAILS.
#
1900	WRITE(*,910)				#INPUT FILE ERROR
	WRITE(*,980)
	RETURN
1950	WRITE(*,960)				#OUTPUT FILE ERROR
	WRITE(*,980)
	RETURN
%910	FORMAT(' I can\'t open \"DTEXT.TXT\".')
%960	FORMAT(' I can\'t open \"DTEXT.DAT\".')
980	FORMAT(' Suddenly a sinister, wraithlike figure appears before you',
	/' seeming to float in the air.  In a low, sorrowful voice he says,',
	/' \"Alas, the very nature of the world has changed, and the dungeon',
	/' cannot be found.  All must now pass away.\"  Raising his oaken staff',
	/' in farewell, he fades into the spreading darkness.  In his place',
	/' appears a tastefully lettered sign reading:',
	//23X,'INITIALIZATION FAILURE'//,
	' The darkness becomes all encompassing, and your vision fails.')
#
	END
