


     VC(1)                       UNIX 3.0                        VC(1)



     NAME
          vc - spread sheet calculator ("visicalc-like")

     SYNOPSIS
          vc [ _f_i_l_e ]


     DESCRIPTION
          _V_c is a calculator that is based on rectangular tables, in
          much the same style as Visicalc or Lotus 123.  When it is
          invoked it presents you with an empty table organised as
          rows and columns of cells.  Each cell may have a label
          string associated with it and an expression.  The expression
          may be a constant or it may compute something based on other
          entries.

          When _v_c is running, the screen is divided into four regions:
          the top line is for entering commands, the second line is
          for messages from _v_c, the third line and the first four
          columns show the row and column numbers, and the rest of the
          screen forms a window looking at the table.  _v_c has two
          cursors: a cell cursor (indicated by a '<' on the screen)
          and a character cursor (indicated by the terminals hardware
          cursor).  The cell and character cursors are often the same.
          They will differ when a long command is being typed on the
          top line.

          Commands which use the terminal's control key will work when
          either a long command is being typed or in "normal" mode.

          The cursor control commands and the row, column commands can
          be prefixed by a numeric argument indicating how many times
          the command is to be executed.  "^U" can be used before the
          number if the cursor movement is to take place while a
          command is being typed into the command line.

          Cursor control commands:


          ^N   Move the cell cursor to the next row.


          ^P   Move the cell cursor to the previous row.


          ^F   Move the cell cursor forward one column.


          ^B   Move the cell cursor backward one column.


          ^H   Backspace one character.



     Page 1                                           (printed 1/5/87)






     VC(1)                       UNIX 3.0                        VC(1)



          h, j, k, l
               Alternate cursor controls (left, down, up, right).


          0    Move the cell cursor to column 0 of the current row.


          $    Move the cell cursor to the last valid column in the
               current row.


          Cell entry and editing commands:


          =    Prompts for an expression which will be evaluated
               dynamically to produce a value for the cell pointed at
               by the cell cursor.  This may be used in conjunction
               with ^V to make one entries value be dependent on
               anothers.


          "    Enter a label for the current cell.


          <    Enter a label that will be flushed left against the
               left edge of the cell.


          >    Enter a label that will be flushed right against the
               right edge of the cell.


          x    Clears the current cell.


          e    Edit the value associated with the current cell.  This
               is identical to '=' except that the command line starts
               out containing the old value or expression associated
               with the cell.


          E    Edit the string associated with the current cell.  This
               is the same as either "leftstring", "rightstring", or
               "label", with the additional fact that the command line
               starts out with the old string.


          m    Mark a cell to be used as the source for the copy
               command.


          c    Copy the last marked cell to the current cell, updating



     Page 2                                           (printed 1/5/87)






     VC(1)                       UNIX 3.0                        VC(1)



               the row and column references.


          ^T   Toggle cell display.  The current cell's contents are
               displayed in line one when no command being entered or
               edited.  ^T turns the display on or off.


          File operations


          G    Get a new database from a file.


          P    Put the current database into a file.


          W    Write a listing of the current database in a form that
               matches its appearance on the screen.  This differs
               from the "put" command in that "put"s files are
               intended to be reloaded with "get", while "write"
               produces a file for people to look at.


          T    Write a listing of the current database to a file, but
               put ":"s between each field.  This  is useful for
               tables that will be further formatted by the _t_b_l
               preprocessor of _n_r_o_f_f.


          M    Merges the database from the named file into the
               current database.  Values, expressions and names
               defined in the named file are written into the current
               file, overwriting the existing entries at those
               locations.


          Row and Column operations.  Members of this class of
          commands can be used on either rows or columns.  The second
          letter of the command is either a column designator (one of
          the characters c, j, k, ^N, ^p) or a row designator (one of
          r, l, h, ^B, ^F).  Commands which move or copy cells also
          modify the variable references in affected cell expressions.
          Variable references may be frozen by using the "fixed"
          operator.


          ar, ac
               Creates a new row (column) immediately following the
               current row (column).  It is initialized to be a copy
               of the current one.




     Page 3                                           (printed 1/5/87)






     VC(1)                       UNIX 3.0                        VC(1)



          dr, dc
               Delete this row (column).


          pr, pc, pm
               Pull deleted rows (columns) back into the spread sheet.
               The last deleted set of cells is put back into the
               spread sheet at the current location.  _P_r inserts
               enough rows to hold the data.  _P_c inserts enough
               columns to hold the data.  _P_m (merge) does not insert
               rows or columns, but overwrites the cells beginning at
               the current cursor location.


          ir, ic
               Insert a new row (column) by moving the row (column)
               containing the cell cursor, and all following, down
               (right) one.  The new position will be empty.


          zr, zc
               Hide ("zap") the current row (column).  This keeps a
               row or column from being displayed but keeps it in the
               data base.


          vr, vc
               Removes expressions from the affected rows (columns),
               leaving only the values which were in the cells before
               the command was executed.


          sr, sc
               Show hidden rows (columns).  Type in a range of rows or
               columns to be revealed.  The command default is the
               first range of rows or columns currently hidden.


          f    Sets the output format to be used for printing the
               numbers in each cell in the current column.  Type in
               two numbers which will be the width in characters of a
               column and the number of digits which will follow the
               decimal point.  Note that this command has only a
               column version and does have a second letter.


          Miscellaneous commands:


          ^C   Exit from _v_c.  If you were editing a named file, and
               you modified it, then it will ask about saving before
               exiting.



     Page 4                                           (printed 1/5/87)






     VC(1)                       UNIX 3.0                        VC(1)



          q    Alternate exit command.


          ?    Types a brief helpful message.


          /    Copy a region to the area specified by the current
               cell.


          ^G or ESC
               Abort the current long command.


          ^R   Redraw the screen.


          ^V   Types, in the long command line, the name of the cell
               being pointed at by the cell cursor.  This is used when
               typing in expressions to refer to entries in the table.


          ^E   Types, in the long command line, the expression of the
               cell being pointed at by the cell cursor.


          ^A   Types, in the long command line, the value of the cell
               being pointed at by the cell cursor.


          Expressions that are used with the '=' and 'e' commands have
          a fairly conventional syntax.  Terms may be variable names
          (from the ^V command), parenthesised expressions, negated
          terms, and constants. Rectangular regions of the screen may
          be operated upon with '@' functions such as sum (@sum),
          average (@avg) and product (@prod).  Terms may be combined
          using many binary operators.  Their precedences (from
          highest to lowest) are: *,/; +,-; <,=,>,<=,>=; &; |; ?.


          e+e            Addition.


          e-e            Subtraction.


          e*e            Multiplication.


          e/e            Division.





     Page 5                                           (printed 1/5/87)






     VC(1)                       UNIX 3.0                        VC(1)



          @sum(v:v)      Sum all valid (nonblank) entries in the
                         region whose two corners are defined by the
                         two variable (cell) names given.


          @avg(v:v)      Average all valid (nonblank) entries in the
                         region whose two corners are defined by the
                         two variable (cell) names given.


          @prod(v:v)     Multiply together all valid (nonblank)
                         entries in the region whose two corners are
                         defined by the two variable (cell) names
                         given.


          e?e:e          Conditional: If the first expression is true
                         then the value of the second is returned,
                         otherwise the value of the third is.


          <,=,>,<=,>=    Relationals: true iff the indicated relation
                         holds.


          &,|            Boolean connectives.


          fixed          To make a variable not change automatically
                         when a cell moves, put the word fixed in
                         front of the reference.  I.e.  B1*fixed C3



     SEE ALSO
          bc(1), dc(1)


     BUGS
          Expression reevaluation is done in the same top-to-bottom,
          left-to-right manner as is done in other spread sheet
          calculators.  This is silly.  A proper following of the
          dependency graph with (perhaps) recourse to relaxation
          should be implemented.

          At most 200 rows and 40 columns.









     Page 6                                           (printed 1/5/87)



