/*
 * resources_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `resources.G'.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/notice.h>
#include "string_table.h"
#include "db.h"
#include "xplan.h"

extern struct task_node *current_task;
int selected_res=-1, last_selected_res=-1;
struct resource_node *current_res=NULL;

/*
 * Menu handler for `insertMenu (Before)'.
 */
Menu_item
resource_insert_before(Menu_item item, Menu_generate op)
{
   char *res_name;
   struct resource_info *res_info;
   struct resource_node *res_node;
   Xv_notice notice;

	resources_resourcesPopup_objects * ip = (resources_resourcesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		if (selected_res == -1) {
		   notice = xv_create(ip->resourceList, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      "You must first select a resource to add before", 
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return item;
		}

		res_name = (char *) xv_get(ip->resourceField,
					    PANEL_VALUE);

		res_info = create_resource_info(res_name);
		res_node = create_resource_node(res_info, NULL, NULL);
		if (!current_task) return;

		add_resource_before(current_task->data->resources,
				    current_res,
				    res_node);

		current_res = res_node;

		xv_set(ip->resourceList, PANEL_LIST_INSERT, selected_res,
		       PANEL_LIST_STRING, selected_res,
		       res_node->data->resource->name,
		       PANEL_LIST_SELECT, selected_res, TRUE, NULL);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `insertMenu (After)'.
 */
Menu_item
resource_insert_after(Menu_item item, Menu_generate op)
{
   char *res_name;
   struct resource_info *res_info;
   struct resource_node *res_node;
   Xv_notice notice;

	resources_resourcesPopup_objects * ip = (resources_resourcesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		if (selected_res == -1) {
		   notice = xv_create(ip->resourceList, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      "You must first select a resource to add after", 
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return item;
		}

		res_name = (char *) xv_get(ip->resourceField,
					    PANEL_VALUE);

		res_info = create_resource_info(res_name);
		res_node = create_resource_node(res_info, NULL, NULL);
		if (!current_task) return;

		add_resource_after(current_task->data->resources,
				   current_res,
				   res_node);

		current_res = res_node;

		selected_res = selected_res + 1;

		xv_set(ip->resourceList, PANEL_LIST_INSERT, selected_res,
		       PANEL_LIST_STRING, selected_res,
		       res_node->data->resource->name,
		       PANEL_LIST_SELECT, selected_res, TRUE, NULL);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `insertMenu (Top)'.
 */
Menu_item
resource_insert_top(Menu_item item, Menu_generate op)
{
   char *res_name;
   struct resource_info *res_info;
   struct resource_node *res_node;
   Xv_notice notice;

	resources_resourcesPopup_objects * ip = (resources_resourcesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		res_name = (char *) xv_get(ip->resourceField,
					    PANEL_VALUE);

		res_info = create_resource_info(res_name);
		res_node = create_resource_node(res_info, NULL, NULL);
		if (!current_task) return;

		add_resource_to_beginning(current_task->data->resources,
					  res_node);

		current_res = res_node;

		selected_res = 0;

		xv_set(ip->resourceList, PANEL_LIST_INSERT, selected_res,
		       PANEL_LIST_STRING, selected_res,
		       res_node->data->resource->name,
		       PANEL_LIST_SELECT, selected_res, TRUE, NULL);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `insertMenu (Bottom)'.
 */
Menu_item
resource_insert_bottom(Menu_item item, Menu_generate op)
{
   char *res_name;
   struct resource_info *res_info;
   struct resource_node *res_node;
   int nrows;
   Xv_notice notice;

	resources_resourcesPopup_objects * ip = (resources_resourcesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		res_name = (char *) xv_get(ip->resourceField,
					    PANEL_VALUE);

		res_info = create_resource_info(res_name);
		res_node = create_resource_node(res_info, NULL, NULL);
		if (!current_task) return;

		add_resource_to_end(current_task->data->resources,
					  res_node);

		current_res = res_node;

		nrows = (unsigned) xv_get(ip->resourceList,
					  PANEL_LIST_NROWS,
					  NULL);
		selected_res = nrows;

		xv_set(ip->resourceList, PANEL_LIST_INSERT, selected_res,
		       PANEL_LIST_STRING, selected_res,
		       res_node->data->resource->name,
		       PANEL_LIST_SELECT, selected_res, TRUE, NULL);


		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `deleteButton'.
 */
void
resource_delete(Panel_item item, Event *event)
{
   Xv_notice notice;
   int nrows;

	resources_resourcesPopup_objects *ip = (resources_resourcesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	if (selected_res == -1) {
	   notice = xv_create(ip->resourceList, NOTICE,
			      NOTICE_MESSAGE_STRINGS, 
			      "You must first select a resource to delete",
			      NULL,
			      NOTICE_BUTTON_YES, "Continue",
			      XV_SHOW, TRUE,
			      NULL);
	   xv_destroy_safe(notice);
	   return;
	}

   destroy_resource_node(current_res);

   current_res = current_task->data->resources->current;

   xv_set(ip->resourceList, PANEL_LIST_DELETE, selected_res, NULL);

   nrows = (unsigned) xv_get(ip->resourceList, PANEL_LIST_NROWS,
			     NULL);

   if (selected_res == nrows) selected_res = selected_res -1;

   xv_set(ip->resourceList, PANEL_LIST_SELECT, selected_res, TRUE,
	  NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `resourceList'.
 */
int
resource_list_notify(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
   struct resource_node *res;
   int i;

	resources_resourcesPopup_objects *ip = (resources_resourcesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	 case PANEL_LIST_OP_DESELECT:
	   selected_res = -1;
	   break;
	   
	case PANEL_LIST_OP_SELECT:
	   res = current_task->data->resources->head;
	   for (i = 0; i < row; ++i) {
	      res = res->next;
	   }
	   current_res = res;
	   selected_res = row;
	   break;
	   
	 case PANEL_LIST_OP_VALIDATE:
	   break;
	   
	 case PANEL_LIST_OP_DELETE:
	   break;
	}
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
	
	return XV_OK;
}

Panel_setting
resource_enter_callback(Panel_item item, Event *event)
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
}
