/*-------------------------------------------------------------*/
/*  File:  mbutton.c 
 *
 *  Demonstrates the use of the MenuButton widget.
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/OblongButt.h>
#include <Xol/MenuButton.h>

/* Labels for the OblongButtons used in pop-up menu */
static char* choices[] =
{
    "New...", "Open...", "Close", "Save", "Print...", "Exit"
};

/* Callback */
static void button_select();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w, menu, b;
    int i;

/* Create the MenuButton widget */    
    w = XtVaCreateManagedWidget("FileMenuButton",
                      menuButtonWidgetClass, parent,
                      XtNlabel,         "File",
                      XtNtitle,         "File",
                      XtNpushpin,       OL_OUT,
                      NULL);

/* Get the menu pane's ID */
    XtVaGetValues(w, XtNmenuPane, &menu, NULL);
    

/* Add the OblongButton widgets to the menu pane */
    for(i = 0; i < XtNumber(choices); i++)
    {
        b = XtVaCreateManagedWidget(choices[i],
                    oblongButtonWidgetClass, menu,
                    XtNlabel,   choices[i],
                    NULL);

/* Make the first menu item the default */
        if(i == 0) XtVaSetValues(b, XtNdefault, True, NULL);

/* Add callback to each oblong button. In this case, we are
 * using a single callback, but you can have a separate
 * callback for each button.
 */        
        XtAddCallback(b, XtNselect, button_select, 
                      (XtPointer)choices[i]);
    }
    return w;
}
/*-------------------------------------------------------------*/
static void button_select(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
    printf("%s SELECTED\n", (char*) client_data);

/* Exit program if the menu choice is "Exit" */
    if(strcmp((char*)client_data, "Exit") == 0)
    {
        XtCloseDisplay(XtDisplay(w));
        exit(0);
    }
}


