.\ @(#)fsptool.man 1.6	93/12/13
.TH fsptool 1 "13th December 1993" "X11R5"
.SH NAME
fsptool \- An X-Windows interface to the FSP file transfer clients.
.SH REVISIONS
This manual applies to version 1.6 of the FSPtool application.
.SH SYNOPSIS
.B fsptool
[
.I
generic-tool-arguments
]
.SH DESCRIPTION
FSPtool is an easy to use graphical interface to the FSP client programs. The
command line use of the various FSP clients ( fget, fput, etc ... ) is avoided and
their functionality is provided in an easy to use form. Additional features not
provided by the FSP clients are also included to enable you to get the most out
of FSP. FSPtool requires X11R4/5 and XView 3.0 or greater.
.SH OPTIONS
.TP
.B generic-tool-arguments
FSPtool accepts the generic arguments specified in xview(1).
.SH USAGE
.SS Run Time Help
.LP
When correctly installed FSPtool should be able to provide you with run-time
help. Pressing the <HELP> key ( <F1> on some systems ) should display a small
window which gives details of the function of the FSPtool item the pointer was
over when help was pressed.
.LP
.SS Defaults
.LP
It is possible to specify all options to FSPtool through the .fsptooldefaults file
in the user`s home directory. The file specifies defaults for window layout and
status (open/closed), applications for viewing particular filetypes and general
FSPtool options. All options are settable from within FSPtool and so manual
alteration of the .fsptooldefaults file should not be necessary. The options found
in this file will override any defaults entered at compile time.

When saving options FSPtool will save them to the .fsptooldefaults file in your
home directory (any existing information is overwritten). However the list of FSP
host sites which FSPtool knows about is read and written from .fsphosts in your
home directory. This file is in the unofficial but widely used "taxus" format, and
so can be used with other FSP client programs which accept that format. Information
about remote hosts can be edited and viewed through the "Host Information" window.
Each of the individual controls and window which make up FSPtool are explained
below.
.LP
.SS General Usage
.LP
The rest of these manual pages describe the operation and purpose of the items
that make up the FSPtool application - the various windows and their contents.
Along with the run-time help this should enable you to make full use of the
application simply by reading and experimenting.
.LP
.LP
.SS The Remote Window (FSPtool Version 1.6)
.LP
This is FSPtool's main window, from within this window all of FSPtool's functions
can be accessed. It is divided into four parts, a series of buttons and a file drop
site along the top of the window, then a button for accessing previous remote
directories and a textfield giving the name of the current directory. Next the
remote directory listing area where the contents of remote directories are listed.
Finally at the bottom two status areas, the left gives general status messages
while the right hand side gives the number of files in the current directory and
the number (if any) of them which you have selected.

.sp .5
.B File Menu Button
.sp .5
.RS
.TP 10
.B Copy Files
Copies the selected files and/or directories from the remote machine to the local
machine. Directories are recursively copied along with all of their contents. The
copied files are placed in the current local working directory. If the Transfer
Status window is visible then you will be able to see the status of the transfer
as it progresses.
.TP
.B Add to Batch List
Adds the currently selected items to the list of items in the batch transfer list.
This list is viewable in the Batch Transfer window.
.TP
.B File Filter
Shows a window containing the current setting of the remote file filter. This makes
it possible to screen out filetypes that you aren't interested in, see the Set
File Filter window.
.TP
.B File Viewers
Shows a window showing the current actions to take to view the filetypes which
FSPtool knows about. See the File Viewers window.
.TP
.B Quit Program
Does just that, quits the application. Will prompt you for conformation. If you
then confirm the Quit request, FSPtool will exit.
.RE
.LP
.LP
.B View Menu Button
.sp .5
.RS
.TP 10
.B Local Directory List
Shows the window containing a list of files in the current local directory. This
window also gives access to functions affecting the local files. See Local
Directory window.
.TP
.B View Selected File
Will cause the first currently selected file in the remote directory listing to be
downloaded. An appropriate viewer will then be run for it depending on it's type.
The same effect can be achieved by double-clicking ( quickly pressing <SELECT>
twice in succession on an item ) on a file item in the directory listing. If the
file is compressed and FSPtool has access to an appropriate decompression program
then it will be decompressed before being viewed. The downloaded file will be
deleted after you quit the viewer application.
.TP
.B Batch Transfer List
Show the list of files in the batch transfer list, see Batch Transfer window.
.TP
.B Transfer Status
Show the state of the current transfer ( if one is in progress ), see Transfer
Status window.
.TP
.B Host Information
Show the list of hosts which FSPtool currently knows about and the information
which goes with them. See Host Information window.
.TP
.B About FSP Client/Server
Show information about the local FSP clients which FSPtool is using and about
the remote server currently specified. A window will be popped up in which this
information is displayed, if no valid remote site is currently specified then
no details are shown for the remote host section.
.TP
.B About FSPtool
Show a window containing information about FSPtool and it's author.
.RE
.LP
.LP
.B Properties Menu Button
.sp .5
.RS
.TP 10
.B FSPtool
Set properties to do with the FSPtool application itself. See Properties.
.TP
.B Directory Lists
Set properties to do with remote and local directory listings. See Properties.
.TP
.B FSP
Set FSP specific properties that affect the operation of operations carried out
through FSP. See Properties and run-time help for a detailed description.
.TP
.B FSP Clients
Set the filenames of the FSP client programs to use for obtaining directory lists,
getting and putting files etc. Overrides the compiled in defaults. See Properties.
.TP
.B Save Layout
Save the positions, sizes and open/closed state of windows. These saved states
will be restored when the application is next run. This relies on a certain
degree of window manager cooperation, but as long as FSPtool knows whether or not
an OpenLook window manager is running (see FSPtool Properties section) it should
work correctly. To my knowledge it works correctly with olwm, olvwm, mwm, twm and
vtwm window managers.
.RE
.LP
.TP
.B Set Host Button
Show the Set Host window, from here you can enter details of the host and port
address to use or choose one from the menu of hosts which FSPtool knows about.
See Set Host window.
.TP
.B Abort
This button is only active during transfers, if pressed it aborts the current
transfer operation.
.TP
.B File Drop Site
This is a drop site for drag and drop operations. It accepts drops forwarded from
application which give a filename of the file which was being dragged - such as
the OpenWindows file-manager application. The file dropped onto this site will be
uploaded to the current remote directory, the original file is left intact.
.TP
.B Remote Directory Menu Button
This button brings up a menu of the directories held in the remote directory cache
(if any). Selecting one of them will cause it to become the currently selected
remote directory and it will be displayed in the remote directory listing area.
.TP
.B Remote Directory Textfield
The name of the current remote directory is shown in this field. A new name can
be entered or the existing one altered pressing <ENTER/RETURN> then selects this
as the new directory - if it exists and is readable.
.TP
.B Remote Directory List
This area is a scrolling list containing the filenames and file information for
all of the files found in the current remote directory. From the list you can
traverse the directory structure by moving up and down through directories shown
and view files.
.TP
.B Remote Directory List Menu
.sp .5
.RS
.TP 10
.B Unselect All
Unselects all files within the directory listing.
.TP
.B Select All
Selects all the files within the directory listing.
.TP
.B Get Selection
Same as <Copy Files> copies the selected files to the current local directory.
.TP
.B Add to Batch List
Adds the currently selected files onto the list of files in the batch transfer
list.
.RE
.LP
To view a directory double-click upon the directory entry in the list, it then
becomes the current remote directory and it's contents are shown. To view a file
you do the same, if it is compressed then it will be decompressed and then an
appropriate viewer started for that type of file.
.LP
.SS File Filter window
.LP
This window allows you to alter the file filtering which FSPtool can apply to the
remote directory listing. Essentially this allows you to specify to FSPtool what
types of files you want to see in the list and which you are not interested in.
Once you have the settings you want you can either simply <Apply> them which
applies them to the current session but does not save them or <Save> them which
both applies and saves them.
.LP
.TP 10
.B File Filtering
Determines whether or not file filtering is enabled.
.TP
.B Show
When file filtering is on, this determines which filetypes will be displayed. It
presents a list of all the file types FSPtool understands and a tick by those
which will be shown, remove the tick and files of that type will not be displayed.

.SS File Viewers window
.LP
This window shows the current viewers to use with the file types that FSPtool
understands. Each file type has a command line associated with it, when a file
of that type is viewed this command is used to view it.

A command line consists of the name of an application to run as the first item, either a full pathname of the name of a file that will be found in your path. This
is followed by any arguments that this command may take. If you specify %f as a
argument then the filename of the file being viewed will be substituted at that 
point, if %f is not specified then the filename is appended to the command string.

.SS Local Directory window
.LP
The local directory window provides similar functions to the remote main window
but intended for operation on local files.

.sp .5
.B File Menu Button
.sp .5
.RS
.TP 10
.B Copy Files
Copies the slected files and/or directories from the local machine to the remote
machine. Directories are recursively copied along with all of their contents. The
copied files are placed in the current remote directory.
.RE
.LP
.B View Menu Button
.sp .5
.RS
.TP 10
.B View Selected File
Will cause the first currently selected file in the local directory listing to be
viewed. An appropriate viewer will then be run for it depending on it's type.
The same effect can be achieved by double-clicking ( quickly pressing <SELECT>
twice in succession on an item ) on a file item in the directory listing. If the
file is compressed and FSPtool has access to an appropriate decompression program
then it will be decompressed before being viewed.
.RE
.LP
.TP
.B Local Directory Field
This field names the current local directory, editing this name and pressing
<ENTER/RETURN> will cause FSPtool to go to the specified new directory. If it
does not exist FSPtool will prompt you as to whether you wish to create it, if you
do and it can be created it will then become the current local directory.
.TP
.B Free Space
This field shows the free space on the device to which the current local directory
belongs.
.TP
.B Local Directory Listing
This local directory listing has precisely the same functionality as the remote
directory listing window.

.SS Batch Transfer window
.LP
This window shows the list of files in the batch transfer list and provides access
to functions to manipulate this list.
.TP
.B Do Transfer Button
Selecting this button will start a transfer of all items from their respective
hosts to the current local directory.
.TP
.B Write Menu Button
.sp .5
.RS
.TP 10
.B Textfile
Write the list of files and locations out to a textfile, will pop up a window
prompting for the name and directory of a file to which the text is written.
.RE
.LP
.TP
.B Options Menu Button
.sp .5
.RS
.TP 10
.B Add Files
This option will add files which are selected in the remote directory listing to
the items in the batch transfer listing.
.TP
.B Delete Files
This option provides you with two further options, either delete all of the
selected items in the list or delete all items in the list regardless of whether
they are selected or not. NB: this isn't deleting the actual files that items
reference to, simply the items in the list.
.TP
.B Group Files
This option groups files alphabetically by host/port and filename order.
.TP
.B Do Transfer
This option provides you with two further options, either transfer all the files
in the list which are selected, or transfer all files regardless of whether they
are selected or not.

.SS Transfer Status window
.LP
This window shows information about the state of the current download or upload.
It shows the operation currently in progress and any file involved, as well as the
proportion of the current file which has been transferred and proportion of the
entire transfer operation (for multi-file operations) which has been completed. It
also shows the total size of the transfer and the file transfer rate for the last
file successfully transferred.

.SS Host Information window
.LP
This window displays information on the hosts which FSPtool has information about,
from here you can add, edit, delete, load and save information about host aliases.
The list at the foot of the window shows the aliases currently known, selecting
an alias causes the various fields to be filled in with it's details.

The Save button will change to <Save> when changes have been made to your hosts
information which requires changing.

.TP
.B Edit Button
This button will edit the details for the alias named by the Alias field. If the
alias already exists then it's details will be modified to match those given in
the field in this window. If the alias field contains a new alias not previously
used then this new alias will be created with the details from the various fields.
.TP
.B Delete Button
Deletes the current alias from the list.
.TP
.B Clear Button
Clears the fields of information associated with the current alias.
.TP
.B Load Button
Loads the .fsphosts file in from your home directory.
.TP
.B Save Button
Saves the current list to the .fsphosts file in your home directory. Changes to
<Save> when changes have been made that require saving.
.TP
.B Alias Fields
.sp .5
.RS
.TP 10
.B Alias
The actual alias to use for this host, should be a single word with no spaces.
.TP
.B Host
The address of the host, in either numeric or name format.
.TP
.B Port
The numeric UDP port address for the specified host.
.TP
.B Info
A line of information about the host - purely for your benefit, FSPtool isn't
bothered what goes in here.
.TP
.B Local Dir
The local directory to change to when this alias is used. This isn't currently
implemented as the "taxus" format doesn't have room for such a field yet.
.TP
.B Remote Dir
The remote directory to first go to when this alias is used. This defaults to /
( the root directory ) if not specified.

.SS About FSP Client/Server window
.LP
This window shows information about the local FSP clients which FSPtool is using and about the remote server currently specified. A window will be popped up in which this information is displayed. The first line will be output from the
"fver -h" command showing details of the local version of FSP. The next few lines
will be output from the "fver" command which shows information from the remote
server.  If no valid remote site is currently specified then no details are shown for the remote host section and a message to that effect is displayed instead.

.SS About FSPtool window
.LP
This window simply displays information about the current version of FSPtool, who
the author is and what FSPtool is.

.SS Set Host Window
.LP
From this window you can either manually enter a host/port combination to specify
a remote FSP server to use, or alternatively select one from the menu of remote
host alises which FSPtool knows.

.TP
.B Clear Button
Clears the contents of the Host and Port fields.
.TP
.B Host Menu Button
Brings up a menu of alises which FSPtool knows ( if any exist ) this is read in
from the .fsphosts file in your home directory and the information in the Host
Information window. When an alias is selected it's host and port details will be
entered into the Host and Port fields, if the "Open Directory on Select" property
is activated then FSPtool will automatically attempt to obtain a directory listing
when an alias is selected from this menu.
.TP
.B Host Field
Host addresses are entered here either numerically ( eg: 132.215.34.8 ) or as a
host name ( eg: src.doc.ic.ac.uk ).
.TP
.B Port Field
The numeric port number associated with the named host is entered here.
.TP
.B Apply Button
Clicking on this button will cause the given host and port combination to be
applied, FSPtool will then attempt to get a directory listing for the root
directory of that FSP server.

.SS Properties
.LP
Properties are applied either to the current session through use of any <Apply>
button from a properties window. Alternatively if the <Save> button is used they
are both applied to the current session and saved in the .fsptooldefaults file in
your home directory. The Save Layout option is independent of other properties
and is only updated when Save Layout is used.

.RE
.LP
.TP
.B FSPtool options
.sp .5
.RS
.TP 10
.B OpenLook (Window Manager)
This option is used to tell FSPtool that it is running under an OpenLook compliant
window manager such as olwm and olvwm. If you're not using an OpenLook window
manager ( eg: mwm, twm ) then you should not have this selected. This enables
FSPtool to make a better job of organising it's windows.
.TP
.B Close Frame on <Cancel>
When ticked this option causes FSPtool to close a window ( regardless of any
pushpin state it might have ) when the window's <Cancel> button is activated. This
is useful for window managers that do not provide a close option in the window
frame menu.
.TP
.B Close Open Frame from Menu
If this option is enabled FSPtool will close an open window when the menu item
which would normally display it is activated.
.TP
.B Open Directory on host select
When ticked FSPtool will attempt to open and read the base directory for the alias
just selected from the <Hosts> menu in the "Set Host" window.
.RE
.LP
.TP
.B Directory Listings Options
.sp .5
.RS
.TP 10
.B Cache Size
This slider sets the number of directories which will be cached internally to
FSPtool. This cacheing speeds up directory reading and reduces the load on FSP
servers. The cache size is settable between a maximum of 25 and a minimum of 1 (
which effectively turns off cacheing ).
.TP
.B Timeout
This slider sets the ageing for directory caches, caches which are more than this
number of minutes old will be re-read. Setting this to 0 will also effectively
turn off cacheing.
.TP
.B File listing sort
This determines the field by which file entries will be sorted into order. Either
by the alphabetic name of the file, date/time or by size.
.TP
.B Name Sort Order
If sorting by Name this determines whether the order is alphabetic or reverse-alphabetic.
.TP
.B Date Sort Order
If sorting by Date this determines whether the order is with newer (more recent)
files first or older (less recent) files first.
.TP
.B Size Sort Order
If sorting by size this determines whether the order is with smaller files first
or with larger files first.
.RE
.LP
.TP
.B FSP Options
This options directly affect the operation of the FSP clients rather than the
operation of FSPtool itself. They tailor some of the more obtuse parts of the
FSP clients operation, the only two options which are likely to be useful to
most users are for seting the Timeout and the Delay increasing these values
gives you more chance of successfully using sites with dodgy network links or
very slow/overloaded servers.
.sp .5
.RS
.TP 10
.B Buffer
Determines the size of the packets of data which the FSP clients will use for
transferring data. Normally the larger the better, however in unusual circumstances
some networks may not be able to cope with chunks this size, in this case you
can try setting the Buffer size to some smaller value, 512 should be small enough.
.TP
.B Local Port
You shouldn't alter this value unless you know what you are doing. When set to 0
it is effectively turned off and not used. Any other value causes the FSP clients
to use that port number locally. This may clash with other FSP clients, with other
network services or simply be a number the system reserves as it's own, hence the
disclaimer, you shouldn't normally need to use this.
.TP
.B Timeout
Determines the timout delay when FSP clients are waiting for a response from
the remote server. Generally if no response is recieved from a server within this
amount of time, the FSP client will time out and the request will fail. When
transfering a file this is used as a base and can increase as the FSP client
tries to get a response before eventually timing out. If you're having trouble
with "Remote Server not Responding" errors from a site which does actually exist,
then try increasing this value. The site replies may just be slow in coming and a
longer timeout value prevents FSP timing out before they arrive.
.TP
.B Delay
Determines the delay to use from sending a request and not receiving a reply to
sending the request again. As for the timeout value setting this higher can help
in using slow or overloaded sites. Value is in milliseconds.
.RE
.LP
.TP
.B FSP Client Options
These options allow you to override the compiled in FSP client programs which
FSPtool uses. The names you use should be ones which are in your path
or be full pathnames starting at / and correspond to a FSP client program which
preforms the required task - the merged client set works normally with this.
.sp .5
.RS
.TP 10
.B fver
Name of the FSP client program to use to obtain version information from local
and remote hosts, normally "fver".
.TP
.B fls
Name of the FSP client program to use to get directory listings from remote
host, normally "flscmd".
.TP
.B fget
Name of the FSP client program to use to copy files from the remote host to the
local host, normally "fgetcmd".
.TP
.B fput
Name of the FSP client program to use to copy files from the local directory to
the remote host directory, normally "fput".
.RE
.LP
.TP
.B Save Layout
Selecting this saves layout information for all of FSPtool's windows. When
FSPtool is next started the window positioning information will be taken from the
.fsptooldefaults file in your home directory. This relies on a certain degree of
window manager cooperation, but as long as FSPtool knows whether or not an
OpenLook window manager is running (see FSPtool Properties section) it should work
correctly.

.SH FILES
.TP 15
.B $HOME/.fsptooldefaults
Default settings for FSPtool, updated whenever <Save Layout> or any of the <Save>
buttons are used.
.TP
.B $HOME/.fsphosts
List ( in "taxus" format ) of hosts, aliases and descriptions used by FSPtool as
the FSP sites which it knows of. Updated through the "Host Information" window.
.SH "SEE ALSO"
.BR xview(7),
.BR fsp_prof(5),
.BR fget(1),
.BR fgetcmd(1),
.BR fgrab(1),
.BR fgrabcmd(1),
.BR fls(1),
.BR flscmd(1),
.BR fprocmd(1),
.BR fpro(1),
.BR fmkdir(1),
.LP
.B "Taxus Format - see the file /fsplist.std at FSP site taxus.uib.no 9000"
.SH AUTHOR
.RE
.LP
Andrew Doherty (ssudoher@uk.ac.reading)

