/*-------------------------------------------------------------*/
/*  File:  timeout.c
 *
 *  Displays time using timeouts
 *
 */
/*-------------------------------------------------------------*/
#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/StaticText.h>

#define MAXCHR 80

static char line[MAXCHR] = " ";

static void update_time();
/*-------------------------------------------------------------*/
void main(argc, argv)
int  argc;
char **argv;
{
    Widget      top_level, time_label;

/* Initialize the toolkit and create the top-level widget */
    top_level = OlInitialize(argv[0], "Timeout", NULL, 0,
                               &argc, argv);

/* Set up a StaticText widget to display the time */

    time_label = XtVaCreateManagedWidget("Time", 
                      staticTextWidgetClass, top_level,
                      XtNstring,    line,
                      NULL);

    update_time(time_label);

/* Realize the widgets */
    XtRealizeWidget(top_level);

/* Start the main event-handling loop */
    XtMainLoop();
}
/*-------------------------------------------------------------*/
/*  u p d a t e _ t i m e
 *
 *  Updates the time by invoking the UNIX "date" command
 *  and reinstalls function using XtAddTimeOut
 */
static void update_time(w)
Widget w;
{
    FILE     *fp;
        
/* Run "date" to get time */

    if((fp = popen("/bin/date", "r")) == NULL)
    {
        perror("popen");
        exit(1);
    }
    if(fgets(line, MAXCHR, fp) == NULL)
    {
        perror("fgets");
        exit(1);
    }
    pclose(fp);

/* Display the time in the StaticText widget */
    XtVaSetValues(w, XtNstring, line, NULL);
    
/* Make sure that this function is called again in 10 seconds */
    XtAddTimeOut(10*1000, update_time, w);
}

