.TH CROCK 1 "Release 6" "X Version 11"
.SH NAME
crock - X window system one or two player interactive fighting game
.SH SYNOPSIS
.B "crock"
[-\fItoolkit options\fP]
[
.B \-v\||\|-h\||\|-f configfile\||\|-debug n\||\|-disney
]
[
.B secondXdisplay
]
.SH DESCRIPTION
.PP
.I Crock
is a one or two player fighting game that runs with the
X Window System.   You control your 
fighter by making offensive and defensive moves.  The characters
fight until one player's strength runs out.  After describing the
options, this man pages describes the attacks, defenses,
and finishing moves, as well as some strategy.  For information 
on how to configure the game, refer to 
.BR player.config (5) 
and 
.BR config.crock (5)
which describe the formats of the general and player-specific configuration
files.

.SH OPTIONS
.TP
.B \-debug \fIn\fP
Add \fIn\fP to debugging level.  Default level is 0 (no debug information).
.TP
.B \-disney
Make game rated-G (no blood, gore, etc).
.B \-f \fIconfigfile\fP
Use \fIconfigfile\fP for the master config file instead of the
compiled in default.  Refer to 
.BR config.crock (5)
for details on the file format.
.TP
.B \-h
Print a help/usage message (not terribly useful).
.TP
.B \-v
Print the version information (including patchlevel).
.TP
.B secondXdisplay
Is the name of the second display for player two.  It is the 
standard display:0.0 style.  This parameter \fImust\fP be 
specified if two humans want to play.

.SH THE DISPLAY
There are two fighters on the screen,
controlled either the computer or humans.  Keys sequences
control offensive and defensive moves.  A "power bar" at
the top of the screen shows the relative health of each 
fighter.  Every hit (including blocked hits) does damage
and reduces the player's strength.
The time remaining in the round is displayed at
the top, between the two power bars.  A round ends either
when time runs out or one of the player's strength drops 
to zero.  A round is "won" only if the loser's strength
is at zero;  a round that ends otherwise has no victor.
To win a match, a player must win two rounds.  A circle
under the power bar indicates the number of rounds won in 
the current match.  The scrollbar labeled "volume" allows
the user to control the volume of the sounds (useful only
if 
.I crock
has been compiled with -DHASNETAUDIO and an audio server
is running on the machine used as a display (refer to
.BR netaudio
) for more information.  
.PP
There are two buttons, labeled
"quit" and "play again".  Clicking on "quit" at any time
causes the game to end.  Clicking on "play again" at the 
end of a match causes a new match to begin.
.PP
In addition, there are two sets of buttons labeled "human" and 
"computer" for the left player and the right player.  Clicking
on one sets that player (right or left) to be controlled by a human
or computer, respectively.  By default, the game starts up with
both players controlled by the computer.  If the game is running
in single player mode, clicking on "human" for one character automatically
makes the other player controlled by the computer.

.SH ATTACKS
.PP
Standard attacks include punches (left, right and uppercuts) and kicks
(low and high), as well as a leg sweep or trip move.  The range of a move
is different for each move and each character.  These move are generally
only effective at a close range.  Keyboard and keypad keys are used
for these attacks (currently the plus, enter and insert (shifted and 
unshifted) on the keypad for kicks and punches, and keyboard keys for
other attacks ('s' for the sweep).
.PP
Special moves include fire projectiles
as well as other non-standard attacks (including teleport).  Some specific
to a particular character.  These attacks tend to be more distance
oriented, and in fact projectiles do not work if the opponent is is 
too close.  The 'Return' key on the keyboard fires a projectile.

.SH DEFENSES
.PP
Blocking and crouching and jumping are the main defensive moves.  The
down and up arrows cause the character to crouch and jump, respectively.
Holding the space bar blocks.  Blocked hits take damage, but also leave
the opponent vulnerable for a retaliation.

.SH FINISHING MOVES
.PP
They exist.  Each character has some.  Some are more difficult to
perform than others or have certain prerequisites.  If you are curious,
look at the keybindings in the player config file for some clues and if
you are really curious, then read the source code.  The "f" key, usually
plain or with the <SHIFT> or <CONTROL> key is a good place to start.

.SH CONFIGURING
.PP
To compile, it should be sufficient just to run "xmkmf" and then
make.  Edit the file "runcrock" and change the path to be whatever
the proper path is.  By default, all other paths are specified
relative to the crock/bin directory.  If you don't like that, then 
change the paths in "config.crock" and the player config files
(currently "tb.config" and "gecko.config").

The keybindings in the initial version are something I threw together.
They are not intended to be the optimal configuration and are pretty
easy to change.  Certain attributes of characters or moves (damage or
x and y offsets, for example) are also easy to change.  Other changes,
like adding moves require more extensive changes to the config file or
even code changes if it is adding a special move that does not yet exist.

.SH STRATEGY
.PP
The computer sucks.  It was not intended to be wonderfully intelligent,
simply as a way to test things.  Two player mode is far more challenging,
if you have a fast enough network connection.  
.I Crock
was designed to use a minimal amount of network bandwidth once the
initial loading stages have completed.  The best strategy is probably 
a mix of offensive and defensive.  Purely offensive is not the way to 
go, since all moves can be blocked and retaliated.  Pure defense is just
plain boring.  Just like continually throwing projectiles is considered
bad etiquette (and angers the Beerhunter).
Currently, Sel-Fesh is probably not as powerful as The Gecko, though in
the hands of a good player, it probably shouldn't be that great of a 
disadvantage.
.SH MORE INFORMATION
.PP
If there is enough interest, a mailing list or newsgroup can be created.
Check the crock entry in my web page for more information
(currently: http://www.cis.ohio-state.edu/hypertext/people/frank_adelstein.html
but eventually http://www.cis.ohio-state.edu/~frank/crock.html).
This has taken far more time than I originally intended, so there's a limited
amount of improvements and bug fixes that I will be capable of doing.  
Contributions are always welcome, though I might not be able to deal with
them in a timely fashion.  The danger of the game is that almost anything
can be added to it.  I don't intend it to be "the fatality game" and
see how many tricks I can stuff into it.  However there is a lot of room
for improvement, perhaps by interested parties.  In other words, have a blast.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
To get default host and display number.
.PP
.TP 8
.B CROCKROOT
The toplevel directory for crock, prepended to all file access if defined.
.SH FILES
.PP
.TP 8
.B config.crock
Master config file (overridden by -f filename command line switch).
.TP
.B playername.config
Config file for player (specified in config.crock).
.SH BUGS
Quite a few, but it's a game, right?  Bug fixes will be accepted.
Certain "bugs" might actually be features.  This could be considered
a bug.
.SH SEE ALSO
.BR netaudio
.BR player.config (5)
.BR config.crock (5)
.SH COPYRIGHT
Copyright 1994, Frank Adelstein.
.br
