char inbxver[] = "@(#)inblank.c	1.1";		/* SCCS */

#include <stdio.h>
#include "define.h"
#include "extern.h"

/* Miscellaneous routines, alphabetic order */
 
Inblank(n)	/* Insert blanks (and line numbers) in left margin */
short n;
{
	short Ncp, p, Px[Nwidth+1], i;
	short TPo = Div?0:Po;

	if( !Fn ) LnReg->Value = ++Lno;
	if( !Fn && Ncol>1 ) {
		Blank(n);
		return;
	}
	Ncp = 0;
	if( Lnt && !Fn ) Ncp=Pagen(LnReg,Px);
	p = TPo - 2 - Ncp;
	if( p >= 0 ) {
		Blank(p);
		for( i = 1; i<=Ncp; i++ ) {Write(Px[i]);}
		Blank(2+n);
	}
	else Blank(TPo+n);
}

char *
Label(Reg)
char *Reg;
{
	short Junk = 4;

	Getname(&Junk,Reg);
	if( Reg[0] == 0 ) Reg[0] = Skip;
	return(Reg);
}

Leave(n)
short n;
{
	if( !Top && (Nl+n<=Bl) ) Rawnl(n);
	else if( Ma1+Ma2+n+Lv>Bl ) {
		Eject(); Space(0); Lv=n;
	}
	else Lv += n;
}

Linesp(n)
short n;
{
	Break();
	Ls = n;
	if( Fn ) Ls2=n; else Ls1=n;
	Topbot();
	Break();
}

Lnumber(q,Lvs)	/* Arithmetic expression evaluator */
short q, *Lvs;
{
	short n = 0, Anydigit = false, Op = 0, i = *Lvs, c;

	c = Lsearch(&i);
	switch( c ) {
		case '+':
		case '-':
		case '%':
		case '*':
		case '/': Op = c; break;
		default: i = i-1;
		case Skip: break;  }
	for(;;) { c = Rawchar[i];
		if( !Numeric(c) ) break;
		n = n*10+c-'0';
		Anydigit = true;
		i++;
		}
	if( !Anydigit ) return(1);
	*Lvs = i;
	switch(Op) {
		case '+': q += n; break;
		case '-': q -= n; break;
		case '*': q *= n; break;
		case '/': if(n) q /= n; else q=0; break;
		case '%': if(n) q %= n; else q=0; break;
		default: q = n;
	}
	return( Max(0,q) );
}

Lsearch(Lvs)	/* Search for next printable char */
short *Lvs;
{
	short c, i;

	for( i = *Lvs; i<Nr; i++ ) {
		c = Rawchar[i];
		if(Width[c]!=1 || SpTab(c)) continue;
		*Lvs = i+1;
		return(c);
	}
	return(Skip);
}

struct macrodef *
Macalloc(n)	/* Macro space Allocation */
short n;
{
	struct macrodef *D;

	D = (struct macrodef *)Caloc(1,sizeof(*D)+n);
	D->Dsize = n;
	D->Ucount = 1;
	return(D);
}

Macrel(D)	/* Macro space Release */
struct macrodef *D;
{
	if( !D ) return;
	if( --D->Ucount > 0 ) return;
	cfree(D,1,sizeof(*D)+D->Dsize);
}

Macro(Reg,s)	/* Recall Macro */
char *Reg;
short s;
{
	short Px[Nwidth+1], Ncp, i, j;
	struct regvec *Md;
	struct macrodef *D;
	register struct inputsource *z;

	if( (Md=Findreg(Reg))==0 ) return(false);
	if( Md->Style == 0 ) {
		D = Md->Rdef;
		D->Ucount++;
	}
	else {               /* expand numeric variable */
		if( !s ) return(false);  /* only if invoked by insertion char */
		D = Macalloc(Nwidth);
		Ncp = Pagen(Md,Px);
		for( j = 1; j<=Ncp; j++ ) D->Dstring[j-1] = Px[j];
		D->Dstring[Ncp] = Eof;
	}
	z = (struct inputsource *)Caloc(1,sizeof(*z));
	z->Nextsrc = Callstack;
	z->Mdef = D;
	z->Argq = Qch;
	z->String = s;
	if( !s ) {
		z->Call = (char *)Caloc(Maxline+1,sizeof(*(z->Call)));
		for( i = 1; i<Nr; i++ ) z->Call[i] = Rawchar[i];
		z->Call[Nr] = '\n';
	}
	Callstack = z;
	return(true);
}

Makenum(z)
struct regvec *z;
{
	if( z->Style != 0 ) return;
	Macrel(z->Rdef);
	z->Style = '1';
	z->Value = 0;
	z->Minwidth = 1;
	z->Rdef = 0;
}

Margin(Lm)
short *Lm;
{
	*Lm = Number(*Lm);
	Topbot();
}

Max(a,b)
short a,b;
{
	return( a>b? a: b );
}

Mcflush()  /* flush out multi-column output */
{
	char **Col;
	short Nlines,i,j,k,c,jcol,klines,tcol,jmax;

	Nlines = (Mclines+Ncol-1)/Ncol;
	Nl += Nlines;
	if( Mclines && Print ) {
		/* find column text pointers */
		jcol = Mclines/Nlines; /* Number of complete cols */
		klines = Mclines%Nlines; /* Lines in last partial column */
		tcol = klines ? jcol+1 : jcol; /* Cols with any text */
		Col = (char **)Caloc(Ncol,sizeof(*Col));
		Col[0] = Mcbuf+(i=1);
		for( j=1; j<tcol; j++) {
			for( k=0; k<Nlines; k++)
				while( Mcbuf[i++]!='\n' ) ;
			Col[j] = Mcbuf+i;
		}
	
		/* concatenate columns & print */
		jmax = tcol;
		for( k=0; k<Nlines; k++) {
			for( i=0; i<Po; i++) {Writech(' ');}
			i=Co;
			if (k == klines) jmax = jcol; /* Now shorten rows */
			for( j=0; j<jmax; j++) {
				while( i++ < Co ) {Writech(' ');}
				i=0;
				while((c = *Col[j]++) != '\n' ) {
					{Writech(c);}
					i += Width[c];
				}
			}
			{Writech('\n');}
		}
	
		cfree(Col,Ncol,sizeof(*Col));
	}
	Mclines = Mcc = 0;
	return;
}

Min(a,b)
short a,b;
{
	return( a<b? a: b );
}
 
Need(n)
{
	int Room;

	n *= Ls;
	if(Nl==0) return;
	Room = Bl-Nl;
	if(Room<n) {
		if(Bl-Ma1-Ma2>=n)
			Eject();
	} else {
		if(Room>0) Room -= Mclines%Room;
		if(n>Room) Newline(Room);
	}
}

NRchar(c)
short c;
{
	c &= Ulmask;
	return( !SpTab(c) && Width[c]>0 && c!='(' && c!=')' );
}

Newline(n)	/* Insert blanks (source number, requests) in right margin */
short n;
{
	short Nblk, Ncp, i;
	short Px[Nwidth+1];
	struct regvec z;

	if( Pp>0 && n>0 ) {
		Blank(Mc-Pp);
		Nblk = Sq+Po-Pp;
		if( Sq>Ll && Nblk>=0 && (Fn||Ncol==1) ) { /* Input line # in right margin */
			z.Value = Seqno>0? Seqno: InLno;
			z.Style = '1';
			z.Minwidth = 1;
			Ncp = Pagen(&z,Px);
			if(!( Fn&&(Nblk+Ncp+Fnc>=Fsize) )) {
				Blank(Nblk);
				for( i = 1; i<=Ncp; i++ ) {Write(Px[i]);}
			}
		}
		Seqno = 0;
		if( NRq>0 && (Fn||Ncol==1) ) {
			Nblk = Rq+Po-Pp;
			if(!( Rq<=Ll||Nblk<0||Fn&&(Nblk+NRq+Fnc>=Fsize) )) {
				Blank(Nblk);
				for( i = 1; i<=NRq; i++ ) {Write(Rqbuf[i]);}
			}
			NRq = 0;
		}
	}
	for( i=1; i<=n; i++) {
		if( MgAll ) Blank(Mc-Pp);
		Rawnl(1);
	}
}

Number(q)
short q;
{
	short Junk = 4;

	return( Lnumber(q,&Junk) );
}

Otest()
{
	int low;
	char *Ol = Olist;
	for(;;) {
		switch(*Ol) {
		default:
			if(!Numeric(*Ol)) return(true);
			low = atoi(Ol);
			while(Numeric(*Ol)) Ol++;
			break;
		case '\0':
			return(false);
		case '-':
			low = 0;
		}
		switch(*Ol) {
		default:
			return(true);
		case '\0':
			return(Np==low);
		case ',':
			if(Np==low) return(true);
			Ol++;
			continue;
		case '-':
			Ol++;
		}
		switch(*Ol) {
		default:
			if(!Numeric(*Ol)) return(true);
			if(Np>=low && Np<=atoi(Ol))
				return(true);
			while(Numeric(*Ol)) Ol++;
			break;
		case '\0':
			return(Np>=low);
		case ',':
			if(Np>=low) return(true);
			Ol++;
			continue;
		}
	}
}

Overlay()	/* Special case .sp -1 */
{
	short Ne = 0, i;

	for(i=1; i<Nc; i++) {
		Ne += Width[Char[i]&Ulmask];
		if(Ne < 0) Ne = 0;
	}
	if(Ne+Un >= In) Break();
	else {	Nc--;
		while(Ne+Un < In) {
			Char[++Nc] = Tabpad;
			Ne++;
		}
	}
}

Pagen(z,Px)	/* Format register according to style */
struct regvec *z;
short *Px;
{
	short n,s,S,i,k,Ncp,D[Nwidth+1];
	short d,Pad,base;
	static char *I = ".ixcm";
	static char *V = ".vld";
	static char *alphabet = "abcdefghijklmnopqrstuvwxyz";
	static char *digits = "0123456789abcdef";

	n = z->Value;
	S = z->Style;
	s = Lcase[S];
	if( n<=0 || s=='i'&&n>=4000 || s=='a'&&(n-1)/26>=Nwidth ) s = S = '1';
	i = Ncp = 0;
	base = s=='o'?  8:
			 s=='x'? 16:
						10;
	if( s=='a' ) while( Ncp<=(n-1)/26 )
		Px[++Ncp] = alphabet[ (n-1)%26 ];
	else {
		while( n>0 ) { D[++i] = n%base; n = n/base; }
		while( i>0 ) {
			d = D[i];
			if( s=='i' )   /* roman numerals */
				if( d%5 == 4 ) {
					Px[++Ncp] = I[i];
					Px[++Ncp] = (d>=5?I[i+1]:V[i]);
				}
				else   { if( d>=5 ) Px[++Ncp] = V[i];
					for( k = 1; k<=d%5; k++ )
						Px[++Ncp] = I[i];
				}
			else Px[++Ncp] = digits[d];
			i--;
		}
	}
	if( S=='I'||S=='A'||S=='X' )
		for( i=1; i<=Ncp; i++ ) Px[i] = Ucase[Px[i]];
	Pad = z->Minwidth - Ncp;
	if(!( Pad<=0 || s=='a' || s=='i' )) {
		for( i = Ncp; i>=1; i-- ) Px[i+Pad] = Px[i];
		for( i = 1; i<=Pad; i++ ) Px[i] = '0';
		Ncp = Ncp + Pad;
	}
	return(Ncp);
}

Pause()
{
	if( !Print ) return;
	Npause--;
	Nstop++;
	if( Nstop>=Stop || Npause>=0 && Online ) {
		Nstop = 0;
		Prompt(""); /* There's a BELL between the quotes */
	}
}

Popup()	/* End of source file */
{
	short s;
	struct inputsource *t;
 
	if( Callstack->Mdef == 0 ) {
		InLno = Callstack->Curch;
		fclose(Callstack->Infile);
		s = true;
	} else
		s = Callstack->String;
	Macrel(Callstack->Mdef);
	t = Callstack->Nextsrc;
	if( Callstack->Call ) cfree(Callstack->Call,Maxline+1,sizeof(*(Callstack->Call)));
	cfree(Callstack,1,sizeof(*Callstack));
	Callstack = t;
	return(s? Eof: '\n');
}

Prompt(prchrs)
char *prchrs;
{
	extern FILE *tty;
 
	fprompt(prchrs);
	getc(tty);
}

Pushcall(File)	/* New source file */
FILE *File;
{
	struct inputsource *z;

	z = (struct inputsource *)Caloc(1,sizeof(*z));
	z->Infile = File;
	z->Nextsrc = Callstack;
	z->String = false;
	z->Curch = InLno;
	Callstack = z;
	InLno = 0;
}

