#
/*arch op name...       manipulate files on Spider file system*/

/*op has the following values:
r	replace. files in the UNIX system are copied into files
	in the Spider system.
x	extract.  files in the UNIX file system are replaced by their
	equivalents in the Spider file system.
d	delete.   files in the Spider system are deleted.
t	titles.   the titles of directory contents are listed.
s	status.   the status of directory contents are listed.
*/


#define snchan 0	/*Spider channel to file system*/
#define sff 0
#define spos 1
#define sposx -1
#define sz 2
#define dsz 16		/*directory entry size*/

char buf[512];
char nam[100];
int stack[30];
int dirbuf[40];
int nchar;
int fn;		/*Spider network file id*/

char *terr "snt\0\0";
char *ferr "fst\0\0";

char op		/*op code*/;
char **eargv;
char *np;	/*pointer into nam[]*/
char *bp	/*pointer into buf[]*/;
char *tp	/*pointer into *argv[]*/;
char ltp;	/*type of list operation*/
int *sp;	/*pointer into stack[]*/
int ff;		/*file being processed*/
int code;	/*dev/tiu  parameter*/
int i;
int wchar;
int sum;	/*check sum of data bytes*/
int length;	/*number of bytes transmitted*/

char *ng ".\0";
char **nularg &ng;


main(argc,argv)
int argc;
char **argv;
	{

	if (argc<2) exit(); eargv=argv+argc;
	argv++; op = **argv++;
	sp = stack;
	fn = open("/dev/tiu/d0",2);
	if (fn < 0) goto busy;
	bp=buf; cname();
	*bp++ = 'E'; nchar=bp-buf;
	if (send(nchar,3)<0) goto error;
	if (check('N') < 0) goto exx;
	if (argc==2) {argc=3; argv=nularg; eargv=argv+1;}
	sp = stack;

	for (;;)
	    {
	    tp = gen();
	    if (!tp)
		{
		if (argv == eargv)
		    {
		    buf[0]='X';
		    if (send(1,3) < 0) goto error;
		    check('N');
		    exit();
		    }
		tp = *argv++; np = nam;
		while (*tp) *np++ = *tp++;
		*np = 0; sp[spos] = np;
		tp = nam;
		}
	    switch(op)
		{
	    case 'r':
		ff = open(tp,0);
		if (ff<0) goto erf;
		bp=buf; name(tp);
		if (dir())
		    {
		    *bp++ = 'C';
		    goto single;
		    }
		*bp++ = 'W'; *bp++ = 0; *bp++ = 0;
		nchar = bp - buf;
		if (send(nchar,3) < 0) goto error;
		if (check('W') < 0) goto exx;
		sum=0; length=0;
	    copyr:
		nchar = read(ff,buf,512);
		sum =+ addup(nchar); length =+ nchar;
		if (nchar==0) code=2; else code=1;
		if (send(nchar,code) < 0) goto error;
		if (nchar > 0) goto copyr;
		goto knxt;
	    case 'x':
		ff = creat(tp,0666);
		if (ff<0) goto erf;
		bp = buf; name(tp);
		*bp++ = 'R'; *bp++ = 0; *bp++ = 0;
	    copyL:
		nchar = bp - buf;
		if (send(nchar,3) < 0) goto error;
		if (check('R') < 0) goto exx;
		sum = 0; length = 0;
	    copyx:
		nchar = read(fn,buf,512);
		if (nchar < 0) goto error;
		sum =+ addup(nchar); length =+ nchar;
		if (nchar != 0) wchar=write(ff,buf,nchar);
		snstat(fn,&code,1);
		if ((nchar != 0)&&(code < 2)) goto copyx;
		if (code != 2) goto ers;
		if (op != 'x') goto cnxt;
	    knxt:
		if (check('N') < 0) goto exx;
		bp = buf; *bp++ = 'K';
		*bp++ = (sum >> 8); *bp++ = (sum & 0377);
		*bp++ = (length >> 8); *bp++ = (length & 0377);
		send(5,3);
	    cnxt:
		close(ff);
	    nxt:
		if (check('N') < 0) goto exx;
		break;
	    case 'd':
		bp = buf; name(tp);
		*bp++ = 'D';
	    single:
		nchar = bp - buf;
		if (send(nchar,3)<0) goto error;
		goto nxt;
	    case 't':
		ltp = 'L'; goto lst;
	    case 's':
		ltp = 'S';
	    lst:
		bp=buf; name(tp);
		*bp++ = ltp;
		ff = dup(1); goto copyL;
	    default:
		printf("illegal op-code\n");
		}
	   }

busy:
	printf("Spider busy\n"); exit();
ers:
	printf("Illegal format from file store\n"); exit();
erf:
	printf("cannot open file %s\n",tp); exit();
error:
	snstat(fn,&code,3);
ep:
	terr[3]=code; err(terr);
	exit();
exx:
	snstat(fn,&code,3);
	if (code != 0) goto ep;
	printf("file %s :",nam);
	ferr[3]=buf[1]; err(ferr);
	exit();
	}


err(ep)
char *ep;
{
	printf("Error: %s\n", ep);
}

cname()
	{
	sp=stack;
upscan:
	ff=open(".",0);
	if (ff<0) goto help;
	do {
	    if (read(ff,dirbuf,dsz)<dsz) goto help;
	    i = *dirbuf;
	    }while (dirbuf[1] != '.');
	if (i!=1)
	    {
	    sp[spos]=i; sp[sff]=ff; sp=+sz;
	    chdir("..");
	    goto upscan;
	    }
downscan:
	np = nam;
	while (sp!=stack)
	    {
	    sp=-sz; i=sp[spos];
	    seek(ff,0,0);
	    do {
		if (read(ff,dirbuf,dsz)<dsz) goto help;
		} while (i != *dirbuf);
	    tp = dirbuf+1; *np++ = '/';
	    for (i=0;i<14;i++)
		{
		if (*tp==0) break;
		*np++ = *tp++;
		}
	    close(ff); ff=sp[sff];
	    }
	close(ff); *np++ = 0;
	chdir(nam+1);
	np=find(nam)+1; name(np);
	return(0);
help:
	printf("bad directory structure\n"); exit();
	}

name(p)
char *p;
	{
	*bp++='N';
	while (*p) *bp++ = *p++;
	*bp++ = 0;
	}

check(c)
char c;
	{
	int r;
	r=read(fn,buf,512);
	if (r<0) return(-1);
	snstat(fn,&r,1);
	if ((*buf==c)&&(r=3)) return(0); else return(-1);
	}

send(n,c)
char c;
int n;
	{
	char v[2]; v[1]=0; v[0]= *buf;
	snstat(fn,&c,0);
	return(write(fn,buf,n));
	}


dir()
	{
	i = stat(tp,dirbuf);
	if ((i < 0)||((dirbuf[2] & 060000) != 040000)) return(0);
	sp =+ sz; sp[sff]=ff;
	return(1);
	}

gen()
	{
	char *ps, *pd;
up:
	if (sp==stack) return(0);
agn:
	if (read(sp[sff],dirbuf,dsz) < dsz)
	    {
	    close(sp[sff]);
	    sp =- sz;
	    goto up;
	    }
	if (dirbuf[0] == 0) goto agn;
	if ((dirbuf[1] == '.')||(dirbuf[1]=='..')) goto agn;
	ps = dirbuf+1; pd = sp[sposx];
	*pd++ = '/';
	for (i=0; i<14; i++)
	    {
	    if (*ps == 0) break;
	    *pd++ = *ps++;
	    }
	sp[spos]=pd; *pd = 0;
	return(nam);
	}


char *nlist[] {"/usr\0", "/crp\0", 0};

find(p)
char *p;
	{
	char *pp, **cp, *fp, *dp;
	cp=nlist;
	while (*cp)
	    {
	    fp = *cp++; dp = p;
	    while ((*fp)&&(*fp++ == *dp++));
	    if ((!*fp)&&(*dp=='/')) return(dp);
	    }
	return(p);
	}

addup(n)
int n;
	{
	int k,s; s=0;
	if (n>0) {for (k=0; k<n; k++) s =+ buf[k];}
	return(s);
	}
