match(tree, nreg)
int tree[];
{
	extern dcalc, ctable[];
	int op, d1, d2, t, table[];

	if (tree==0)
		return(0);
	op = *tree;
	t = tree[1];
	if (op<30)
		d1 = dcalc(tree[3], nreg);
	else
		d1 = 12;		/* is leaf */
	if (op<20) {		/* binary? */
		d2 = dcalc(tree[4], nreg);
	} else
		d2 = 0;
	table = ctable;
	while(*table) {
		if (*table++ == op) goto foundop;
		table++;
	}
	return(0);
foundop:
	table = *table;
	while(*table) {
		if (*table++ == t) goto foundt;
		table++;
	}
	return(0);
foundt:
	table = *table;
	while(*table) {
		if (d1<=table[0] & d2<=table[1])
			goto found;
		table = table+3;
	}
	return(0);
found:
	return(table[2]);
}

rcexpr(tree, reg)
int tree[]; {
	extern cexpr, printf, error;

	if(tree==0)
		return;
	if (cexpr(tree, reg))
		return;
	error("No match for op %d,%d", tree[0], tree[1]);
}

cexpr(tree, reg)
int tree[]; {
	extern match, nreg, printf, pname, putchar, ctable;
	extern modef, modei, clnum;
	int p1[], p2[], c, r, p[], table, ac;
	char string[], match[];

	if (*tree==52) {		/* call */
		table = ac = 0;
		p = clnum++;
		p1 = tree[4];
		while(p1) {
			p2 = p1[1];
			if(*p2!=30) {	/* not rval */
				rcexpr(p2, 0);
				c = p2[2];
				if (c==1) c = 2;
				printf("mov%c	r0,-(sp)\n", c<4? 0:'f');
				printf("mov	sp,a%d+%d\n", p, ac);
				table =+ c;
			}
			p1 = p1[2];
			ac =+ 2;
		}
		printf("jsr	pc,");
		pname(tree[3]);
		printf("\n.data; a%d:\n", p);
		p1 = tree[4];
		while(p1) {
			p2 = p1[1];
			if (*p2 == 30)
				pname(p2);
			else
				printf("..");
			printf("\n");
			p1 = p1[2];
		}
		printf(".text\n");
		if (table)
		printf("add	$%o,sp\n", table);
		return(1);
	}
	if ((string=match(tree, nreg-reg))==0) 
		return(0);
	p1 = tree[3];
	p2 = tree[4];
loop:
	switch(c = *string++) {

	case '\0':
		return(1);

	/* A1 */
	case 'A':
		p = p1;
		goto adr;

	/* A2 */
	case 'B':
		p = p2;
		goto adr;

	/* A */
	case 'O':
		p = tree;
	adr:
		pname(p);
		goto loop;

	/* MF */
	case 'C':
		if (modef!=1) {
			printf("setf\n");
			modef = 1;
		}
		goto loop;

	/* MD */
	case 'D':
		if(modef!=2) {
			printf("setd\n");
			modef = 2;
		}
		goto loop;

	/* ML */
	case 'L':
		if(modei!=2) {
			printf("setl\n");
			modei = 2;
		}
		goto loop;

	/* MI */
	case 'N':
		if (modei!=1) {
			printf("seti\n");
			modei = 1;
		}
		goto loop;

	/* F */
	case 'G':
		p = p1;
		goto subtre;

	/* S */
	case 'K':
		p = p2;
		goto subtre;

	/* H */
	case 'H':
		p = tree;

	subtre:
		r = reg;
		c = *string++ - 'A';
		if((c&010)!=0)
			r = reg+1;
		rcexpr(p, r);
		goto loop;

	/* R */
	case 'I':
		r = reg;
		goto preg;

	/* R1 */
	case 'J':
		r = reg+1;
	preg:
		printf("r%d", r);
		goto loop;

	case '#':
	case '"':
	case '~':
		printf("xxx");
		goto loop;

	}
	putchar(c);
	goto loop;
}

pname(p)
int p[]; {
	extern putchar, printf, error;
	char np[];

	if (*p >= 30) {
		np = p[3];
		while(*np)
			putchar(*np++);
		return;
	}
	error("pname called illegally");
}

dcalc(p, nreg)
int p[]; {

	if(p[2]==0)
		return(12);
	return(p[2]<=nreg? 20: 24);
}

error(s, p1, p2) {
	extern printf, fout, flush, putchar, nerror;
	int f;

	nerror++;
	flush();
	f = fout;
	fout = 1;
	printf(s, p1, p2);
	putchar('\n');
	fout = f;
}
