%< '='
%< '!'
%< '+' '-'
%< '*' '/'
%> '^'
%{
#define	tos	sp[-1]
#define	sis	sp[-2]
#define	push	sp++
#define	pop	sp--
double	reg[26];
double	stk[10];
double	*sp { stk };
double	(*f)();
double	sin();
double	cos();
double	log();
double	bin();
double	exp();
double	floor();
double	sqrt();
double	pow();
%}
%%
line:
	stat | line stat;
stat:
	expr '\n' =
	{
		if($$ == 0)
			printf("%f\n", tos);
		sp = stk;
	} |
	'\n' |
	error '\n';
expr:
	letter =
	{
		push;
		tos = reg[$$-'a'];
		$$ = 0;
	} |
	value =
	{
		$$ = 0;
	} |
	fname '(' expr ')' =
	{
		f = $$;
		tos = (*f)(tos);
		$$ = 0;
	} |
	vname =
	{
		$$ = 0;
	} |
	letter '=' expr =
	{
		reg[$$-'a'] = tos;
		$$ = 1;
	} |
	expr '+' expr =
	{
		sis =+ tos;
		pop;
		$$ = 0;
	} |
	expr '-' expr =
	{
		sis =- tos;
		pop;
		$$ = 0;
	} |
	expr '*' expr =
	{
		sis =* tos;
		pop;
		$$ = 0;
	} |
	expr '/' expr =
	{
		sis =/ tos;
		pop;
		$$ = 0;
	} |
	expr '^' expr =
	{
		sis = pow(sis, tos);
		pop;
		$$ = 0;
	} |
	expr '!' expr =
	{
		sis = bin(sis, tos);
		pop;
		$$ = 0;
	} |
	'-' expr =
	{
		tos = -tos;
		$$ = 0;
	} |
	'(' expr ')' =
	{
		$$ = 0;
	};
fname:
	'l' 'o' 'g' =
	{
		$$ = log;
	} |
	's' 'i' 'n' =
	{
		$$ = sin;
	} |
	'c' 'o' 's' =
	{
		$$ = cos;
	} |
	'e' 'x' 'p' =
	{
		$$ = exp;
	} |
	'i' 'n' 't' =
	{
		$$ = floor;
	} |
	's' 'q' 'r' 't' =
	{
		$$ = sqrt;
	};
vname:
	'p' 'i' =
	{
		push;
		tos = 3.14159265;
	} |
	'e' 'e' =
	{
		push;
		tos = 2.718281828;
	};
value:
	fvalue |
	fvalue 'e' snumb =
	{
		sis =* pow(10., tos);
		pop;
	};
snumb:
	number |
	'-' number =
	{
		tos = -tos;
	};
fvalue:
	number |
	number '.' |
	'.' fraction |
	number '.' fraction =
	{
		sis =+ tos;
		pop;
	};
fraction:
	number =
	{
		push;
		tos = $$;
		sis =/ pow(10., tos);
		pop;
	};
number:
	digit =
	{
		push;
		tos = $$-'0';
		$$ = 1;
	} |
	number digit =
	{
		tos = tos*10. + $2 - '0';
		$$++;
	};
letter:
	'a' | 'b' | 'c' | 'd' | 'e' | 'f' |
	'g' | 'h' | 'i' | 'j' | 'k' | 'l' |
	'm' | 'n' | 'o' | 'p' | 'q' | 'r' |
	's' | 't' | 'u' | 'v' |
	'w' | 'x' | 'y' | 'z';
digit:
	'0' | '1' | '2' | '3' |
	'4' | '5' | '6' | '7' |
	'8' | '9';
%%
yylex()
{
	char c;

	do
		if(read(0, &c, 1) != 1)
			exit();
	while(c == ' ');
	yylval = c;
	return(c);
}

double
bin(a, b)
double a, b;
{
	double c;

	b = floor(b+.5);
	if(b < 0. || b > a)
		return(0.);
	c = 1.;
	while(b > .5) {
		c = c*a/b;
		a =- 1.;
		b =- 1.;
	}
	return(c);
}
