#
#include "../param.h"
#include "../systm.h"
#include "../reg.h"
#include "../filsys.h"
#include "../user.h"
#include "../inode.h"
#include "../file.h"
#include "../../shared/constants.h"

#define then /* */

#define true 0177777
#define false 000000
/*
 * the fstat system call.
 */
fstat()
{
	register *fp;

	fp = getf(u.u_ar0[R0]);
	/* if getf couldnt find it */
	if( fp == NULL )
		return;
	stat1(fp->f_inode, u.u_arg[0]);
}

/*
 * the stat system call.
 */
stat()
{
	register ip;
	extern uchar;

	ip = namei(&uchar, 0);
	/* if inode has 0177776 for number then is in use as net node */
	if( ip == NULL || ip->i_number == 0177776 )
		return;
	stat1(ip, u.u_arg[1]);
	iput(ip);
}

/*
 * The basic routine for fstat and stat:
 * get the inode and pass appropriate parts back.
 */
stat1(ip, ub)
int *ip;
{
	register i, *cp;
	register char *bp;

	iupdat(ip, time);
	bp = bfetch(ip->i_dev, ldiv(ip->i_number+31, 16), _READ_ACCESS);
	if (u.u_error)
		return;
	cp = bp + 32*lrem(ip->i_number+31, 16) + 24;
	ip = &(ip->i_dev);
	for(i=0; i<14; i++) {
		suword(ub, *ip++);
		ub =+ 2;
	}
	for(i=0; i<4; i++) {
		suword(ub, *cp++);
		ub =+ 2;
	}
	brelse(bp);
}

/*
 * the dup system call.
 */
dup()
{
	register i, *fp;

	fp = getf(u.u_ar0[R0]);
	if(fp == NULL)
		return;
	if ((i = ufalloc()) < 0)
		return;
	u.u_ofile[i] = fp;
	fp->f_count++;
}

/*
 * the mount system call.
 */
smount()
{
	int d;
	register *ip;
	register int i, j;
	int access;
	char *super;
	extern uchar;

	d = getmdev();
	if(u.u_error)
		return;
	u.u_dirp = u.u_arg[1];
	ip = namei(&uchar, 0);
	if(ip == NULL)
		return;
	if(ip->i_count!=1 || (ip->i_mode&(IFBLK&IFCHR))!=0)
		goto out;
	j = -1;
	for(i = 0; i < NMOUNT; i++)
	{	if (mount[i].m_inuse)
		{	if(d == mount[i].m_dev)
				goto out;
		} else
		if (j < 0)
			j = i;
	}
	if( j < 0 )
		goto out;

	if (u.u_arg[2])
	then	access = _READ_ACCESS;
	else	access = _READ_WRITE_ACCESS;
	blkopen( d , access );
	if(u.u_error)
		goto out;
	i = bfetch(d, 1, access);
	if(u.u_error) {
		brelse(i);
		goto out1;
	}
	mount[j].m_inodp = ip;
	mount[j].m_dev = d;
	super = &superblocks[j];
	bcopy( i, super, 256);
	mount[j].m_inuse = true;
	super->s_flock = false;
	if (access == _READ_ACCESS)
	then	super->s_ronly = true;
	else	super->s_ronly = false;
	brelse(i);
	ip->i_flag =| IMOUNT;
	prele(ip);
	return;

out:
	u.u_error = EBUSY;
out1:
	iput(ip);
}

/*
 * the umount system call.
 */
sumount()
{
	register struct inode *ip;
	register int i;
	int d;
	int access;

	update();
	d = getmdev();
	if(u.u_error)
		return;
	for(i = 0; i < NMOUNT; i++)
		if( mount[i].m_inuse && d == mount[i].m_dev )
			goto found;
	u.u_error = EINVAL;
	return;

found:
	for(ip = &inode[0]; ip < &inode[NINODE]; ip++)
		if(ip->i_number!=0 && d==ip->i_dev) {
			u.u_error = EBUSY;
			return;
		}
	if (&superblocks[i]->s_ronly)
	then	access = _READ_ACCESS;
	else	access = _READ_WRITE_ACCESS;
	blkclose( d , access );
	ip = mount[i].m_inodp;
	ip->i_flag =& ~IMOUNT;
	iput(ip);
	mount[i].m_inuse = false;
}

/*
 * Common code for mount and umount.
 * Check that the user's argument is a reasonable
 * thing on which to mount, and return the device number if so.
 */
getmdev()
{
	register d, *ip;
	extern uchar;

	ip = namei(&uchar, 0);
	if(ip == NULL)
		return;
	if((ip->i_mode&IFMT) != IFBLK)
		u.u_error = ENOTBLK;
	d = ip->i_addr[0];
	if(ip->i_addr[0] >= NBLKDEV)
		u.u_error = ENXIO;
	iput(ip);
	return(d);
}
