/*
**	patterns and functions to call a host via CSIRONET
**
**	SCCSID %W% %E%
*/

#include	"global.h"
#include	"debug.h"

#include	"caller.h"


char
	*CallArgs= CALLARGS,		/* optional args for call */
	*Daemon1 = NNDAEMON,		/* standard daemon */
	*Daemon2 = NN2DAEMON,		/* alternate protocol */
	*HostFlg = "-BCF";		/* cooked protocol over csironet */

char
	*Host,				/* Who am i */
	*Target,			/* Target host */
	*CsiroReq,			/* Request to set-up virtual circuit */
	*Passwd,			/* Password at Target */
	*Device,			/* Device for link */
	*Speed;				/* Speed of link */

int
	Tcount	 = 0,			/* count of Timeouts */
	Ccount	 = 0,			/* count of CSIRONET login attempts */
	Lcount	 = 0;			/* count of Unix login attempts */

int
	AtCSIRONET(),
	AtUNIX(),
	GotEof(),
	GotLogin(),
	GotPasswd(),
	GotTimeout(),
	NoShellFail(),
	Start1(),
	Start2(),
	ToCSIRONET(),
	ToUNIX(),
	reset();

/*
**	CSIRONET messages
*/

char	Disconn[]	= "DISCONNECT SEEN FROM";
char	Invalid[]	= "INVALID LOGIN REQUEST";
char	Noresp[]	= "NO RESPONSE FROM UNIX";
char	Unassi[]	= "TERMINAL IS UNASSIGNED";
char	Unixserv[]	= "UNIX SERVICE";
char	Unrec[]		= "UNRECOGNISED FIRST RECORD";

/*
**	Other common patterns
*/

char	Eof[]		= EOFSTR;
char	Login[]		= "[Ll]ogin";
char	LoginI[]	= "[Ll]ogin +[Ii]ncorrect";
char	Password[]	= "^[Pp]assword";
char	WPassword[]	= "[Ww]rong +[Pp]assword";
char	Timeout[]	= TIMEOUT;

/*
**	The pattern/action sets
*/

PatList	CSIROnet[] =
{
	{ Unassi, AtCSIRONET },
	{ Invalid, AtCSIRONET },
	{ Disconn, AtCSIRONET },
	{ Unixserv, ToUNIX },
	{ Timeout, GotTimeout },
	{ Eof, GotEof },
	{ 0, 0}
};

PatList UNIXnet[] =
{
	{ LoginI, AtUNIX },
	{ WPassword, AtUNIX },
	{ "[Ll]ast +[Ll]ogin", reset },
	{ Login, GotLogin },
	{ Password, GotPasswd },
	{ STARTMSG, Start1},
	{ START2MSG, Start2},
	{ "no shell", NoShellFail },
	{ Unrec, ToCSIRONET },
	{ Unassi, ToCSIRONET },
	{ Invalid, ToCSIRONET },
	{ Disconn, ToCSIRONET },
	{ Timeout, GotTimeout },
	{ Eof, GotEof },
	{ 0, 0 }
};



/*
**	Function to process arguments, either from NNcall, or from CALLARGS.
*/

void
Args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		Trace2(1, "Args: \"%s\"", argv[1]);

		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case '1':
					Daemon1 = ++*argv;
					goto break2;

				case '2':
					Daemon2 = ++*argv;
					goto break2;

				case 'T':
					if ( (Traceflag = atoi(++*argv)) == 0 )
						Traceflag = 1;
					goto break2;

				case 'd':
					Device = ++*argv;
					goto break2;

				case 'l':
					Host = ++*argv;
					goto break2;

				case 'p':
					Passwd = ++*argv;
					goto break2;

				case 's':
					Speed = ++*argv;
					goto break2;

				case 'v':
					CsiroReq = ++*argv;
					goto break2;

				default:
					Command
					(
						"fail unexpected flag \"-",
						*argv,
						"\" in ",
						CallArgs,
						NULLSTR
					);
					exit(1);
				}
			}
break2:			;
		}
		else
			Target = *argv;
	}
}



init(argc, argv)
	int		argc;
	char *		argv[];
{
	register char *	cp;

	Host = NodeName();

	Args(argc, argv);

	if ( (cp = strrchr(*argv, '/')) != NULLSTR )
	{
		*cp = '\0';
		cp = *argv;
	}
	else
		cp = ".";

	CallArgs = concat(cp, "/", CallArgs, NULLSTR);
	(void)readargs(CallArgs, Args);

	DODEBUG
	(
		if
		(
			Target == NULLSTR
			||
			Passwd == NULLSTR
			||
			CsiroReq == NULLSTR
			||
			Device == NULLSTR
		)
		{
			outend("fail incomplete initialisation");
			exit(1);
		}
	);

	Command("retry 120 3", NULLSTR);
	Command("open ", Device, NULLSTR);

	if ( Speed != NULLSTR )
		Command("speed ", Speed, NULLSTR);

	Command("read", NULLSTR);

	ToCSIRONET();
}



ToCSIRONET()
{
	Tcount = 0;
	Command("write T\004", NULLSTR);
	state(CSIROnet);
	getinput();
}



AtCSIRONET()
{
	if (++Ccount >= 10)
	{
		outend("fail CSIRONET down");
		exit(1);
	}

	Command("write ", CsiroReq, "\r", NULLSTR);
	getinput();
}



ToUNIX()
{
	Tcount = 0;
	Lcount = 0;

	Command("write EI\004", NULLSTR);	/* Disable remote echo */

	state(UNIXnet);
	getinput();
}



AtUNIX()
{
	if (++Lcount >= 7)
		Command("fail too many login attempts at ", Target, NULLSTR);

	Command("sleep 10", NULLSTR);
	flushinput();
	Command("write \r", NULLSTR);
	getinput();
}



GotLogin()
{
	if (++Lcount >= 7)
		Command("fail too many login attempts at ", Target, NULLSTR);

	Command("write ", Host, "\r", NULLSTR);
	getinput();
}



GotPasswd()
{
	Command("write ", Passwd, "\r", NULLSTR);
	getinput();
}



Start1()
{
	Command("daemon ", Daemon1, NULLSTR);
	Command("succeed ", HostFlg, " ", Target, NULLSTR);
	exit(0);
}



Start2()
{
	Command("daemon ", Daemon2, NULLSTR);
	Command("succeed ", HostFlg, " ", Target, NULLSTR);
	exit(0);
}



GotTimeout()
{
	if (++Tcount >= 3)
	{
		outend("fail TIMEOUT");
		exit(1);
	}

	if (current == CSIROnet)
		Command("write T\004", NULLSTR);
	else
		Command("write @\r", NULLSTR);

	reset();
}



GotEof()
{
	outend("fail unexpected EOF");
	exit(1);
}



NoShellFail()
{
	outend("fail no shell");
	exit(1);
}
