/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Link.c	1.1 84/06/12
*/

/*
**	Make link from node to node and return pointer to Data.
*/

#include	"global.h"

#include	"debug.h"
#include	"state.h"

#include	"node.h"



Data *
MakeLink(ep1, ep2)
	Entry *		ep1;
	Entry *		ep2;
{
	register Node *	np1 = ep1->e_node;
	register Node *	np2 = ep2->e_node;
	register Link *	lp;
	register Data *	dp;
	register bool	from;

	Trace3(3, "MakeLink %s -> %s", ep1->e_name, ep2->e_name);

	dp = (Data *)0;
	from = false;

	/** Search for link from other node **/

	for
	(
		lp = np2->n_l_first ;
		lp != (Link *)0 ;
		lp = lp->l_next
	)
		if ( lp->l_entry == ep1 )
		{
			dp = lp->l_data;
			from = true;
			break;
		}

	/** Check for duplicate link from this node **/

	for
	(
		lp = np1->n_l_first ;
		lp != (Link *)0 ;
		lp = lp->l_next
	)
		if ( lp->l_entry == ep2 )
		{
			dp = lp->l_data;
			break;
		}

	if ( lp == (Link *)0 )
	{
		Trace3(2, "Link from \"%s\" to \"%s\"", ep1->e_name, ep2->e_name);

		lp = Talloc(Link);
		*np1->n_l_last = lp;
		np1->n_l_last = &lp->l_next;

		lp->l_entry = ep2;

		if ( (lp->l_data = dp) == (Data *)0 )
			lp->l_data = dp = Talloc(Data);

		np1->n_fromlinks++;
		np2->n_tolinks++;

		if ( from )
		{
			dp->d_states |= S_FOUND;
			EdgeCount++;
		}
	}

	return dp;
}



/*
**	Remove a link to/from a deleted/unfound node.
*/

void
Unlink(ep, lpp)
	register Entry *	ep;
	register Link **	lpp;
{
	register Link *		lp;

	lp = *lpp;

	Trace3(2, "Unlink %s from node %s", lp->l_entry->e_name, ep->e_name);

	if ( !(lp->l_data->d_states & S_FOUND) )
	{
		EdgeCount--;
		free((char *)lp->l_data);
	}
	else
		lp->l_data->d_states &= ~S_FOUND;

	*lpp = lp->l_next;

	if ( ep->e_node->n_l_last == &lp->l_next )
		ep->e_node->n_l_last = lpp;

	ep->e_node->n_fromlinks--;
	lp->l_entry->e_node->n_tolinks--;

	free((char *)lp);
}
