/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)WriteCom.c	1.2 84/07/02
*/

/*
**	Write out a command file from list.
*/

#include	"global.h"
#include	"command.h"


int
WriteCom(chp, fd, name)
	ComHead *	chp;
	int		fd;
	char *		name;
{
	register ComEl *cep;
	register int	size;
	register char *	cp;
	char *		commands;

	for ( size = 0, cep = chp->ch_first ; cep != (ComEl *)0 ; cep = cep->ce_next )
	{
		if ( cep->ce_name != NULLSTR )
			size += strlen(cep->ce_name) + 1;
		else
			cep->ce_name = "";	/* Avoid (null) syndrome */
		size += LENGTH_SIZE*2;
	}

	if ( size == 0 )
		return 0;

	commands = cp = Malloc(size);

	for ( size = 0, cep = chp->ch_first ; cep != (ComEl *)0 ; cep = cep->ce_next )
	{
#		if	PRINTF_NULLS == 0 || SPRF_SIZE == 0
		register char *	sp;

		size = sprintf
			(
				cp,
				"%s%c%lu%c%lu%c",
				cep->ce_name, '\177',
				cep->ce_base, '\177',
				cep->ce_range, '\177'
			);

#		if	SPRF_SIZE == 0
		size = strlen(cp);
#		endif	SPRF_SIZE == 0

		for ( sp = cp ; *sp != '\0' ; )
			if ( *sp++ == '\177' )
				sp[-1] = '\0';

#		else	PRINTF_NULLS == 0 || SPRF_SIZE == 0

		size = sprintf
			(
				cp,
				"%s%c%lu%c%lu%c",
				cep->ce_name, 0,
				cep->ce_base, 0,
				cep->ce_range, 0
			);

#		endif	PRINTF_NULLS == 0 || SPRF_SIZE == 0

		cp += size;
	}

	size = cp - commands;

	while ( write(fd, commands, size) != size )
	{
		Syserror("Can't write \"%s\"", name);
		(void)lseek(fd, (long)0, 0);
	}

	free(commands);

	return size;
}
