/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)UniqueName.c	1.3 84/11/01
*/

/*
**	Make a unique path name using size of message, current time, and process id.
**	Checks that "name" is at least UNIQUE_NAME_LENGTH characters long.
**	Assumes that "pid" has only 15 bits of useful info.
*/

#include	"global.h"
#include	"spool.h"
#include	"debug.h"

extern int	Pid;


static char	validchars[]	= "+-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
static int	next_char	= 8;



char *
UniqueName(name, size, t)
	char *		name;
	long		size;
	register Time_t	t;
{
	register char *	p;
	register char *	q;
	register char *	x;
	register int	pid = Pid;

	/*
	**	Find last element of path name
	*/

	if ( (p = strrchr(name, '/')) == NULLSTR )
		p = name;
	else
		p++;

	DODEBUG(if(strlen(p)<UNIQUE_NAME_LENGTH)Fatal2("UniqueName last component too short: \"%s\"",name));

	/*
	**	Set first char to reflect message size.
	*/

	if ( size > 0 )
	{
		if ( size < SMALL_MESSAGE )
			*p = SMALL_ID;
		else
		if ( size < MEDIUM_MESSAGE )
			*p = MEDIUM_ID;
		else
			*p = LARGE_ID;
	}

	/*
	**	Find end of name.
	*/

	while ( *p++ );
	p--;

	/*
	**	Last char reflects current HZ.
	*/

	*--p = validchars[ticks() & 077];

	/*
	**	Next 3 chars reflect "pid".
	*/

	for ( q = p-3 ; p != q ; )
	{
		*--p = validchars[pid & 077];
		pid >>= 6;
	}

	/*
	**	"pid" is only 15 bits, so remember position of deficient char.
	*/

	x = p;				/* Only 3 bits from "pid" have affected this char */

	/*
	**	Next 6 chars reflect "t".
	*/

	t += size / 16;			/* ~ 1 minute per 1000 bytes */

	for ( q = p-6 ; p != q ; )
	{
		*--p = validchars[t & 077];
		t >>= 6;
	}

	/*
	**	Filename generated shouldn't exist,
	**	but if it does, change marked char.
	*/

	for ( pid = 0 ; access(name, 0) != SYSERROR ; pid++ )
	{
		if ( pid >= (sizeof validchars - 9) )
			Fatal1("cannot make UniqueName");

		*x = validchars[next_char++];

		if ( next_char >= (sizeof validchars - 1) )
			next_char = 8;
	}

	return name;
}



/*
**	Make up UID_LENGTH chars to represent uid in last element of path name.
*/

char *
UniqueUid(name, uid)
	char *		name;
	int		uid;
{
	register char *	p;
	register char *	q;

	/*
	**	Find last element of path name
	*/

	if ( (p = strrchr(name, '/')) == NULLSTR )
		p = name;
	else
		p++;

	/*
	**	Take significant bits off uid to form string.
	*/

	for ( q = p + UID_LENGTH ; q != p ; )
	{
		*--q = validchars[uid & 077];
		uid >>= 6;
	}

	return name;
}
