/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ExpandString.c	1.1 84/06/12
*/

/*
**	Expand a string to printable characters.
*/

#include	"global.h"

#define	BUFZ	512


char *
ExpandString(string, size)
	char *	string;
	int	size;
{
	register char *	cp;
	register char *	ep;
	register char *	bp;
	register int	c;
	static char	buf[BUFZ];

	for ( cp = string, ep = &string[size], bp = buf ; cp < ep ; )
	{
		if ( (c = *cp++) < ' ' || c >= '\177' || c == '\\' )
		{
			(void)sprintf(bp, "\\%03o", c&0xff);
			bp += 4;
		}
		else
			*bp++ = c;

		if ( bp >= &buf[BUFZ-5] )
			break;
	}

	*bp++ = '\0';

	return buf;
}
