#define		STDIO

#include	"global.h"
#include	"debug.h"
#include	"mailer.h"

talk(a, except)
struct command	*a;
struct ex	*except;
{
	/*
	**	Have a programmed conversation as given by the
	**	command array 'a', checking for VMS error messages
	**	specified by exceptions array 'except'.
	**	Timeouts and retries are currently hardwired.
	*/

	struct command	*p;
	int		failcount;
	int		status;


	suckline(10);		/* Remove junk from line */
	for(p = a; p->poke != (char *) 0; p++)
	{
		failcount = 0;
		status = FAIL;

		while (status == FAIL && failcount < 2)
		{
			writeout(p->poke,strlen(p->poke));
			status = getreply(p->reply,p->cflags,p->func,except);
			Trace2(1, "reply status=%s\n", status?"SUCCESS":"FAIL");
			if( status == FAIL )
			{
				suckline(5);	/* empty read buffer */
				failcount++;
			}
			if(!(p->cflags & CANRETRY))
				break;
		}
		if (status == FAIL)
		{
			/* Something is wrong */
			return(FAIL);
		}
	}
	return(SUCCESS);
}

getreply(rep,flags,f,except)
char	*rep;
unsigned flags;
int	(*f)();
struct	ex	*except;
{

	static	char	junkbuf[10000];
	char	*jp = junkbuf;
	int	status;
	int	charcount;
	int	replen;

	replen = strlen(rep);
	charcount = 0;
	jp = junkbuf;
	*jp = 0;

	if(*rep == '\0')
	{
		/* No reply is expected */
		if (flags & JUNKTOFUNC)
			(*f)(junkbuf,THATSALL);	/* junkbuf must be "" */
		return(SUCCESS);
	}
	for(;;)
	{
		xalarm(30);
		status = readc(jp);
		xalarm(0);
		if (status != SUCCESS || timeout)
			return(FAIL);	/* What about the chars we read? */
		charcount++;
		*++jp = '\0';

		if(doexceptions(except,junkbuf,charcount) == 1)
			return(FAIL);

		if( charcount < replen )
			continue;		/* Can't match yet */
		if (endmatch(rep,junkbuf,charcount) == SUCCESS)
		{
			/* We have a match */
			Trace1(1, "Match !\n");
			if( flags & JUNKTOFUNC )
			{
				/* Give the junk to the procedure */
				if (*(jp-replen-1) != '\n')
				{
					*(jp-replen) = '\n';
					jp++;
				}
				*(jp-replen) = '\0';
				(*f)(junkbuf,THATSALL);
			}
			return(SUCCESS);
		}
		else
		{
			/* No match */
			if (flags & PROMPTEXACT)
				return(FAIL);

			if (charcount >= (sizeof(junkbuf) - 129) && (*(jp-1) == '\n'))
			{
				/*
				** Give what you can. Scan back from the
				** end 2 (!) lines. Give all before that
				** point, and replace in buffer what is
				** after it. In this way, matches PROBABLY
				** will still work.
				** YUK
				*/
				jp--;
				while(*--jp != '\n')	/* better be one! */
					;
				*jp = '\0';
				Trace1(1, "Ditching too much output\n");
				if (flags & JUNKTOFUNC)
					(*f)(junkbuf,MORETOCOME);
				*jp = '\n';
				strcpy(junkbuf,jp);	/* Move it forward */
				charcount = strlen(junkbuf);
				jp = &junkbuf[charcount];
				*jp = '\0';
			}
		}
	}
}

doexceptions(a,s,len)
struct	ex	*a;
char	*s;
int	len;
{
	int state=0;

	while(a->bad != (char *) 0)
	{
		if (endmatch(a->bad,s,len) == SUCCESS)
		{
			state = 1;
			if(a->fun != 0)
				(*(a->fun))(a->bad);
		}
		a++;
	}
	return(state);
}

endmatch(pat,s,n)
char	*pat;
char	*s;
int	n;
{
	/*
	** See if pat matches on the end
	** of string s length n
	*/
	int	count;

	count = strlen(pat);
	if (count > n)
		return(FAIL);
	return(strcmp(pat,&s[n-count])? FAIL : SUCCESS);

}
