#define		STDIO

#include	"global.h"
#include	"debug.h"
#include	"mailer.h"

char	* Name;
int	Traceflag;

#define	MAXDEV		5

char	* Device[MAXDEV];
char	* RelayArgs	= "relayargs";
char	* Target	= NULLSTR;
short	baud		= 0;

struct	ex	noexceptions[] =
{
	{ (char *) 0, 0 }
};

struct	command	signon[] = 
{
#ifdef CSIRO
	{ DISCONNECT, "TERMINAL IS UNASSIGNED\n", SKIPTOPROMPT|CANRETRY, 0},
	{ "*NXTIA,UUSAJH/,UUSAJH/WOMBAT,SY\n", "VAX", SKIPTOPROMPT|CANRETRY, 0},
#endif CSIRO
#ifdef SWITCH
	{ "\r", "", JUNKTOFUNC, sleep2 },	/* first \r to data switch */
	{ "\r", "(U)?\007",SKIPTOPROMPT|CANRETRY,0},/* talk to data switch */
	{ "a\r", "Username: ", SKIPTOPROMPT|CANRETRY, 0 }, /* select vaxa */
#else SWITCH
	{ "\r", "Username: ", SKIPTOPROMPT|CANRETRY, 0 },
#endif
	{ loginname, "Password: ", SKIPTOPROMPT, 0 },
	{ password, "$", SKIPTOPROMPT, 0 },
	{ "mail\r", "MAIL>", SKIPTOPROMPT|CANRETRY, 0},
	{ (char *) 0, (char *) 0, 0, 0 },
};

struct	command signoff[] =
{
	{ "exit\r", "$", SKIPTOPROMPT|CANRETRY, 0 },
	{ "logout\r", "logged out", SKIPTOPROMPT|CANRETRY, 0 },
#ifdef CSIRO
	{ DISCONNECT, "USER DISCONNECTED", SKIPTOPROMPT, 0 },
	{ DISCONNECT, "TERMINAL IS UNASSIGNED\n", SKIPTOPROMPT|CANRETRY, 0 },
#endif CSIRO
	{ (char *) 0, (char *) 0, 0, 0 }
};

struct	command mailstart[] =
{
	{ "mailterm\r", "\n$ ", SKIPTOPROMPT|CANRETRY, 0 },
	{ "mail\r", "\nMAIL> ", SKIPTOPROMPT|CANRETRY, 0 },
	{ (char *) 0, (char *) 0, 0, 0 }
};

struct	command mailstop[] =
{
	{ "exit\r", "\n$ ", SKIPTOPROMPT|CANRETRY, 0 },
	{ (char *) 0, (char *) 0, 0, 0}
};


int	Devices = 0;
int	gotadminflag = 0;
int	failcount = 0;
int	reallyfailed = 0;
int	exitcode = 0;

main(ac, av)
int	ac;
char	**av;
{
	extern void	args();
	extern bool	readargs();
	register char	* cp;

	loginname[0] = '\0';
	password[0] = '\0';
	ignoreflag = 0;
	nosignonflag = 0;
	sendflag = 0;
	recflag = 0;
	foreverflag = 0;
	mailsetupflag = 0;
	logfp = NULL;
	fromsydfp = NULL;
	tosydfp = NULL;

	if ((Name = strrchr(*av, '/')) != NULLSTR)
		Name++;
	else
		Name = *av;

	args(ac, av);

	if (Target != NULLSTR)
		RelayArgs = concat(SPOOLDIR(), Target, "/", RelayArgs, NULLSTR);
	else
	{
		if ((cp = strrchr(*av, '/')) != NULLSTR)
		{
			*cp = '\0';
			cp = *av;
		}
		else
			cp = ".";
		RelayArgs = concat(cp, "/", RelayArgs, NULLSTR);
	}
	if (readargs(RelayArgs, args) == false)
		usage_err("bad or no relayargs file");

	if ( (ac == 1) || ( (sendflag == 0) && (recflag == 0) ) )
		usage_err("You must either send or receive (or both)");

	if (Devices == 0)
		usage_err("No devices given");
	if (baud == 0)
		usage_err("No baud rate given");
	if (gotadminflag == 0)
		usage_err("No administrator given");
	if (loginname[0] == '\0')
		usage_err("You must give a VMS login name");
	if (password[0] == '\0')
		usage_err("You must give a password for the VMS account");
  
	logopen("logfile");
	fprintf(logfp,"\n:::::::::::: %s\n",ijtime());
	sneakopen("sneakfile");
again:
	if (signal(SIGINT,cleanup) == SIG_IGN)
		signal(SIGINT,SIG_IGN);
	signal(SIGTERM,cleanup);
	if (ignoreflag == 1)
	{
		signal(SIGINT,SIG_IGN);
		signal(SIGQUIT,SIG_IGN);
	}
	while (netopen(Device, baud) == -1)
	{
		sleep(30);
		if (++failcount >= 3)
			exit(1);
	}
	failcount = 0;
	fprintf(logfp,"\n<------ Trying signon ------>\n");

	while (nosignonflag == 0 && talk(signon,noexceptions) == FAIL)
	{
		long t1,t2;
		fprintf(logfp,"\n<------ Signon failed ------>\n");
#ifdef CSIRO
		writeout(DISCONNECT,strlen(DISCONNECT));
#endif CSIRO
		time(&t1);
		suckline(10);
		time(&t2);
		fprintf(logfp,"suckline %ld seconds\n",t2-t1);
		fflush(logfp);
		if (++failcount >= 3)
		{
			fprintf(stderr,"I just can't get through!\n");
/*  In case VMS is stuck in MAIL or still logged in from an earlier session: */
/*  \032 = CTRL/Z  */
			writeout("\032\032\032",3);
			writeout("logout\r",7);
			netclose();
			if(reallyfailed)
			{
				fprintf(stderr,"I give up\n\n");
				exit(1);
			}
			reallyfailed = 1;
			if(logfp == NULL)
				logopen("logfile");
			goto again;
		}
	}
/*
	suckline(5);	/* Let it settle down after signon */
	if(mailsetupflag)
		talk(mailstart,noexceptions);
	if (recflag)
	{
		fprintf(logfp,"\n<------ Reading mail from VMS to UNIX ------>\n");
		if (getmail() == FAIL)
			exitcode = 1;
	}
	if (sendflag)
	{
		fprintf(logfp,"\n<------ Writing mail from UNIX to VMS ------>\n");
		if (putmail() == FAIL)
			exitcode = 1;

	}
	if (mailsetupflag)
		talk(mailstop,noexceptions);
	if(nosignonflag == 0)
		talk(signoff,noexceptions);
	fprintf(logfp,"\n<------ Signed off, I think ! ------>\n");
	suckline(10);			/* Just get rid of junk on line */
	netclose();
	if(foreverflag)
	{
		sleep(60*30);
		goto again;
	}
	exit(exitcode);
}

#ifdef SWITCH
sleep2(sarg,dumb)
char *sarg;
int dumb;
{
	sleep(2);
	return(SUCCESS);
}
#endif SWITCH

usage_err(s)
char	* s;
{
	fprintf(stderr, "Usage: %s [-fim] -bbaud -dtty -aadministrator [-rrecfile] [-ssendfile] -lloginname -ppassword node\n", Name);
	if (s != NULLSTR)
		fprintf(stderr, "%s\n", s);
	exit(1);
}

void
finish(code)
int	code;
{
	exit(code);
}

void
args(ac, av)
register int	ac;
register char	*av[];
{
	while (--ac > 0)
	{
		if (**++av == '-')
		{
			register int	c;

			while (c = *++*av)
			{
				switch(c)
				{
				case 'd':
					if ( Devices >= MAXDEV)
					{
						usage_err("Too many devices");
						exit(1);
					}
					Device[Devices++] = ++*av;
					goto break2;

				case 'a':
					gotadminflag = 1;
					administrator = ++*av;
					goto break2;

				case 'i':	/* Ignore interrupts etc */
					ignoreflag = 1;
					goto break2;

				case 'r':
					recflag = 1;
					recfile = ++*av;
					goto break2;

				case 's':
					sendflag = 1;
					sendfile = ++*av;
					goto break2;

				case 'b':
					baud = atoi(++*av);
					goto break2;

				case 'T':
					Traceflag = 1;
					goto break2;

				case 'f':	/* Forever */
					foreverflag = 1;
					goto break2;

				case 'm':	/* do the mail pre/post amble */
					mailsetupflag = 1;
					goto break2;

				case 'l':	/* Alternate login name */
					strcpy(loginname,++*av);
					strcat(loginname,"\r");
					goto break2;

				case 'p':	/* Alternate password */
					strcpy(password,++*av);
					strcat(password,"\r");
					goto break2;

				case 'n':	/* Don't sign on or off */
					nosignonflag = 1;
					goto break2;

				default:
					usage_err(NULLSTR);
				}
			}
break2:			;
		}
		else
		{
			Target = *av;
		}
	}
}

/*
**	Extract arguments from passed file,
**	and pass them back via the passed function
**	to look like program invoked arguments.
*/

bool
readargs(file, funcp)
	char *		file;
	int		(*funcp)();
{
	register char *	ap;
	register int	i;
	VarArgs		va;

	if ( (ap = ReadFile(file)) == NULLSTR )
		return false;

	FIRSTARG(&va) = Name;

	if ( SplitArg(&va, ap) >= MAXVARARGS )	/* SplitArg processes quotes */
		usage_err("Too many arguments in args file");

	(void)(*funcp)(NARGS(&va), &ARG(&va, 0));
	free(ap);

	return true;
}
