/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)WriteState.c	1.19 88/08/28
*/

/*
**	Write new version of State file from contents of sorted Node list.
*/

#define	STDIO

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"node.h"
#include	"statefile.h"


static Crc_t	StCRC;
static Export_t	WrExport;
static FILE *	WrStateFd;
static char	Buf[TOKEN_SIZE+3];

static void	WrAlias();
static void	WrCString();
static void	WrFlags();
static void	WrNode();
static void	WrNumber();
static void	WrString();



void
WriteState(fd, export)
	FILE *		fd;
	Export_t	export;
{
	if ( Home == (Entry *)0 )
		return;

	WrStateFd = fd;
	WrExport = export;
	StCRC = 0;

	{
		register Domain *	dp;

		/*
		**	Write domain hierarchy
		*/

		if ( (dp = DomHier.d_head) != (Domain *)0 )
		do
			WrString(C_DOMHIER, dp->d_entry->e_name);
		while
			( (dp = dp->d_next) != (Domain *)0 );
	}

	if ( export == t_local )
	{
		register Entry **	epp;
		register int		i;

		/*
		**	Write aliases
		*/

		if ( AliasList == (Entry **)0 )
			MakeList(AliasCount, &AliasList, AliasHash);

		for ( epp = AliasList, i = AliasCount ; --i >= 0 ; epp++ )
		{
			WrString(C_ALIAS, (*epp)->e_name);
			WrString(C_ALIASV, (*epp)->e_value);
		}
	}

	/*
	**	Write exported alias names
	*/

	if ( XAliases != (Entry *)0 )
		WrAlias(XAliases);	/* Must be written in reverse order */

	/*
	**	Write nodes and links
	*/

	if ( export != t_export )
	{
		if ( NodeList == (Entry **)0 )
			MakeList(NodeCount, &NodeList, NodeHash);

		ClearState(S_PRINT, NodeHash);
	}
	else
	{
		MakeList(DomainCount, &DomainList, DomainHash);

		ClearState(S_PRINT, DomainHash);
	}

	WrNode(Home, true);

	if ( export != t_export )
	{
		register Entry **	epp;
		register int		i;

		for ( epp = NodeList, i = NodeCount ; --i > 0 ; epp++ )
			WrNode(*epp, true);
	}
	else
	{
		register Link *		lp;
		register Entry **	epp;
		register int		i;


		for ( lp = Home->e_node->n_l_first ; lp != (Link *)0 ; lp = lp->l_next )
			WrNode(lp->l_entry, false);

#		ifdef	EXPORT_TOPDOMS
		/*
		**	Tell of all top domains we know routes to.
		*/

		for ( epp = DomainList, i = DomainCount ; --i >= 0 ; epp++ )
			if ( ((*epp)->e_states & (S_TOPDOM|S_PRINT)) == S_TOPDOM )
				WrString(C_OTHDOM, (*epp)->e_name);
#		endif	/* EXPORT_TOPDOMS */
	}

	/*
	**	Write CRC
	*/

	Buf[0] = '\n';
	StCRC = acrc(StCRC, Buf, 1);
	Buf[1] = C_EOF;
	Buf[2] = LOCRC(StCRC);
	Buf[3] = HICRC(StCRC);
	Buf[4] = '\n';

#	define	BufLen	5

	(void)fwrite(Buf, BufLen, 1, WrStateFd);

#	undef	BufLen

	if ( export != t_local )
	{
		WrString('#', Version);
		(void)fwrite("\n", 1, 1, WrStateFd);
	}

	(void)fflush(WrStateFd);

	if ( ferror(WrStateFd) )
		Error("Bad statefile write");
}



static void
WrAlias(ep)
	register Entry *	ep;
{
	if ( ep->e_next != (Entry *)0 )
		WrAlias(ep->e_next);

	if ( ep->e_states & S_FOUND )
		WrString(C_XALIAS, ep->e_name);
}



static void
WrNode(ep, links)
	Entry *			ep;
	bool			links;
{
	register Node *		np;
	register Link *		lp;

	WrString(C_NODE, ep->e_name);

	np = ep->e_node;

	if ( WrExport == t_local && np->n_hierarchy != NULLSTR )
		WrString(C_NODEHIER, np->n_hierarchy);

	{
		register Domain *	dp;

		if ( (dp = np->n_domains.d_head) != (Domain *)0 )
		do
		{
			register int	c;

			if ( WrExport == t_local )
			{
				if ( (dp->d_entry->e_states & (S_TOPDOM|S_OTHDOM)) == (S_TOPDOM|S_OTHDOM) )
					c = C_OTHDOM;
				else
				if ( dp->d_entry->e_states & S_TOPDOM )
					c = C_TOPDOM;
				else
				if ( !(dp->d_entry->e_states & S_OTHDOM) )
					c = C_DOMAIN;
				else
					continue;

				WrString(c, dp->d_entry->e_name);

				if
				(
					ep == Home
					&&
					dp->d_entry->e_handler != NULLSTR
				)
					WrCString(C_HANDLER, dp->d_entry->e_handler);
			}
			else
			if ( (dp->d_entry->e_states & (S_TOPDOM|S_OTHDOM)) != S_OTHDOM )
			{
				if ( dp->d_entry->e_states & S_OTHDOM )
#					ifdef	EXPORT_TOPDOMS
					c = C_TOPDOM;
#					else	/* EXPORT_TOPDOMS */
					continue;
#					endif	/* EXPORT_TOPDOMS */
				else
					c = C_DOMAIN;

				WrString(c, dp->d_entry->e_name);

				dp->d_entry->e_states |= S_PRINT;
			}
		}
		while
			( (dp = dp->d_next) != (Domain *)0 );
	}

	WrFlags(C_NFLAGS, ep->e_states);

	if
	(
		(
			ep == Home
			||
			WrExport != t_export
		)
		&&
		np->n_comment != NULLSTR
	)
		WrCString(C_COMMENT, np->n_comment);

	if ( WrExport == t_local )
	{
		if ( np->n_state )
			WrNumber(C_STATE, np->n_state);

#		if	NODE_STATS == 1
		if ( np->n_date )
			WrNumber(C_DATE, np->n_date);
		if ( np->n_recvd )
			WrNumber(C_RECVD, np->n_recvd);
		if ( np->n_sent )
			WrNumber(C_SENT, np->n_sent);
		if ( np->n_passto )
			WrNumber(C_PASSTO, np->n_passto);
		if ( np->n_passfrom )
			WrNumber(C_PASSFROM, np->n_passfrom);
#		endif	NODE_STATS

		if ( np->n_handlers != (Hndl *)0 )
		{
			if ( np->n_handlers->h_spooler != NULLSTR )
				WrCString(C_SPOOLER, np->n_handlers->h_spooler);
			if ( np->n_handlers->h_connector != NULLSTR )
				WrCString(C_CONNECTOR, np->n_handlers->h_connector);
			if ( np->n_handlers->h_caller != NULLSTR )
				WrCString(C_CALLER, np->n_handlers->h_caller);
			if ( np->n_handlers->h_filter != NULLSTR )
				WrCString(C_FILTER, np->n_handlers->h_filter);
		}
	}

	if ( !links )
		return;

	for ( lp = np->n_l_first ; lp != (Link *)0 ; lp = lp->l_next )
	{
		register Data *	dp;
		register char *	cp;

		WrString(C_LINK, lp->l_entry->e_name);

		if
		(
			WrExport != t_local
			&&
			(cp = lp->l_entry->e_node->n_hierarchy) != NULLSTR
		)
			WrString(C_NODEHIER, cp);

		dp = lp->l_data;

		if ( WrExport != t_export && (dp->d_states & S_PRINT) )
			continue;	/* Don't duplicate data */

		if
		(
			WrExport != t_local
			&&
			(
			    (
				ep == Home
				&&
				lp->l_entry->e_node->n_handlers != (Hndl *)0
				&&
				lp->l_entry->e_node->n_handlers->h_filter != NULLSTR
			    )
			    ||
			    (
				lp->l_entry == Home
				&&
				np->n_handlers != (Hndl *)0
				&&
				np->n_handlers->h_filter != NULLSTR
			    )
			)
		)
			dp->d_states |= S_FILTERED;

		if ( dp->d_states )
			WrFlags(C_LFLAGS, dp->d_states);

		dp->d_states |= S_PRINT;

		if ( ep == Home || WrExport == t_local )
		{
			if ( dp->d_speed )
				WrNumber(C_SPEED, dp->d_speed);
			if ( dp->d_cost )
				WrNumber(C_COST, (ulong)dp->d_cost);
		}

#		if	LINK_STATS == 1
		if ( WrExport == t_local )
		{
			if ( dp->d_time )
				WrNumber(C_TIME, dp->d_time);
			if ( dp->d_bytes )
				WrNumber(C_BYTES, dp->d_bytes);
		}
#		endif	LINK_STATS
	}
}



static void
WrFlags(id, states)
	char		id;
	register States	states;
{
	register int	c;
#	if	defined(mc68000) || defined(vax)
	register int	s;	/* Don't ask -- you wouldn't like to know */
#	else
	register States	s;
#	endif
	register char *	cp;

	if ( (states &= ((WrExport!=t_local)?FOREIGN_FLAGS:EXTERNAL_FLAGS)) == 0 )
		return;

	cp = Buf;
	*cp++ = id;

	for ( s = 1, c = 'A' ; states ; s <<= 1, c++ )
		if ( s & states )
		{
			*cp++ = c;
			states &= ~s;
		}

	StCRC = acrc(StCRC, Buf, cp-Buf);

	(void)fwrite(Buf, cp-Buf, 1, WrStateFd);
}



static void
WrString(c, string)
	char		c;
	register char *	string;
{
	register char *	cp;

	cp = Buf;
	*cp++ = c;
	while ( *cp++ = *string++ );
	cp--;

	StCRC = acrc(StCRC, Buf, cp-Buf);

	(void)fwrite(Buf, cp-Buf, 1, WrStateFd);
}



static void
WrCString(c, string)
	char		c;
	register char *	string;
{
	register char *	cp;

	cp = Buf;
	*cp++ = c;
	while ( *cp++ = *string++ );
	cp[-1] = c;

	StCRC = acrc(StCRC, Buf, cp-Buf);

	(void)fwrite(Buf, cp-Buf, 1, WrStateFd);
}



static void
WrNumber(c, number)
	char		c;
	ulong		number;
{
	register int	n;

	n = (int)sprintf(Buf, "%c%lu", c, number);
#	if	SPRF_SIZE != 1
	n = strlen(Buf);
#	endif

	StCRC = acrc(StCRC, Buf, n);

	(void)fwrite(Buf, n, 1, WrStateFd);
}
