/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Check.c	1.9 86/02/10
*/

/*
**	Check consistency of graph.
*/

#include	"global.h"
#include	"debug.h"
#include	"address.h"
#include	"state.h"

#include	"node.h"


static int *	Countp;
static Time_t	RemoveOlder;
static bool	Retry;
static bool	Zero;

static void	CTalias();
static void	CTconnectivity();
static void	CTstate();



/*
**	Check domains, remove unfound/out-of-date/foreign-local nodes,
**	check link counts, and remove invalid aliases.
**
**	Returns 'true' if any node removed.
*/

bool
CheckState(zero, removeolder)
	bool			zero;
	Time_t			removeolder;
{
	register Entry **	epp;

	CheckHierarchy(Home, &DomHier);

	RemoveOlder = removeolder;
	Retry = false;
	Zero = zero;

	for ( epp = NodeHash ; epp < &NodeHash[HASH_SIZE] ; epp++ )
		if ( *epp != (Entry *)0 )
			CTstate(*epp);

	for ( epp = AliasHash ; epp < &AliasHash[HASH_SIZE] ; epp++ )
		if ( *epp != (Entry *)0 )
			CTalias(*epp);

	return Retry;
}


static void
CTalias(ap)
	register Entry *ap;
{
	register Entry *ep;
	register char *	cp;

	if ( ap->e_great != (Entry *)0 )
		CTalias(ap->e_great);

	if ( ap->e_less != (Entry *)0 )
		CTalias(ap->e_less);

	if ( !(ap->e_states & S_FOUND) )
		return;

	if ( (cp = strrchr(ap->e_value, DOMAIN_SEP)) != NULLSTR )
	{
		if ( (ep = Lookup(cp+1, DomainHash)) != (Entry *)0 && (ep->e_states & S_FOUND) )
			return;
	}
	else
		if ( (ep = Lookup(ap->e_value, NodeHash)) != (Entry *)0 && (ep->e_states & S_FOUND) )
			return;

	Report3("Removing alias \"%s\" for invalid address \"%s\"", ap->e_name, ap->e_value);

	free(ap->e_value);
	ap->e_value = NULLSTR;
	ap->e_states &= ~S_FOUND;
	AliasCount--;
}


static void
CTstate(ep)
	Entry *		ep;
{
	register Link**	lpp;
	register Link *	lp;
	register Node *	np;
	register States	states;
	register Domain*dp;
	DODEBUG(register int n);

	if ( ep->e_great != (Entry *)0 )
		CTstate(ep->e_great);

	if ( ep->e_less != (Entry *)0 )
		CTstate(ep->e_less);
	
	np = ep->e_node;

	DODEBUG(if(np==(Node*)0)Fatal("No node for \"%s\"",ep->e_name));

	states = ep->e_states;

	if
	(
		ep != Home
		&&
		(
			!(states & S_FOUND)	/* Non-existent */
			||
			np->n_state < RemoveOlder /* Out-of-date */
			||
			(			/* Foreign "local" node */
				(states & S_LOCAL)
				&&
				(
					(dp = np->n_domains.d_head) == (Domain *)0
					? IsLinked(Home, ep) == (Link **)0
					: !(dp->d_entry->e_states & S_OURDOM)
				)
			)
		)
	)
	{
		/*
		**	Remove it
		*/

		if ( states & S_FOUND )
		{
			ep->e_states &= ~S_FOUND;
			NodeCount--;
		}

		if ( np->n_fromlinks )
		{
			Report3
			(
				"%s node \"%s\" removed",
				(states&S_LOCAL) ? "Foreign \"local\"" :
				  (np->n_state<RemoveOlder) ? "Out-of-date" :
				    "Dubious",
				ep->e_name
			);

			Retry = true;

			while ( np->n_l_first != (Link *)0 )
				Unlink(ep, &np->n_l_first);

			ClearDomains(ep, true);
		}

		return;
	}

#	if	NODE_STATS == 1
	if ( Zero )
	{
		np->n_date = 0;
		np->n_recvd = 0;
		np->n_sent = 0;
		np->n_passto = 0;
		np->n_passfrom = 0;
	}
#	endif	NODE_STATS == 1

	DODEBUG(n = 0);

	for ( lpp = &np->n_l_first ; (lp = *lpp) != (Link *)0 ; )
	{
		if
		(
			!(lp->l_data->d_states & S_FOUND)
			||
			!(lp->l_entry->e_states & S_FOUND)
		)
		{
			Unlink(ep, lpp);
		}
		else
		{
#			if	LINK_STATS == 1
			if ( Zero )
			{
				lp->l_data->d_time = 0;
				lp->l_data->d_bytes = 0;
			}
#			endif	LINK_STATS == 1

			lpp = &lp->l_next;
			DODEBUG(n++);
		}
	}

	DODEBUG
	(
		if ( n != np->n_fromlinks )
			Fatal4
			(
				"fromlinks (%d) != actual (%d) for \"%s\"",
				np->n_fromlinks,
				n,
				ep->e_name
			)
	);

	if ( np->n_fromlinks > np->n_tolinks )
	{
		Trace4(1, "\"%s\" fromlinks %d > tolinks %d", ep->e_name, np->n_fromlinks, np->n_tolinks);

		for ( lpp = &np->n_l_first ; *lpp != (Link *)0 ; )
		{
			for ( lp = (*lpp)->l_entry->e_node->n_l_first ; lp != (Link *)0 ; lp = lp->l_next )
				if ( lp->l_entry == ep )
					break;

			if ( lp == (Link *)0 )
			{
				Report3
				(
					"Dubious link from \"%s\" to \"%s\" removed",
					ep->e_name,
					(*lpp)->l_entry->e_name
				);

				Unlink(ep, lpp);
			}
			else
				lpp = &(*lpp)->l_next;
		}
	}
}



/*
**	Check whole graph is connected.
**	Check all domains connected.
**
**	Returns 'true' if any node not connected.
*/

bool
CheckConnectivity()
{
	register Entry **	epp;
	register Entry **	end;

	ClearRoute(NodeHash);
	ClearRoute(DomainHash);

	Paths(Home, (Rflags)S_MSG|(Rflags)S_CON|(Rflags)S_DOMAINS);

	Countp = &DomainCount;

	for ( epp = DomainHash, end = &epp[HASH_SIZE] ; epp < end ; epp++ )
		if ( *epp != (Entry *)0 )
			CTconnectivity(*epp);

	Retry = false;

	Countp = &NodeCount;

	for ( epp = NodeHash, end = &epp[HASH_SIZE] ; epp < end ; epp++ )
		if ( *epp != (Entry *)0 )
			CTconnectivity(*epp);

	return Retry;
}


static void
CTconnectivity(ep)
	register Entry *	ep;
{
	if ( ep->e_great != (Entry *)0 )
		CTconnectivity(ep->e_great);

	if ( ep->e_less != (Entry *)0 )
		CTconnectivity(ep->e_less);

	if ( !(ep->e_states & S_FOUND) )
		return;

	if ( ep->e_route == (Entry *)0 )
	{
		Report3("%s \"%s\" not connected", Countp==&NodeCount?"node":"domain", ep->e_name);

		ep->e_states &= ~S_FOUND;
		(*Countp)--;

		Retry = true;
	}

	if ( Countp == &NodeCount )
		ClearDomains(ep, false);	/* Remove unfound domains from list */
}
