/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)driver.h	1.13 89/01/31
*/

/*
**	Protocol parameters
*/

#define	MINPKTSIZE		16		/* Minimum packet size */
#define	MAXCNTLDATAZ		128		/* Max data in a control message */
#define	IDLE_TIMEOUT		61		/* Default idle timeout (also maximum value for RECEIVE_TIMEOUT) */
#define	RECEIVE_TIMEOUT		5		/* Default (minimum) receive timeout */
#define	IDLE_SCANRATE		5		/* Maximum idle scanrate */
#define	ACTIVE_SCANRATE		2		/* Minimum active scanrate */
#define	UPDATE_TIME		20		/* Perform house-keeping this often */
#define	BATCH_TIMEOUT		(1*IDLE_SCANRATE) /* Terminate if nothing happens */
#define	NULLCH			0200		/* Old stdio can't handle nulls */

Extern bool	Alarm;				/* TRUE if alarm call pending */
Extern bool	Finish;				/* True if batchmode terminating */
Extern Time_t	LastTime;			/* Latest time in seconds */
Extern int	ScanRate;			/* ScanRate for alarm() calls */
Extern int	Receiving;			/* Count of active receive streams */
Extern int	Transmitting;			/* Count of active send streams */
Extern unsigned	UpdateTime;			/* Trigger for background Update */
Extern bool	Waiting;			/* Waithandler running */

/*
**	Control alarm calls.
*/

#define	ALARM_ON(A)		{(void)alarm((unsigned)A);Alarm=true;}
#define	ALARM_OFF()		if(Alarm){(void)alarm(0);Alarm=false;}

#define	IOALRMON(A)	ALARM_ON(A)
#define	IOALRMOFF()	ALARM_OFF()

/*
**	Driver functions called from protocol handler
*/

extern int
		fillPkt();

extern void
		recvData(),
		recvControl(),
		rTimeout(),
		rReset(),
		xReset(),
		qCpkt(),
		qPkt(),
		RCread(),
		Rread();

/*
**	Daemon functions called via the "action" queue.
*/

extern void
		BadMessage(),
		EndMessage(),
		FixStreams(),
		MakeTemp(),
		NewMessage(),
		PosnStream(),
		TruncateTemp(),
		Update(),
		WaitHandler(),
		qAction();

/*
**	Other driver functions
*/

extern void
		NewState(),
		SendEOM(),
		SendMQE(),
		SendSOM(),
		SetSpeed(),
		SndEOMA(),
		SndSOMA(),
		qControl();

extern bool
		FindCommand(),
		RdCommand(),
		RunState();
