/*
**	patterns and functions to call a host via CSIRONET
**
**	SCCSID %W% %E%
*/

#include	"global.h"
#include	"debug.h"

#include	"caller.h"

#define	MAXDEV	8			/* Maximum specifiable alternate devices */


bool
	Cooked,				/* Force Cooked mode for old NNshells */
	UnixNet;			/* Unix network between CSIRONET and host */

char
	*CallArgs= CALLARGS,		/* Optional args for call */
	*CookMsg = " -C",		/* Cooked message from NNshell */
	*CsiroReq,			/* Request to set-up virtual circuit */
	*Daemon1 = NNDAEMON,		/* Standard daemon */
	*Daemon2 = NN2DAEMON,		/* Alternate protocol */
	*Daemon3 = PNDAEMON,		/* Alternate protocol */
	*Device,			/* Device for link */
	*Host,				/* Who am i */
	*HostFlg = "-BF",		/* Batch mode, no fork */
	*Passwd,			/* Password at Target */
	*Retries = "3",			/* Number of retries */
	*Retry   = "30",		/* Retry sleep time */
	*Speed,				/* Speed of link */
	*Target,			/* Target host */
	*TimeOut = "15",		/* Timeout for open */
	*UnixReq;			/* Request for Unix network connection to host */

int
	Ccount	 = 0,			/* Count of CSIRONET login attempts */
	CkMsgLen,
	Devices  = 0,			/* Count of device names if separate "-d" args */
	Lcount	 = 0,			/* Count of Unix login attempts */
	Tcount	 = 0,			/* Count of Timeouts */
	Wait	 = 4;			/* Minutes to wait after failure */

int
	AtCSIRONET(),
	AtUNIX(),
	CSIRONETfail(),
	GotEof(),
	GotLogin(),
	GotPasswd(),
	GotTimeout(),
	NetLogin(),
	Start1(),
	Start2(),
	Start3(),
	ToCSIRONET(),
	ToHost(),
	ToUNIX(),
	UNIXfail();

/*
**	CSIRONET messages
*/

char	Atnode[]	= "CSIRONET-UNIX";
char	Disconn[]	= "DISCONNECT SEEN FROM";
char	Invalid[]	= "INVALID LOGIN REQUEST";
char	Noresp[]	= "NO RESPONSE FROM UNIX";
char	Unassi[]	= "TERMINAL IS UNASSIGNED";
char	Unixserv[]	= "UNIX SERVICE";
char	Unrec[]		= "UNRECOGNISED FIRST RECORD";
char	Notcomm[]	= "NOT COMMUNICATING";
char	Nofree[]	= "NO FREE PORTS";
char	Noport[]	= "NO PORT AVAILABLE";

/*
**	Other common patterns
*/

char	DActive[]	= NOGOMSG;
char	DError[]	= "daemon: error";
char	Eof[]		= EOFSTR;
char	Login[]		= "[Ll]ogin";
char	LoginI[]	= "[Ll]ogin +[Ii]ncorrect";
char	LLogin[]	= "[Ll]ast +[Ll]ogin";
char	Password[]	= "[Pp]assword";
char	WPassword[]	= "[Ww]rong +[Pp]assword";
char	NoShell[]	= "no shell";
char	Timeout[]	= TIMEOUT;

/*
**	The pattern/action sets
*/

PatList	CSIROnet[] =
{
	{ Atnode, (Funcp)reset },
	{ Unrec, (Funcp)reset },
	{ Unassi, AtCSIRONET },
	{ Invalid, ToCSIRONET },
	{ Disconn, ToCSIRONET },
	{ Unixserv, ToUNIX },
	{ Timeout, GotTimeout },
	{ Notcomm, CSIRONETfail },
	{ Nofree, CSIRONETfail },
	{ Noport, CSIRONETfail },
	{ Eof, GotEof },
	{ 0, 0}
};

PatList UNIXnet[] =
{
	{ "", ToHost },
	{ LoginI, AtUNIX },
	{ WPassword, AtUNIX },
	{ LLogin, (Funcp)reset },
	{ Login, NetLogin },
	{ Password, UNIXfail },
	{ Noresp, UNIXfail },
	{ NoShell, UNIXfail },
	{ Unrec, ToCSIRONET },
	{ Unassi, ToCSIRONET },
	{ Invalid, ToCSIRONET },
	{ Disconn, ToCSIRONET },
	{ Timeout, GotTimeout },
	{ Notcomm, CSIRONETfail },
	{ Eof, GotEof },
	{ 0, 0 }
};

#define	UnixCon	UNIXnet[0].pattern

PatList UNIXhost[] =
{
	{ LoginI, AtUNIX },
	{ WPassword, AtUNIX },
	{ LLogin, (Funcp)reset },
	{ Login, GotLogin },
	{ Password, GotPasswd },
	{ DActive, UNIXfail },
	{ STARTMSG, Start1 },
	{ START2MSG, Start2 },
	{ PNSTARTS, Start3 },
	{ Noresp, UNIXfail },
	{ NoShell, UNIXfail },
	{ DError, UNIXfail },
	{ Unrec, ToCSIRONET },
	{ Unassi, ToCSIRONET },
	{ Invalid, ToCSIRONET },
	{ Disconn, ToCSIRONET },
	{ Timeout, GotTimeout },
	{ Notcomm, CSIRONETfail },
	{ Eof, GotEof },
	{ 0, 0 }
};



/*
**	Function to process arguments, either from NNcall, or from CALLARGS.
*/

void
Args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		register int	c;

		if ( (c = Traceflag) >= 2 )
		{
			Traceflag = 0;
			Command("trace Args: \"", argv[1], "\"", NULLSTR);
			Traceflag = c;
		}

		if ( **++argv == '-' )
		{
			while ( c = *++*argv )
			{
				switch ( c )
				{
				case '1':
					Daemon1 = ++*argv;
					goto break2;

				case '2':
					Daemon2 = ++*argv;
					goto break2;

				case '3':
					Daemon3 = ++*argv;
					goto break2;

				case 'C':
					Cooked = true;
					continue;

				case 'R':
					Retries = ++*argv;
					goto break2;

				case 'T':
					if ( (Traceflag = atoi(++*argv)) == 0 )
						Traceflag = 1;
					goto break2;

				case 'U':
					UnixNet = true;
					continue;

				case 'd':
					if ( Devices >= MAXDEV )
					{
						Command
						(
							"fail too many devices in ",
							CallArgs,
							NULLSTR
						);
						Exit(1);
					}
					if ( Devices++ == 0 )
						Device = ++*argv;
					else
						Device = concat(Device, " ", ++*argv, NULLSTR);
					goto break2;

				case 'l':
					Host = ++*argv;
					goto break2;

				case 'p':
					Passwd = ++*argv;
					goto break2;

				case 'r':
					Retry = ++*argv;
					goto break2;

				case 's':
					Speed = ++*argv;
					goto break2;

				case 't':
					TimeOut = ++*argv;
					goto break2;

				case 'v':
					CsiroReq = ++*argv;
					goto break2;

				case 'w':
					Wait = atoi(++*argv);
					break;

				case 'x':
					UnixCon = ++*argv;
					goto break2;
					
				case 'y':
					UnixReq = ++*argv;
					goto break2;
					
				default:
					Command
					(
						"fail unexpected flag \"-",
						*argv,
						"\" in ",
						CallArgs,
						NULLSTR
					);
					Exit(1);
				}
			}
break2:			;
		}
		else
			Target = *argv;
	}
}



void
init(argc, argv)
	int		argc;
	char *		argv[];
{
	Host = NodeName();

	CkMsgLen = strlen(CookMsg);

	Args(argc, argv);

	CallArgs = concat(SPOOLDIR(), Target, "/", CallArgs, NULLSTR);
	(void)readargs(CallArgs, Args);

	DODEBUG
	(
		if
		(
			Target == NULLSTR
			||
			Passwd == NULLSTR
			||
			CsiroReq == NULLSTR
			||
			Device == NULLSTR
		)
		{
			outend("fail incomplete initialisation");
			Exit(1);
		}
	);

	Command("retry ", Retry, " ", Retries, NULLSTR);
	Command("timeout ", TimeOut, NULLSTR);
	Command("open ", Device, NULLSTR);

	if ( Speed != NULLSTR )
		Command("speed ", Speed, NULLSTR);

	outend("read");

	ToCSIRONET();
}



ToCSIRONET()
{
	if ( ++Ccount >= 10 )
	{
		Command("fail CSIRONET setup failed: ", input, NULLSTR);
		Exit(1);
	}

	Tcount = 0;
	outend("write T\004");
	state(CSIROnet);
	reset();
}



AtCSIRONET()
{
	if ( ++Ccount >= 11 )
	{
		Command("fail CSIRONET setup failed: ", input, NULLSTR);
		Exit(1);
	}

	Command("write ", CsiroReq, "\r", NULLSTR);
	reset();
}



ToUNIX()
{
	Tcount = 0;
	Lcount = 0;

	outend("write EI\004");	/* Disable remote echo */

	state(UnixNet?UNIXnet:UNIXhost);
	reset();
}



ToHost()
{
	Tcount = 0;
	Lcount = 0;

	state(UNIXhost);
	reset();
}



AtUNIX()
{
	if ( ++Lcount >= 7 )
		Command("fail too many login attempts at ", Target, NULLSTR);

	flushinput();
	outend("sleep 5");
	flushinput();
	outend("sleep 5");
	flushinput();
	outend("write \r");
	reset();
}



GotLogin()
{
	if ( ++Lcount >= 7 )
		Command("fail too many login attempts at ", Target, NULLSTR);

	Command("write ", Host, "\r", NULLSTR);
	reset();
}



NetLogin()
{
	if ( ++Lcount >= 7 )
		Command("fail too many login attempts at ", UnixCon, NULLSTR);

	Command("write ", UnixReq, "\r", NULLSTR);
	reset();
}



GotPasswd()
{
	Command("write ", Passwd, "\r", NULLSTR);
	reset();
}



Start(start, end, daemon)
	char *	start;
	char *	end;
	char *	daemon;
{
	int	c;

	if ( (c = Traceflag) >= 1 )
	{
		Traceflag = 0;
		Command("trace Start(\"", start, "\", \"", end, "\", \"", daemon, "\")", NULLSTR);
		Traceflag = c;
	}

	Command("daemon ", daemon, NULLSTR);
	if ( Cooked || strncmp(end, CookMsg, CkMsgLen) == STREQUAL )
		outend("mode -C");
	Command("succeed ", HostFlg, " ", Target, NULLSTR);
	Exit(0);
}



Start1(start, end)
	char *	start;
	char *	end;
{
	Start(start, end, Daemon1);
}



Start2(start, end)
	char *	start;
	char *	end;
{
	Start(start, end, Daemon2);
}



Start3(start, end)
	char *	start;
	char *	end;
{
	Start(start, end, Daemon3);
}



GotTimeout()
{
	if ( ++Tcount >= 3 )
	{
		outend("fail TIMEOUT");
		Exit(1);
	}

	if ( current == CSIROnet )
		outend("write T\004");
	else
		outend("write @\r");

	reset();
}



GotEof()
{
	outend("fail unexpected EOF");
	Exit(1);
}



UNIXfail()
{
	Command("fail UNIX problem: ", input, NULLSTR);
	Exit(1);
}



CSIRONETfail()
{
	Command("fail CSIRONET problem: ", input, NULLSTR);
	Exit(1);
}



Exit(n)
{
	sleep(2);
	exit(n);
}
