/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)sleep.c	1.4 85/05/14
*/

/*
**	Own version of sleep(3).
*/

#include	"global.h"

#include	<signal.h>
#include	<setjmp.h>


jmp_buf		Sleep_jmp;



unsigned
sleep(seconds)
	unsigned int		seconds;
{
	int			(*old_sig)();
	static unsigned int	prev;
	extern int		sleep_catch();

	if ( seconds == 0 )
		return 0;

	old_sig = signal(SIGALRM, sleep_catch);

	prev = 0;

	if ( !setjmp(Sleep_jmp) )
	{
		prev = alarm(seconds);

		pause();

		(void)alarm(0);	/* Interrupted... */
	}

	if ( prev )
		Warn("sleep called with alarm already set to %d", prev);

	(void)signal(SIGALRM, old_sig);

	return 0;
}



int
sleep_catch(sig)
	int	sig;
{
	longjmp(Sleep_jmp, 1);
}
