/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SplitArg.c	1.6 89/02/25
*/

/*
**	Split argument into separate "VarArg" entries on white space.
**	White space (and quotes) may be quoted (single or double) or escaped.
**
**	(Based on a version from Michael Rourke.)
*/

#include	"global.h"



int
SplitArg(to, arg)
	VarArgs *	to;
	register char *	arg;
{
	register int	c;
	register int	quote;
	register char *	cp;
	char *		temp = Malloc(strlen(arg)+2);
	int		count = 0;
	bool		hadquote;

	for ( c = *arg++ ; c != '\0' ; )
	{
		cp = temp;
		quote = '\0';
		hadquote = false;

		while ( c == ' ' || c == '\t' || c == '\n' )
			c = *arg++;

		if ( c == '#' )
		{
			while ( (c = *arg++) && c != '\n' );
			continue;
		}

		for ( ; c != '\0' ; c = *arg++ )
		{
			if ( c == quote )
			{
				quote = '\0';
				continue;
			}

			switch ( c )
			{
			case ' ': case '\t': case '\n':
					if ( quote != '\0' )
						break;
					goto break2;

			case '\'': case '"':
					if ( quote != '\0' )
						break;
					hadquote = true;
					quote = c;
					continue;

			case '\\':	switch ( c = *arg++ )
					{
					case '\0':	arg--;
					default:	*cp++ = '\\';
					case '#':
					case '\\':	*cp++ = c;
							continue;

					case 'r':	*cp++ = '\r';
							continue;
					case 'n':	*cp++ = '\n';
							continue;
					case 't':	*cp++ = '\t';
							continue;
					case 's':	*cp++ = ' ';
							continue;
					case 'b':	*cp++ = '\b';
							continue;

					case '\'': case '"':
							if ( quote != '\0' && c != quote )
								*cp++ = '\\';
					case ' ': case '\t': case '\n':
							break;
					}
			}

			*cp++ = c;
		}

break2:
		if ( cp != temp || hadquote )
		{
			*cp++ = '\0';

			if ( NARGS(to) < MAXVARARGS )
				NEXTARG(to) = newstr(temp);

			count++;
		}
	}

	free(temp);
	return count;
}
