/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SetUser.c	1.4 86/02/10
*/

/*
**	Routine to cause invoker to become a different user.
*/

#define	PASSWD_USED

#include	"global.h"

#include	"Passwd.h"



void
SetUser(uid, gid)
	int		uid;
	int		gid;
{
#	if	AUSAS == 1
	struct pwent	pe;

	if ( geteuid() != 0 )
		return;

	pe.pw_uid = uid;

	errno = 0;	/* Clear old error */

	while ( getpwlog(&pe, NULLSTR, 0) == PWERROR )
	{
		if ( errno != 0 )
		{
			Syserror("Can't access passwd file");
			errno = 0;
		}
		else
		{
			pwclose();
			Error("no such user");
			return;
		}
	}

	pwclose();

#	if	LIMITS == 1
#	if	V8 == 1
	if ( setlimits(&pe.pw_limits) == SYSERROR )
#	else
	if ( limits(&pe.pw_limits, L_SETLIM) == SYSERROR )
#	endif
		SysWarn("limits");
#	endif	LIMITS == 1

#	endif	AUSAS == 1

	(void)setgid(gid);
	(void)setuid(uid);
}
