/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)GetHandler.c	1.6 86/02/27
*/

/*
**	Read in and sort handlers description file if necessary,
**	then attempt to match name against one of the known handlers;
**	return a Handler structure pointer if successful, else null.
*/

#include	"global.h"
#include	"debug.h"
#include	"handlers.h"


Handler *	Handlers;
static char *	HandlFile	= HANDLERS;
static char *	HandlData;
static bool	GotHandlers;
static int	HandlCount;

extern int	RdFileSize;

extern int	GHcomp();


Handler *
GetHandler(name)
	char *	name;
{
	static char *	space	= " \t";
	Handler		key;

	if ( !GotHandlers )
	{
		register char *		cp;
		register char *		np;
		register Handler *	hp;

		GotHandlers = true;

		if ( (HandlData = cp = ReadFile(HandlFile)) == NULLSTR )
		{
			Report2("Can't read %s", HandlFile);
			return (Handler *)0;
		}

		cp[RdFileSize++] = '\n';	/* Ensure terminating '\n' */
		cp[RdFileSize] = '\0';

		while ( (cp = strchr(cp, '\n')) != NULLSTR )
		{
			HandlCount++;
			cp++;
		}

		Handlers = hp = (Handler *)Malloc(HandlCount * sizeof(Handler));

		cp = HandlData;

		while ( (np = strchr(cp, '\n')) != NULLSTR )
		{
			*np++ = '\0';

			hp->handler = strtok(cp, space);
			hp->descrip = strtok(NULLSTR, space);
			if ( (cp = strtok(NULLSTR, space)) == NULLSTR )
			{
				hp->proto_type = '-';
				hp->ign_err = '0';
			}
			else
			{
				hp->proto_type = *cp;
				if ( (cp = strtok(NULLSTR, space)) == NULLSTR )
					hp->ign_err = '0';
				else
					hp->ign_err = *cp;
			}

			cp = np;
			hp++;
		}

		if ( HandlCount > 1 )
			qsort((char *)Handlers, HandlCount, sizeof(Handler), GHcomp);
	}
	
	if ( HandlCount > 0 )
	{
		key.handler = name;

		return (Handler *)bsearch((char *)&key, (char *)Handlers, HandlCount, sizeof(Handler), GHcomp);
	}

	return (Handler *)0;
}



int
GHcomp(hp1, hp2)
	char *	hp1;
	char *	hp2;
{
	return strcmp(((Handler *)hp1)->handler, ((Handler *)hp2)->handler);
}
