/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID 88/07/24 @(#)ExpandArgs.c	1.8
*/

/*
**	Expand arguments containing any '&x' sequences;
**	change arguments containing any '%xstring%' sequences.
*/

#include	"global.h"

/*
**	External identifiers that ought to be set up.
*/

extern bool	Broadcast;
extern char *	DataName;
extern char *	HomeNode;
extern char *	LinkNode;
extern char *	SenderName;
extern char *	SourceNode;
extern Time_t	StartTime;
extern char *	UserName;

static char *	selecta();
static int	selectp();



#if VARARGS
void
ExpandArgs(va_alist)
	va_dcl
{
	VarArgs	*	to;
	register char *	ap;
	register char *	dp;
	register char *	sp;
	register char *	cp;
	register int	size;
	char *		string;
	bool		hadsub;
	va_list		va;

	va_start(va);
	to = va_arg(va, VarArgs *);

	while ((ap = va_arg(va, char *)) != NULLSTR)

#else

/*VARARGS2*/
void
ExpandArgs(to, arg, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
	VarArgs	*	to;
	char *		arg;
	char *		a1;
	char *		a2;
	char *		a3;
	char *		a4;
	char *		a5;
	char *		a6;
	char *		a7;
	char *		a8;
	char *		a9;
	char *		a10;
{
	register char *	ap;
	register char *	dp;
	register char *	sp;
	register char *	cp;
	char **		app;
	register int	size;
	char *		string;
	bool		hadsub;

	for ( app = &arg ; (ap = ARGS_OFF_STACK(app)) != NULLSTR ; )
#endif

	{
		dp = ap;
		size = 1;
		hadsub = false;

		while ( (dp = strchr(dp, '&')) != NULLSTR )
			if ( (sp = selecta(*++dp)) != NULLSTR )
			{
				size += strlen(sp);
				dp++;
			}

		size += strlen(ap);

		string = sp = Malloc(size);

		while ( *ap != '\0' && (dp = strpbrk(ap, "&%")) != NULLSTR )
		{
			hadsub = true;

			if ( size = dp-ap )
				sp = strncpy(sp, ap, size) + size;

			if ( *dp++ == '&' )
			{
				if ( (cp = selecta(*dp)) != NULLSTR )
				{
					sp = strcpyend(sp, cp);
					dp++;
				}
				else
				{
					*sp++ = '&';
					*sp++ = *dp++;
				}
			}
			else
			{
				register int negate;

				if ( negate = (*dp == '!') )
					dp++;

				cp = &dp[1];

				if
				(
					(ap = strchr(cp, '%')) != NULLSTR
					&&
					(size = selectp(dp[0])) != 2
				)
				{
					if ( size != negate )
					{
						while
						(
							(dp = strchr(cp, '&')) != NULLSTR
							&&
							dp < ap
						)
						{
							if ( size = dp-cp )
								sp = strncpy(sp, cp, size) + size;
							if ( (cp = selecta(*++dp)) != NULLSTR )
							{
								sp = strcpyend(sp, cp);
								dp++;
							}
							else
							{
								*sp++ = '&';
								*sp++ = *dp++;
							}
							cp = dp;
						}
						if ( size = ap-cp )
							sp = strncpy(sp, cp, size) + size;
					}
					dp = ap + 1;
				}
				else
				{
					*sp++ = '%';
					if ( negate )
						*sp++ = '!';
				}
			}

			ap = dp;
		}

		(void)strcpy(sp, ap);

		if ( !hadsub || strlen(string) > 0 )
			NEXTARG(to) = string;
		else
			free(string);
	}
#if VARARGS
	va_end(va);
#endif
}



static char *
selecta(c)
	char	c;
{
	static char	str[TIME_SIZE];

	switch ( c )
	{
	case 'D':	return DataName;
	case 'F':	return SenderName;
	case 'H':	return HomeNode;
	case 'L':	return LinkNode;
	case 'O':	return SourceNode;
	case 'T':	(void)sprintf(str, "%lu", StartTime); return str;
	case 'U':	return UserName;
	case '&':	return "&";
	case '%':	return "%";
	}

	return NULLSTR;
}



static int
selectp(c)
	char	c;
{
	switch ( c )
	{
	case 'B':	return (int)Broadcast;
	case 'L':	return strncmp(LinkNode, SourceNode, strlen(LinkNode)) != STREQUAL;
	}

	return 2;
}
