/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)header.h	1.12 89/10/30
*/

/*
**	Message header format and memory image
*/

#define	HDR_TYP1	"1"		/* Type 1 header */

#define	HDR_LENGTH_SIZE	8		/* Fixed length field at end of message */
#define	MIN_HDR_LEN	13		/* Minimum length for a header + CRC */

#define	HC_ROUTE	','		/* Route separator in route field */
#define	HC_TIME		'='		/* Time separator in route field */

#define	ENV_RS		'\036'		/* Environment record separator */
#define	ENV_SEP		'='		/* Separate environment name from value */
#define	ENV_FS		','		/* Separate environment value fields */

#define	ENV_ACK		"ACK"
#define	ENV_DESTINATION	"DEST"
#define	ENV_DOWN	"DOWN"
#define	ENV_DUP		"DUP"		/* Message maybe duplicated at this node */
#define	ENV_ENQ		"ENQ"
#define	ENV_ENQALL	"ENQALL"
#define	ENV_ERR1	"ERR1"
#define	ENV_ERR2	"ERR2"
#define	ENV_HANDLER_FLAGS "FLAGS"
#define	ENV_NO_AUTOCALL	"NOCALL"	/* Ignore auto-call flag when spooling */
#define	ENV_NOOPT	"NOOPT"		/* Don't optimise message order */
#define	ENV_NORET	"NORET"		/* Don't return if error */
#define	ENV_NOTNODE	"NOTNODE"	/* Don't send to this node */
#define	ENV_RETURNED	"RET"
#define	ENV_REV_CHARGE	"R_C"		/* Reverse charging for this message */
#define	ENV_ROUTE	"ROUTE"
#define	ENV_STATE	"STATE"
#define	ENV_TRUNC	"TRUNC"		/* Message was truncated at this node */
#define	ENV_UP		"UP"

typedef enum
{
	ht_type,
	ht_dest, ht_source,
	ht_handler, ht_env,
	ht_ttd, ht_tt, ht_route,
	ht_subpt,
#	define	ht_n	hr_badread
	hr_badread, hr_badcrc, hr_badlen,
	hr_ok
}
			HdrReason;

#define	NHDRFIELDS	(int)ht_n

typedef struct
{
	char *	hf_start[NHDRFIELDS];
}
			Hdr_Fields;

Extern Hdr_Fields	HdrFields;

Extern char *		HdrDescs[]
#ifdef	HDR_DATA
=
{
	"type",
	"destination",
	"source",
	"handler",
	"environment",
	"time-to-die",
	"travel time",
	"route",
	"sub_protocol",
	"read",
	"CRC",
	"length"
}
#endif	HDR_DATA
;

#ifndef	unreasonable
#define	HdrDest		HdrFields.hf_start[(int)ht_dest]
#define	HdrSource	HdrFields.hf_start[(int)ht_source]
#define	HdrHandler	HdrFields.hf_start[(int)ht_handler]
#define	HdrEnv		HdrFields.hf_start[(int)ht_env]
#define	HdrTtd		HdrFields.hf_start[(int)ht_ttd]
#define	HdrTt		HdrFields.hf_start[(int)ht_tt]
#define	HdrRoute	HdrFields.hf_start[(int)ht_route]
#define	HdrSubpt	HdrFields.hf_start[(int)ht_subpt]
#else	unreasonable
#define	HdrDest		HdrFields.hf_start[1]
#define	HdrSource	HdrFields.hf_start[2]
#define	HdrHandler	HdrFields.hf_start[3]
#define	HdrEnv		HdrFields.hf_start[4]
#define	HdrTtd		HdrFields.hf_start[5]
#define	HdrTt		HdrFields.hf_start[6]
#define	HdrRoute	HdrFields.hf_start[7]
#define	HdrSubpt	HdrFields.hf_start[8]
#endif	unreasonable

#define	HeaderReason(A)	HdrDescs[(int)A]

#ifndef	HDR_DATA
Extern long		DataLength;
#endif	HDR_DATA
Extern int		HdrLength;
Extern char *		Header;
Extern char *		HeaderEnd;

extern bool		ExDests();
extern bool		ExRoute();
extern char *		GetEnv();
extern int		InRoute();
extern char *		LastNode();
extern ulong		LastTime();
extern char *		MakeEnv();
extern bool		ReRoutable();
extern void		ReRoute();
extern HdrReason	ReadHeader();
extern void		UpStats();
extern bool		UpdateHeader();
extern int		WriteHeader();
