/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID 88/09/08 @(#)global.h	1.39
*/

/*
**	Include local peculiarities here.
*/

#include	"site.h"

#if VARARGS
#include	<varargs.h>
#endif

/*
**	Site definitions consistency checks
*/

#if	!defined(FUZZ) && !defined(NCC_MANAGER) && !defined(NCC_MANA)
	*** You must define one or both of the above ***
#endif

#if	BSD4 > 0 && SYSTEM > 0
	*** You can't define both of the above ***
#endif

/*
**	Global definitions for network that should not be changed
*/

#define	CRC_SIZE	sizeof(Crc_t)		/* Number of bytes in CRC */
#define	LENGTH_SIZE	11			/* Maximum bytes in an ASCII length field */
#define	MAX_MESG_DATA	200000L			/* Maximum size of data part of a message */
#define	MAX_REROUTE_WAIT (30*60)		/* Maximum wait time for message in re-route directory */
#define	NODE_NAME_SIZE	15			/* Maximum length of a node's name */
#define	TIME_SIZE	10			/* Maximum number of digits in a time */
#define	UID_LENGTH	3			/* Number of digits in a uid */
#define	UNIQUE_NAME_LENGTH 11			/* Minimum length for last component of argument to UniqueName() */
						/* UID_LENGTH + UNIQUE_NAME_LENGTH must be <= DIRSIZ */

#define	CHST_TTD	(30*60)			/* Time-to-die for state up/down messages */

/*
**	Global definitions for C programming
*/

#define	Talloc(T)	(T*)Malloc(sizeof(T))
#define	SYSERROR	(-1)
#define	NULLSTR		(char*)0
#define	NULLFUNCP	(Funcp)0
#define	NULLVFUNCP	(vFuncp)0
#define	STREQUAL	0
#define	Extern		extern			/* Redefined to <null> to declare a global object */

#ifdef	GLBOLT
#define	ticks()		glbolt()
#endif	/* GLBOLT */

#if	KILL_0 == 1
#define	SIG0		0
#else
#define	SIG0		SIGINT
#endif

#if	OLD_CC == 1
#define	void		int
#define	ulong		long
#define	BYTE(A)		((A)&0xff)
#else
#if	SYSTEM != 5 || SYSVREL < 2
typedef unsigned long	ulong;
#endif
#define	BYTE(A)		(((unsigned char *)&(A))[0])
#endif

#define	LOCRC(A)	((A)&0xff)
#define	HICRC(A)	(((A)>>8)&0xff)

#ifdef	EBUG
#define	DEBUG		EBUG
#else
#define	DEBUG		0
#endif

/*
**	System include file control
*/

#if	SYSTEM == 5 && SYSVREL >= 2
#include	<sys/types.h>
#ifndef	major
#define	major
#endif
#endif

#ifdef	NEED_HZ
#if	BSD4 < 1 || (BSD4 == 1 && BSD4V != 'c')
#include	<sys/param.h>
#endif	/* BSD4 */
#ifndef	HZ
#define	HZ	60		/* A stab in the dark */
#endif
#endif	/* NEED_HZ */

#ifdef	FILE_CONTROL
#if	FCNTL == 1
#if	BSD4 < 2
#include	<fcntl.h>	/* O_XXX definitions live here */
#else	/* BSD4 < 2 */
#include	<sys/file.h>	/* O_XXX definitions live here */
#endif	/* BSD4 < 2 */
#else	/* FCNTL == 1 */
#if	BSD4 > 0
#ifndef	O_RDWR
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	/* major */
#endif
#include	<sys/file.h>	/* O_XXX definitions live here */
#endif	/* O_RDWR */
#if	BSD4 < 2
#undef	O_EXCL			/* Does the wrong thing */
#endif	/* BSD4 < 2 */
#else	/* BSD4 > 0 */
#if	V8 == 1
#include	<sys/ioctl.h>
#endif	/* V8 */
#define	O_READ		0
#define	O_WRITE		1
#define	O_RDWR		2
#define	O_APPEND	0
#endif	/* BSD4 > 0 */
#ifndef	O_EXCL
#define	O_EXCL		0
#endif	/* O_EXCL */
#endif	/* FCNTL == 1 */
#ifndef	O_READ
#define	O_READ	O_RDONLY
#endif
#ifndef	O_WRITE
#define	O_WRITE	O_WRONLY
#endif
#endif	/* FILE_CONTROL */

/*
 * AT&T Systems usually have default file size limits
 * which are totally inapropriate. Set it to the maximum
 * here.
 */
#if	SYSTEM > 0
#define	ULIMIT	((1L << 22) - 1)
#endif	/* SYSTEM > 0 */

#ifdef	SELECT
#if	V8 == 1 || BSD4 >= 2
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	/* major */
#endif
#ifndef	FD_SET			/* missing definitions for "select" in 4.2 */
/*
**	These assume fd < 32, that is true on 4.2bsd, the only kernel
**	that has "select" but didn't bother to provide these defn's...
**
**	If your types.h typedef's fd_set, but doesn't define FD_SET,
**	then remove the following typedef...  (most 4.2bsd derivarives).
*/
/*** typedef struct { long fds_bits[1]; } fd_set; ***/
#define	FD_SET(fd, set)		((set)->fds_bits[0] |= (1 << (fd)))
#define	FD_CLR(fd, set)		((set)->fds_bits[0] &= ~(1 << (fd)))
#define	FD_ISSET(fd, set)	((set)->fds_bits[0] & (1 << (fd)))
#define	FD_ZERO(set)		(strclr((set), sizeof(*(set))))
#endif	/* FD_SET */
#endif	/* V8 == 1 || BSD4 >= 2 */
#endif	/* SELECT */

#ifdef	STAT_CALL
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	/* major */
#endif
#include	<sys/stat.h>	/* Definition of stat structure */
#endif	/* STAT_CALL */

#ifdef	PASSWD_USED
#if	AUSAS == 1
#undef	SYSERROR
#undef	V8
#include	<local-system>
#ifndef	SYSERROR
#define	SYSERROR	(-1)
#endif
#include	<passwd.h>
#ifndef	USECON
#define	USECON		USELOG
#define	pw_xflags	pw_flags
#endif
#else	/* AUSAS == 1 */
#include	<pwd.h>
#if	MUSH == 1
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif
#endif	/* major */
#if	BSD4 > 1
#include	<sys/privs.h>
#endif	/* MSD4 > 1 */
#include	<udata.h>
#endif	/* MUSH == 1 */
#endif	/* AUSAS == 1 */
#endif	/* PASSWD_USED */

#ifdef	STDIO
#include	<stdio.h>
#endif	/* STDIO */

#ifdef	SMDATE
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	/* major */
#endif
#endif	/* SMDATE */

#ifdef	TIMES
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	/* major */
#endif
#include	<sys/times.h>
typedef struct tms	Timesbuf;
#endif	/* TIMES */

#ifdef	TERMIOCTL
#if	SYSTEM >= 3
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif
#endif
#include	<termio.h>
#else	/* SYSTEM >= 3 */
#include	<sgtty.h>
#endif	/* SYSTEM >= 3 */
#endif	/* TERMIOCTL */

#ifdef	TTYCONNECT
#if	TTY_CONNECT == 1
#if	V8 == 1
#include	<sys/sc.h>
#else	/* V8 == 1 */
#include	<sys/ttyconnect.h>
#endif	/* V8 == 1 */
#else	/* TTY_CONNECT == 1 */
#define	CONNECT	0
#undef	TTYCONNECT
#endif	/* TTY_CONNECT == 1 */
#endif	/* TTYCONNECT */

/*
**	Type definitions for C programming
*/

typedef ulong		Time_t;
typedef	unsigned short	Crc_t;
typedef int		(*Funcp)();
typedef void		(*vFuncp)();
typedef enum { false = 0, true = 1 } bool;
typedef enum { for_reading, for_writing } Lock_t;
typedef unsigned short	Ushort;

/*
**	Type definition for variable argument parameters
*/

#define	MAXVARARGS	20

typedef struct
{
	int	va_count;
	char *	va_args[MAXVARARGS+1];
}
			VarArgs;

#define	ARG(A,N)	(A)->va_args[N]
#define	FIRSTARG(A)	(A)->va_args[(A)->va_count=1,0]
#define	LASTARG(A)	(A)->va_args[(A)->va_count-1]
#define	NARGS(A)	(A)->va_count
#define	NEXTARG(A)	(A)->va_args[(A)->va_count++]

#ifdef	RECOVER

/*
**	Type definition for error recovery
*/

typedef enum { ert_finish, ert_here, ert_return, ert_exit } ERC_t;

#include	<setjmp.h>

extern jmp_buf		ErrBuf;
extern ERC_t		ErrFlag;

#define	Recover(T)	(ErrFlag=T,((T==ert_here)?setjmp(ErrBuf):0))

#endif	/* RECOVER */

/*
**	Definitions conditional on above.
*/

#if	AUTO_LOCKING == 1
#define	Lock(A,B,C)	(C==for_reading?readlock(B):writelock(B))
#define	UnLock(B)	unlock()
#else	/* AUTO_LOCKING == 1 */
#if	FLOCK == 1
#if	defined(LOCKING) && !defined(FEXLOCK) && !defined(LOCK_EX)
#ifndef	major
#include	<sys/types.h>
#ifndef	major
#define	major
#endif	/* major */
#endif
#include	<sys/file.h>
#ifndef	O_READ
#define	O_READ	O_RDONLY
#endif
#ifndef	O_WRITE
#define	O_WRITE	O_WRONLY
#endif
#endif	/* defined(LOCKING) && !defined(FEXLOCK) && !defined(LOCK_EX) */
#if BSD4 == 1 && BSD4V == 'c'
#define	Lock(A,B,C)	flock(B,C==for_writing?FEXLOCK:FSHLOCK)
#define	UnLock(B)
#else
#define	Lock(A,B,C)	flock(B,C==for_writing?LOCK_EX:LOCK_SH)
#define	UnLock(B)	flock(B, LOCK_UN)
#endif	/* BSD4 && BSD4V */
#else	/* FLOCK */
#if	SYS_LOCKING == 1
#define	Lock(A,B,C)	locking(B,1,0)
#define	UnLock(B)	locking(B,0,0)
#else	/* SYS_LOCKING */
#if	LOCKF	== 1
#define	Lock(A,B,C)	lockf_all(B,1)
#define	UnLock(B)	lockf_all(B,0)
#else	/* LOCKF */
#if	V8 == 1
#ifndef	_IOCTL_
#include	<sys/ioctl.h>
#endif	/* _IOCTL_ */
#define	Lock(A,B,C)	_Lock(A,B,C)
#define	UnLock(B)	(void)ioctl(B,FIOAUNLOCK,0)
#else	/* V8 == 1 */
#define	Lock(A,B,C)	_Lock(A,B,C)
#define	UnLock(B)	_UnLock()
#endif	/* V8 == 1 */
#endif	/* LOCKF */
#endif	/* SYS_LOCKING */
#endif	/* FLOCK */
#endif	/* AUTO_LOCKING */

/*
**	Network library routines
*/

extern int
		_Lock(),
		ExStatus,
		SetRaw(),
		SplitArg();

extern bool
		DaemonActive(),
		ErrorTty(),
		InList(),
		ReadCom(),
		SetDaemonActive(),
		crc();

extern Crc_t
		acrc();

extern char
		*Execute(),
		*ExPipeClose(),
		*ExOPipeClose(),
		*ExpandString(),
		*GetErrFile(),
		*Malloc(),
		*MatchString(),
		*NodeName(),
		*NumericArg(),
		*ReadFile(),
		**StripEnv(),
		*StripErrString(),
		*TimeString(),
		*UniqueName(),
		*UniqueUid(),
		*Version,
		*concat(),
		*newstr(),
		*newnstr(),
		*strclr(),
		*strcpyend();

extern void
		_UnLock(),
		AddCom(),
		CopyFile(),
		CopyFromComFile(),
		EchoArgs(),
		Error(),
		ExpandArgs(),
		FreeCom(),
		Mesg(),
		SMdate(),
		SetUser(),
		SysWarn(),
		Syserror(),
		Warn();

#ifdef	BUFSIZ
extern FILE	*ExecPipe();
extern FILE	*ExPipeO();
#endif	/* BUFSIZ */

/*
**	C-library routines
*/

extern int	errno;

extern char
		*bsearch(),
		*ctime(),
		*malloc(),
		*strcat(),
		*strchr(),
		*strcpy(),
		*strncpy(),
		*strpbrk(),
		*strrchr(),
		*strrpbrk(),
		*strtok();

extern long
		atol(),
		lseek();

extern ulong
		time(),
		times();
