/*
**	Copyright (c) 1986 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "@(#)peter.c	1.7 87/10/26";

/*
**	Process ``whois'' query from message received from network.
*/

#define	STDIO

#include	"global.h"
#include	"debug.h"
#include	"header.h"

#ifndef	WHOISPROG
#define	WHOISPROG	"/usr/bin/egrep"
#endif
#ifndef	WHOISFILE
#define	WHOISFILE	"/usr/pub/whois"
#endif
#ifndef	MINPATTERN
#define	MINPATTERN	2
#endif

/*
**	Parameters set from arguments.
*/

char *	Message;		/* Name of message file */
char *	Name;			/* Program invoked name */
char *	SourceNode;		/* Message originated at this node */
int	Traceflag;		/* Global tracing control */

/*
**	Miscellaneous
*/

bool	Broadcast;			/* Needed by 'ExpandArgs()' */
char *	DataName	= "query";	/* Used by ExpandArgs() */
char *	HomeNode;			/* Used by ExpandArgs() */
char *	LinkNode;			/* Used by ExpandArgs() */
int	Pid;				/* Used by UniqueName() in Exec...() */
char *	PostMaster	= POSTMASTER;
char *	SenderName	= ACSNETNAME;	/* Used by ExpandArgs() */
Time_t	StartTime;			/* Used by ExpandArgs() */
Time_t	Time;
char *	UserName;			/* Used by ExpandArgs() */

#define	Fprintf		(void)fprintf

void	finish(), mailit(), whois();



int
main(argc, argv)
	register int	argc;
	register char *	argv[];
{
	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	Pid = getpid();
	(void)time(&Time);

	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'B':
					continue;

				case 'T':
					if ( (Traceflag = atol(++*argv)) == 0 )
						Traceflag = 1;
					break;

				case 'a':
				case 'c':
					goto break2;

				case 'd':
					DataLength = atol(++*argv);
					break;

				case 'e':
					HdrEnv = ++*argv;
					goto break2;

				case 'h':
					HomeNode = ++*argv;
					goto break2;

				case 'l':
					LinkNode = ++*argv;
					goto break2;

				case 's':
					SourceNode = ++*argv;
					goto break2;

				case 't':
					goto break2;

				default:
					Trace2(1, "unrecognised flag '%c'", c);
					goto break2;
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
			Message = *argv;
	}

	if ( GetEnv(ENV_RETURNED) != NULLSTR )
	{
		mailit(GetEnv(ENV_ERR1));
		exit(0);
	}

	whois(GetEnv(ENV_HANDLER_FLAGS));

	exit(1);	/* And return message to source with result from stderr */
}



/*
**	Called from the errors routines to cleanup
*/

void
finish(error)
	int	error;
{
	(void)exit(error);
}



/*
**	Run pattern over info.
*/

void
whois(query)
	char *	query;
{
	register FILE *	fd;
	VarArgs		va;

	if
	(
		(UserName = strrchr(query, ';')) == NULLSTR
		||
		(*UserName++ = '\0', strlen(UserName) < 1)
		||
		strlen(query) < MINPATTERN
	)
	{
		Fprintf(stderr, "%s;%s\nMalformed query.\n", GetEnv(ENV_HANDLER_FLAGS), SenderName);
		return;
	}

	FIRSTARG(&va) = WHOISPROG;

#	ifdef	WHOISARGS
	ExpandArgs(&va, WHOISARGS, NULLSTR);
#	endif	WHOISARGS

	NEXTARG(&va) = query;
	NEXTARG(&va) = WHOISFILE;

	if
	(
		access(ARG(&va, 0), 1) == SYSERROR
		||
		access(LASTARG(&va), 4) == SYSERROR
	)
	{
		Fprintf(stderr, "%s;%s\nInformation not available.\n", query, UserName);
		return;
	}

	Fprintf(stderr, "%s;%s\n", query, UserName);
	(void)fflush(stderr);

	fd = ExPipeO(&va, fileno(stderr));

	if ( (query = ExOPipeClose(fd)) != NULLSTR )
		Fprintf(stderr, StripErrString(query));	/* Probably no match */
}



/*
**	Notify requester of result of query.
*/

void
mailit(query)
	register char *	query;
{
	register FILE *	fd;
	register char *	result;
	VarArgs		va;

	query = StripErrString(query);	/* Just in case remote receiver didn't */

	if
	(
		(result = strchr(query, '\n')) == NULLSTR
		||
		(*result++ = '\0', strlen(query) < (MINPATTERN+2))
		||
		(UserName = strrchr(query, ';')) == NULLSTR
		||
		(*UserName++ = '\0', strlen(UserName) < 1)
	)
	{
		result = GetEnv(ENV_ERR1);

		if ( DataLength == 0 )
		{
			Error("Malformed reply: \"%s\".", result);
			return;
		}

		UserName = ReadFile(Message);
		UserName[DataLength] = '\0';

		result = StripErrString(result);
		query = NULLSTR;
	}

	FIRSTARG(&va) = BINMAIL;

#	ifdef	BINMAILARGS
	ExpandArgs(&va, BINMAILARGS, NULLSTR);
#	endif	BINMAILARGS

	NEXTARG(&va) = UserName;

	fd = ExecPipe(&va);
	
	Fprintf
	(
		fd,
		"From %s %sSubject: result of your ``whois'' query at %s\n\n",
		PostMaster,
		ctime(&Time),
		SourceNode
	);

	if ( query != NULLSTR )
		Fprintf(fd, "Your query was \"%s\".\n", query);

	if ( strlen(result) > 4 )
	{
		Fprintf(fd, "The result was :-\n\n");
		Fprintf(fd, "%s\n", result);
	}
	else
		Fprintf(fd, "There was no match.\n");

	(void)fflush(fd);

	if ( (result = ExPipeClose(fd)) != NULLSTR )
		Error(result);
}
