/*
**	Alan Skea, Feb 1988	Modified to run over udp rather than tcp.
*/

/*
**	Derived from:
**	"ENshell.c	1.1	12/9/86";
**	Copyright (c) 1986 Phillip Nicholson, Telecom Australia
**
**	Derived from:
**	"shell.c	1.36 86/08/27";
**	Copyright (c) 1984 Piers Lauder, University of Sydney
*/

/*
**	Shell program for a "once_only" invocation of a net daemon.
**
**	SETUID => ROOT
*/

#ifndef	lint
static char	sccsid[]	= "@(#)ENshell.c	2.0	88/02/25";
#endif	lint


#define	FILE_CONTROL
#define	TERMIOCTL

#include	"global.h"
#include	"debug.h"
#include	"state.h"
#include	"caller.h"

#ifdef	BASSER

#include	"include/sys/types.h"
#include	"include/sys/socket.h"
#include	"include/netinet/in.h"
#include	"include/netdb.h"

#undef	BSIZE

#else	BASSER

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>

#endif	BASSER

#define	BSIZE	256

char *	Name;
bool	IgnoreOldPid = false;
int	Traceflag;

VarArgs	ExecArgs	=
{
	2,
	ENDAEMON,	/* Default node-node daemon name */
	"-F"		/* no fork */
};

char *		Spooldir = SPOOLDIR();

void		Args();
bool		readargs();

extern char *	ReadFile();


main(argc, argv)
	int			argc;
	char **			argv;
{
	struct sockaddr_in	peer;
	struct sockaddr_in	self;
	struct hostent *	InetPeer;
	char *			AcsPeer;
	char *			cp;
	char			buf[BSIZE];
	int			self_len	= sizeof(self);
	int			sock;
	int			peer_len	= sizeof(peer);

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	if
	(
		recvfrom(0, buf, BSIZE, 0, (struct sockaddr *)&peer, &peer_len) == -1
		||
		fork() != 0
		||
		(sock = socket(AF_INET, SOCK_DGRAM, 0)) == -1
	)
		exit(1);

	dup2(sock, 0);
	dup2(sock, 1);
	close(sock);

	if
	(
		connect(0, &peer, sizeof(peer)) == -1
		||
		getsockname(0, &self, &self_len) == -1
		||
		(InetPeer = gethostbyaddr(&peer.sin_addr, sizeof(peer.sin_addr),
			peer.sin_family)) == (struct hostent *)0
	)
		exit(1);

	self.sin_family = htons(self.sin_family);

	if (write(0, (char *)&self, sizeof(self)) == -1)
		exit(1);

	if ((cp = strchr(InetPeer->h_name, '.')) != NULLSTR)
		*cp = '\0';

	if ((AcsPeer = FindAlias(InetPeer->h_name)) == NULLSTR)
		AcsPeer = InetPeer->h_name;

#	ifdef	NICEDAEMON
	(void)nice(NICEDAEMON);
#	endif	NICEDAEMON

	(void)setgid(ACSNETGID);
	(void)setuid(ACSNETUID);

	NEXTARG(&ExecArgs) = AcsPeer;

	if
	(
		chdir(Spooldir) == SYSERROR
		||
		chdir(AcsPeer) == SYSERROR
	)
		exit(1);

	if ( !readargs(ReadFile, "enshellargs", NULLSTR) )
		(void)readargs(ReadFile, SHELLARGS, NULLSTR);

	if ( !IgnoreOldPid && DaemonActive(".", false) )
		return 0;

	(void)SetDaemonActive(".", getpid());
	(void)sleep(2);	/* Let other end start up */

	(void)execve(ARG(&ExecArgs, 0), &ARG(&ExecArgs, 0), StripEnv());
	Syserror(ARG(&ExecArgs, 0));
	exit(1);
}


void
finish(error)
	int	error;
{
	exit(error);
}


/*
**	Extract arguments using passed function on passed file,
**	and pass them to Args()
**	looking like program invoked arguments.
*/

bool
readargs(funcp, file, string)
	char *		(*funcp)();
	char *		file;
	char *		string;
{
	register char *	ap;
	VarArgs		va;

	Trace3(1, "readargs(%s, %s)", file, string);

	if ( (ap = (*funcp)(file, string)) == NULLSTR )
		return false;

	FIRSTARG(&va) = Name;

	if ( SplitArg(&va, ap) >= MAXVARARGS )
		Error("Too many arguments in \"%s\"", file);

	Args(NARGS(&va), &ARG(&va, 0));

	free(ap);

	return true;
}



/*
**	Function to process arguments.
*/

void
Args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		Trace2(1, "Args: \"%s\"", argv[1]);

		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'D':
					ARG(&ExecArgs, 0) = ++*argv;
					goto break2;

				case 'I':
					IgnoreOldPid = true;
					goto break2;

				case 'T':
					if ( (Traceflag = atoi(&(*argv)[1])) == 0 )
						Traceflag = 1;

				default:
					NEXTARG(&ExecArgs) = --*argv;
					goto break2;
				}
			}
break2:			;
		}
		else
			NEXTARG(&ExecArgs) = *argv;
	}
}
