/*
**	Run crc code over known string and value to test accuracy,
**	Then iterate over average length packet to test speed.
*/

#define	COUNT	10000

unsigned char *	String	= "this is a sample string for testing.\0\0";
unsigned short	Val	= 054616; /* And this is its known CRC */

char		BigStr[516];	/* Large enough to access every word of table */
char		OverHead[4];

main()
{
	register char *	cp;
	register long	i;
	register int	val;
	long		ohtime;
	extern long	cput();

	i = strlen(String);

	String[i] = 0xff;
	if ( String[i] != 0xff )
		printf
		(
			"WARNING: c-compiler doesn't handle (unsigned char) properly!\n"
		);

	val = crc(String, i);

	printf
	(
		"1st call of crc routine returns %d %s\n",
		val, val?"OK.":"WRONG! (should be non-zero.)"
	);

	val = (String[i] & 0xff) | ((String[i+1] & 0xff) << 8);

	if ( val == Val )
		printf("Calculated CRC correctly.\n");
	else
		printf
		(
			"BAD value for calculated CRC = 0x%x (0%o), should be 0x%x (0%o).\n",
			val, val,
			Val, Val
		);

	String[i] = Val & 0xff;
	String[i+1] = (Val >> 8) & 0xff;

	val = crc(String, i);

	printf
	(
		"2nd call of crc routine returns %d %s\n",
		val, val==0?"OK.":"WRONG! (should be zero.)"
	);

	srand(357);

	for ( cp = BigStr ; cp < &BigStr[sizeof BigStr] ; )
		*cp++ = rand()>>8;

	i = COUNT*10;
	cput();

	do
		if ( crc(OverHead, 0) )
			i = i;
	while
		( --i );

	printf
	(
		"crc routine overhead is %.1f microsecs per call.\n",
		(double)(ohtime = cput())*1000000.0/(60*COUNT*10)
	);

	ohtime /= 10;
	i = COUNT;
	cput();

	do
		if ( crc(BigStr, sizeof BigStr - 2) )
			i = i;
	while
		( --i );

	printf
	(
		"crc calculation takes %.1f microsecs per byte.\n",
		(double)(cput()-ohtime)*1000000.0/(60*COUNT*(sizeof BigStr - 2))
	);

	exit(val);
}



#include	<sys/types.h>
#include	<sys/times.h>

long
cput()
{
	register long		nt;
	static struct tms	otb;
	struct tms		tb;
	extern long		times();

	(void)times(&tb);
	nt = tb.tms_utime - otb.tms_utime;
	otb.tms_utime = tb.tms_utime;
	return nt;
}
