#!/bin/sh

PATH=/usr/ucb:/bin:/usr/bin
TMP=/tmp/acsW.$$
HOST=`hostname`
WHOISFILE=${2-/usr/pub/whois}
PATTERN="$1"

trap 'rm -f ${TMP} ; echo "Interrupted!" 1>&2 ; exit 1' 1 2 3 13 15

if /usr/bin/egrep "$PATTERN" ${WHOISFILE} > ${TMP}
then
	# stupid sh bug...  next line should say "`wc -l <$TMP`"
	MATCHES=`cat ${TMP} | wc -l`
	if [ ${MATCHES} -le 5 ]
	then
		# not many matches, return lots of info
		echo "Summary information:"
		echo
		sed -e '/^.........*:/!s/:/	:/' -e 's/:/	/' ${TMP}

		echo
		echo
		echo "Details of those users:"
		echo
		/usr/ucb/finger -m -p `/bin/sed 's/:.*//' ${TMP}`
		rm -f ${TMP}
		exit 0
	fi

	if [ ${MATCHES} -gt 50 ]
	then
		# pattern too ambiguous - just crap out
		rm -f ${TMP}
		echo "
Your request for '${PATTERN}' produces ${MATCHES} matches at ${HOST}.
Please try and be more specific!" 1>&2
		exit 1
	fi

	echo '
Your query produced lots of matches - if you want more
information on any of these users, please send a request
that will match exactly one of them.

An easy way to do that, is to look for the pattern at the
start of the line, by using an anchored search, as

	acswhois '"'"'^name:@'"${HOST}'"'

Note the leading "^" and terminating ":" on the user name to match.
'
	sed -e '/^.........*:/!s/:/	:/' -e 's/:/	/' ${TMP}
	rm -f ${TMP}
	exit 0
fi

rm -f ${TMP}
echo "No users match '$PATTERN' at $HOST" 1>&2
exit 1
