#
#	sum_accts.sh	- summarise the accounting file 
#	
#	Summarise the accounting file produced by the link filter.
#

#
#	Arg processing
#

if [ $# != 1 ]
then
	echo "Usage: $0 node"
	exit 1
fi
node=$1

#
#	A few definitions
#

ACCTS_DIR=/usr/spool/ACSnet/_accts
accts_file=${ACCTS_DIR}/${node}.acct
accts_sum=${ACCTS_DIR}/${node}.sum
accts_tmp=${ACCTS_DIR}/${node}.tmp
accts_lck=${ACCTS_DIR}/${node}.l
tmp_accts=/tmp/acs$$
trap "rm -f ${tmp_accts} ${accts_tmp} ${accts_lck}; exit 1;" 0 1 2 13 15

#
#	lock the account file, copy it, truncate it, then unlock it.
#

cp /dev/null ${accts_lck}
cat ${accts_sum} ${accts_file} > ${accts_tmp}
cp /dev/null ${accts_file}
rm -f ${accts_lck}

#
#	now summarise and add the old summary
#

sort ${accts_tmp} | awk -f sum_accts.awk > ${tmp_accts}
cp ${tmp_accts} ${accts_sum}

#
#	clean up
#

rm ${tmp_accts} ${accts_tmp}
